/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.operations.detection.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.modelversioning.core.conditions.engines.UnsupportedConditionLanguage;
import org.modelversioning.core.diff.propagation.IPropagationMappingProvider;
import org.modelversioning.core.diff.propagation.impl.DiffPropagationEngine;
import org.modelversioning.core.diff.service.DiffService;
import org.modelversioning.core.match.MatchException;
import org.modelversioning.core.match.service.MatchService;
import org.modelversioning.core.match.util.MatchUtil;
import org.modelversioning.operations.detection.impl.OperationDetectionEngineImpl;
import org.modelversioning.operations.detection.operationoccurrence.OperationOccurrence;

public class IterativeOperationDetectionEngineImpl
extends OperationDetectionEngineImpl
implements IPropagationMappingProvider {
    private static final int MAX_ITERATION_DEPTH = 5;
    private ResourceSet resourceSet;
    private MatchService matchService;
    private DiffService diffService;
    private DiffPropagationEngine diffPropagationEngine = new DiffPropagationEngine();
    private Resource originResource;
    private Resource finalVersionResource;
    private MatchModel matchModel;

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public MatchService getMatchService() {
        return this.matchService;
    }

    public void setMatchService(MatchService matchService) {
        this.matchService = matchService;
    }

    public DiffService getDiffService() {
        return this.diffService;
    }

    public void setDiffService(DiffService diffService) {
        this.diffService = diffService;
    }

    public void setOriginResource(Resource originResource) {
        this.originResource = originResource;
    }

    public void setRevisedResource(Resource revisedResource) {
        this.finalVersionResource = revisedResource;
    }

    @Override
    public Set<OperationOccurrence> findOccurrences(ComparisonResourceSnapshot comparisonSnapshot) throws UnsupportedConditionLanguage {
        this.diffPropagationEngine.setAddContainerOnly(true);
        this.matchModel = comparisonSnapshot.getMatch();
        HashSet<OperationOccurrence> foundOccurrences = new HashSet<OperationOccurrence>();
        foundOccurrences.addAll(this.doFindNextOccurrences(new HashSet<OperationOccurrence>(), comparisonSnapshot, 1));
        return foundOccurrences;
    }

    private Set<OperationOccurrence> doFindNextOccurrences(Set<OperationOccurrence> lastOccurrences, ComparisonResourceSnapshot comparisonSnapshot, int iterationDepth) {
        for (OperationOccurrence occurrence : lastOccurrences) {
            try {
                this.diffPropagationEngine.propagate(new HashSet<DiffElement>(occurrence.getHiddenChanges()), comparisonSnapshot.getMatch(), (IPropagationMappingProvider)this, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            ComparisonResourceSnapshot intermediateCS = null;
            intermediateCS = iterationDepth > 1 ? this.diff(this.getOriginResource(comparisonSnapshot), this.getRevisedResource(comparisonSnapshot)) : comparisonSnapshot;
            Set<OperationOccurrence> foundOccurrences = super.findOccurrences(intermediateCS);
            for (OperationOccurrence oo : foundOccurrences) {
                oo.setOrderHint(iterationDepth);
            }
            if (foundOccurrences.size() > 0 && iterationDepth < 5) {
                foundOccurrences.addAll(this.doFindNextOccurrences(new HashSet<OperationOccurrence>(foundOccurrences), intermediateCS, iterationDepth + 1));
            }
            return foundOccurrences;
        }
        catch (MatchException e) {
            e.printStackTrace();
        }
        catch (UnsupportedConditionLanguage e) {
            e.printStackTrace();
        }
        return Collections.emptySet();
    }

    private Resource getOriginResource(ComparisonResourceSnapshot comparisonSnapshot) {
        return this.originResource;
    }

    private Resource getRevisedResource(ComparisonResourceSnapshot comparisonSnapshot) {
        return this.finalVersionResource;
    }

    private ComparisonResourceSnapshot diff(Resource originResource, Resource revisedResource) throws MatchException {
        MatchModel matchModel = this.matchService.generateMatchModel(originResource, revisedResource);
        ComparisonResourceSnapshot intermediateCS = this.diffService.generateComparisonResourceSnapshot(matchModel);
        return intermediateCS;
    }

    @Override
    public Collection<EObject> getCounterpartObjects(EObject eObject) {
        if (eObject == null) {
            return Collections.emptySet();
        }
        HashSet<EObject> counterparts = new HashSet<EObject>();
        EObject counterpart = eObject;
        if (!this.isInOriginModel(eObject)) {
            counterpart = MatchUtil.getMatchingObject(eObject, this.matchModel);
        }
        counterparts.add(counterpart);
        return counterparts;
    }

    @Override
    public EObject getCounterpartObject(EObject eObject, DiffElement diffElement, EObject context) {
        if (eObject == null) {
            return null;
        }
        EObject counterpart = eObject;
        if (!this.isInOriginModel(eObject)) {
            counterpart = MatchUtil.getMatchingObject(eObject, this.matchModel);
        }
        return counterpart;
    }

    @Override
    public boolean isInOriginModel(EObject object) {
        if (object == null) {
            return false;
        }
        return this.finalVersionResource != object.eResource();
    }
}

