/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.operations.detection.impl;

import java.net.BindException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.metamodel.Side;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.core.conditions.Template;
import org.modelversioning.core.conditions.engines.ITemplateBinding;
import org.modelversioning.core.conditions.engines.ITemplateBindings;
import org.modelversioning.core.conditions.engines.impl.TemplateBindingImpl;
import org.modelversioning.core.conditions.util.ConditionsUtil;
import org.modelversioning.core.diff.DiffElementTypeComparator;
import org.modelversioning.core.diff.DiffSignature;
import org.modelversioning.core.diff.util.DiffUtil;
import org.modelversioning.core.match.util.MatchUtil;
import org.modelversioning.operations.OperationSignature;
import org.modelversioning.operations.TemplateAffection;
import org.modelversioning.operations.detection.operationoccurrence.OperationOccurrence;
import org.modelversioning.operations.util.OperationsUtil;

public class OperationChangeMap {
    private DiffElementTypeComparator comparator = DiffElementTypeComparator.getInstance();
    private OperationSignature operationSignature;
    private DiffSignature inputSignature;
    private Map<DiffElement, Set<DiffElement>> changeMap = new HashMap<DiffElement, Set<DiffElement>>();
    private MatchModel matchModel;

    public OperationChangeMap(OperationSignature operationSignature, DiffSignature inputSignature, MatchModel matchModel) {
        this.operationSignature = operationSignature;
        this.inputSignature = inputSignature;
        this.matchModel = matchModel;
        this.initializeChangeMap();
    }

    /*
     * Unable to fully structure code
     */
    private void initializeChangeMap() {
        Assert.isNotNull(this.operationSignature);
        Assert.isNotNull(this.inputSignature);
        inputDiffList = this.inputSignature.getSignatureElements();
        previousDiffElement = null;
        lastCheckedIndex = 0;
        for (DiffElement operationDiffElement : this.operationSignature.getSignatureElements()) {
            if (previousDiffElement == null || this.comparator.compare(operationDiffElement, previousDiffElement) != 0) ** GOTO lbl14
            for (DiffElement inputDiffElement : this.changeMap.get(previousDiffElement)) {
                this.addChangeToChangeMap(operationDiffElement, inputDiffElement);
            }
            previousDiffElement = operationDiffElement;
            continue;
lbl-1000:
            // 1 sources

            {
                ++lastCheckedIndex;
lbl14:
                // 2 sources

                ** while (lastCheckedIndex < inputDiffList.size() && this.comparator.compare((DiffElement)inputDiffList.get((int)lastCheckedIndex), (DiffElement)operationDiffElement) != 0)
            }
lbl15:
            // 2 sources

            while (lastCheckedIndex < inputDiffList.size() && this.comparator.compare(inputDiffList.get(lastCheckedIndex), operationDiffElement) == 0) {
                this.addChangeToChangeMap(operationDiffElement, inputDiffList.get(lastCheckedIndex));
                ++lastCheckedIndex;
            }
            previousDiffElement = operationDiffElement;
        }
    }

    public Map<DiffElement, Set<DiffElement>> getChangeMap() {
        return this.changeMap;
    }

    private void addChangeToChangeMap(DiffElement operationChange, DiffElement inputChange) {
        Set<Object> inputDiffSet = null;
        if (!this.changeMap.containsKey(operationChange)) {
            inputDiffSet = new HashSet();
            this.changeMap.put(operationChange, inputDiffSet);
        } else {
            inputDiffSet = this.changeMap.get(operationChange);
        }
        inputDiffSet.add(inputChange);
    }

    private void removeChangeFromChangeMap(DiffElement operationChange, DiffElement inputChange) {
        Set<DiffElement> set = this.changeMap.get(operationChange);
        set.remove(inputChange);
        if (set.size() < 1) {
            this.changeMap.remove(operationChange);
        }
    }

    public OperationSignature getOperationSignature() {
        return this.operationSignature;
    }

    public DiffSignature getInputSignature() {
        return this.inputSignature;
    }

    public void removeChanges(OperationOccurrence operationOccurrence) {
        for (Set<DiffElement> elements : this.changeMap.values()) {
            elements.removeAll(operationOccurrence.getHiddenChanges());
        }
        Set<DiffElement> operationDiffs = this.changeMap.keySet();
        HashSet<DiffElement> operationDiffsToRemove = new HashSet<DiffElement>();
        for (DiffElement operationDiff : operationDiffs) {
            if (this.changeMap.get(operationDiff).size() >= 1) continue;
            operationDiffsToRemove.add(operationDiff);
        }
        for (DiffElement toRemove : operationDiffsToRemove) {
            this.changeMap.remove(toRemove);
        }
    }

    public boolean isOperationPossible() {
        for (DiffElement diffElement : this.operationSignature.getSignatureElements()) {
            if (this.changeMap.get(diffElement) != null && this.changeMap.get(diffElement).size() >= 1) continue;
            return false;
        }
        return true;
    }

    public boolean isOperationPossibleExlcudingOperations(Set<OperationOccurrence> operations) {
        HashSet<DiffElement> excludingDiffElements = new HashSet<DiffElement>();
        for (OperationOccurrence occurrence : operations) {
            excludingDiffElements.addAll(occurrence.getHiddenChanges());
        }
        for (DiffElement diffElement : this.operationSignature.getSignatureElements()) {
            if (this.changeMap.get(diffElement) == null || this.changeMap.get(diffElement).size() < 1) {
                return false;
            }
            HashSet diffElements = new HashSet(this.changeMap.get(diffElement));
            diffElements.removeAll(excludingDiffElements);
            if (diffElements.size() >= 1) continue;
            return false;
        }
        return true;
    }

    private ITemplateBinding createEmptyTemplateBinding() {
        return new TemplateBindingImpl();
    }

    public ITemplateBinding derivePreConditionCandidateBinding() {
        ITemplateBinding templateBinding = this.createEmptyTemplateBinding();
        for (Template template : this.operationSignature.getAffectedPreconditionTemplates()) {
            HashMap inputObjectToChangesMap = new HashMap();
            Set<TemplateAffection> affections = this.operationSignature.getAffectingChanges(template);
            for (TemplateAffection templateAffection : affections) {
                for (DiffElement inputDiffElement : this.changeMap.get(templateAffection.getDiffElement())) {
                    EObject inputObject = this.getAffectedObject(templateAffection, inputDiffElement, true);
                    if (inputObject == null) continue;
                    Set<TemplateAffection> mappedAffections = null;
                    if (!inputObjectToChangesMap.containsKey(inputObject)) {
                        mappedAffections = new HashSet();
                        inputObjectToChangesMap.put(inputObject, mappedAffections);
                    } else {
                        mappedAffections = (Set)inputObjectToChangesMap.get(inputObject);
                    }
                    mappedAffections.add(templateAffection);
                }
            }
            for (Map.Entry entry : inputObjectToChangesMap.entrySet()) {
                if (!((Set)entry.getValue()).containsAll(affections)) continue;
                templateBinding.add(template, (EObject)entry.getKey());
                this.bindParents(templateBinding, template, (EObject)entry.getKey());
            }
        }
        return templateBinding;
    }

    private EObject getAffectedObject(TemplateAffection affection, DiffElement diffElement, boolean rightSide) {
        EObject inputObject = null;
        switch (affection.getAffectionKind()) {
            case ELEMENT: {
                inputObject = rightSide ? DiffUtil.getRightElement(diffElement) : DiffUtil.getLeftElement(diffElement);
                break;
            }
            case PARENT: {
                inputObject = rightSide ? DiffUtil.getRightParent(diffElement) : DiffUtil.getLeftParent(diffElement);
                break;
            }
            case TARGET: {
                inputObject = rightSide ? DiffUtil.getRightTarget(diffElement) : DiffUtil.getLeftTarget(diffElement);
                break;
            }
            case OPPOSITE_TARGET: {
                EObject eObject = inputObject = rightSide ? DiffUtil.getLeftTarget(diffElement) : DiffUtil.getRightTarget(diffElement);
            }
        }
        if (inputObject != null) {
            if (rightSide && Side.RIGHT.equals(MatchUtil.getSide(inputObject, this.matchModel))) {
                return inputObject;
            }
            if (!rightSide && Side.LEFT.equals(MatchUtil.getSide(inputObject, this.matchModel))) {
                return inputObject;
            }
            return MatchUtil.getMatchingObject(inputObject, this.matchModel);
        }
        return inputObject;
    }

    private Map<DiffElement, Set<DiffElement>> addEssentialChangesFromPostconditions(ITemplateBindings postConditionBinding, Map<DiffElement, Set<DiffElement>> preConditionChangeMap) {
        Map<DiffElement, Set<DiffElement>> essentialChangeMap = preConditionChangeMap;
        for (Template template : this.operationSignature.getAffectedPostconditionTemplates()) {
            Set<EObject> boundObjects = postConditionBinding.getBoundObjects(template);
            if (boundObjects == null || boundObjects.size() < 1) {
                throw new IllegalArgumentException("Specified postcondition binding is incomplete");
            }
            for (DiffElement operationDiffElement : this.changeMap.keySet()) {
                if (!(operationDiffElement instanceof ModelElementChangeLeftTarget)) continue;
                for (DiffElement inputAddition : this.changeMap.get(operationDiffElement)) {
                    EObject inputObject;
                    if (!(inputAddition instanceof ModelElementChangeLeftTarget) || (inputObject = ((ModelElementChangeLeftTarget)inputAddition).getLeftElement()) == null || !boundObjects.contains(inputObject)) continue;
                    Set<Object> set = null;
                    if (!essentialChangeMap.containsKey(operationDiffElement)) {
                        set = new HashSet();
                        essentialChangeMap.put(operationDiffElement, set);
                    } else {
                        set = essentialChangeMap.get(operationDiffElement);
                    }
                    set.add(inputAddition);
                }
            }
        }
        return essentialChangeMap;
    }

    private Map<DiffElement, Set<DiffElement>> getEssentialChangesFromPreconditions(ITemplateBindings preConditionBinding, boolean regardOnlyElement) {
        HashMap<DiffElement, Set<DiffElement>> essentialChangeMap = new HashMap<DiffElement, Set<DiffElement>>();
        for (Template template : this.operationSignature.getAffectedPreconditionTemplates()) {
            Set<EObject> boundObjects = preConditionBinding.getBoundObjects(template);
            if (boundObjects == null || boundObjects.size() < 1) {
                throw new IllegalArgumentException("Specified precondition binding is incomplete");
            }
            for (TemplateAffection affection : this.operationSignature.getAffectingChanges(template)) {
                for (DiffElement inputDiffElement : this.changeMap.get(affection.getDiffElement())) {
                    EObject inputObject;
                    if (regardOnlyElement && !TemplateAffection.AffectionKind.ELEMENT.equals((Object)affection.getAffectionKind()) || (inputObject = this.getAffectedObject(affection, inputDiffElement, true)) == null || !boundObjects.contains(inputObject)) continue;
                    Set<DiffElement> set = null;
                    if (!essentialChangeMap.containsKey(affection.getDiffElement())) {
                        set = new HashSet();
                        essentialChangeMap.put(affection.getDiffElement(), set);
                    } else {
                        set = (Set)essentialChangeMap.get(affection.getDiffElement());
                    }
                    set.add(inputDiffElement);
                }
            }
        }
        return essentialChangeMap;
    }

    private Map<DiffElement, Set<DiffElement>> getEssentialChanges(ITemplateBindings preConditionBinding, ITemplateBindings postConditionBinding) {
        Map<DiffElement, Set<DiffElement>> changesFromPreconditions = this.getEssentialChangesFromPreconditions(preConditionBinding, true);
        return this.addEssentialChangesFromPostconditions(postConditionBinding, changesFromPreconditions);
    }

    public Collection<DiffElement> getChanges(ITemplateBindings preConditionBinding, ITemplateBindings postConditionBinding) {
        HashSet changes = new HashSet();
        Map<DiffElement, Set<DiffElement>> essentialChanges = this.getEssentialChanges(preConditionBinding, postConditionBinding);
        for (DiffElement operationDiffElement : essentialChanges.keySet()) {
            changes.addAll(essentialChanges.get(operationDiffElement));
        }
        return Collections.unmodifiableCollection(changes);
    }

    public ITemplateBinding derivePostConditionBinding(ITemplateBindings preConditionBinding, MatchModel matchModel) throws BindException {
        ITemplateBinding postConditionCandidateBinding = OperationsUtil.derivePostConditionTemplateBinding(preConditionBinding, matchModel, this.operationSignature.getOperationSpecification());
        Set<Template> unboundTemplates = ConditionsUtil.getUnboundTemplates(postConditionCandidateBinding, this.operationSignature.getOperationSpecification().getPostconditions());
        if (unboundTemplates.size() == 0) {
            return postConditionCandidateBinding;
        }
        Map<DiffElement, Set<DiffElement>> changesFromPreconditions = this.getEssentialChangesFromPreconditions(preConditionBinding, false);
        for (Template template : unboundTemplates) {
            HashMap inputObjectToAffectionsMap = new HashMap();
            Set<TemplateAffection> affections = this.operationSignature.getAffectingChanges(template);
            for (TemplateAffection templateAffection : affections) {
                if (changesFromPreconditions.get(templateAffection.getDiffElement()) == null) {
                    throw new BindException("Post condition binding could not be completed for the specified precondition binding");
                }
                for (DiffElement inputDiffElement : changesFromPreconditions.get(templateAffection.getDiffElement())) {
                    EObject inputObject = this.getAffectedObject(templateAffection, inputDiffElement, false);
                    if (inputObject == null) continue;
                    List<TemplateAffection> mappedAffections = null;
                    if (!inputObjectToAffectionsMap.containsKey(inputObject)) {
                        mappedAffections = new ArrayList();
                        inputObjectToAffectionsMap.put(inputObject, mappedAffections);
                    } else {
                        mappedAffections = (List)inputObjectToAffectionsMap.get(inputObject);
                    }
                    mappedAffections.add(templateAffection);
                }
            }
            for (Map.Entry entry : inputObjectToAffectionsMap.entrySet()) {
                if (!((List)entry.getValue()).containsAll(affections)) continue;
                postConditionCandidateBinding.add(template, (EObject)entry.getKey());
                this.bindParents(postConditionCandidateBinding, template, (EObject)entry.getKey());
            }
        }
        return postConditionCandidateBinding;
    }

    private void bindParents(ITemplateBinding templateBinding, Template template, EObject eObject) {
        while ((template = template.getParentTemplate()) != null && !templateBinding.getBoundObjects(template).contains(eObject) && (eObject = eObject.eContainer()) != null) {
            templateBinding.add(template, eObject);
        }
    }
}

