/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.operations.detection.impl;

import java.net.BindException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.core.conditions.ConditionsModel;
import org.modelversioning.core.conditions.engines.IConditionEvaluationEngine;
import org.modelversioning.core.conditions.engines.ITemplateBinding;
import org.modelversioning.core.conditions.engines.ITemplateBindings;
import org.modelversioning.core.conditions.engines.UnsupportedConditionLanguage;
import org.modelversioning.core.conditions.engines.impl.ConditionsEvaluationEngineImpl;
import org.modelversioning.core.conditions.engines.impl.TemplateBindingImpl;
import org.modelversioning.core.conditions.templatebindings.util.TemplateBindingsUtil;
import org.modelversioning.core.diff.DiffElementTypeComparator;
import org.modelversioning.core.diff.DiffSignature;
import org.modelversioning.operations.OperationSignature;
import org.modelversioning.operations.OperationSpecification;
import org.modelversioning.operations.detection.IOperationDetectionEngine;
import org.modelversioning.operations.detection.impl.DiffSignatureSizeComparator;
import org.modelversioning.operations.detection.impl.OperationChangeMap;
import org.modelversioning.operations.detection.operationoccurrence.OperationOccurrence;
import org.modelversioning.operations.detection.operationoccurrence.OperationoccurrenceFactory;
import org.modelversioning.operations.repository.ModelOperationRepository;
import org.modelversioning.operations.util.OperationsUtil;

public class OperationDetectionEngineImpl
implements IOperationDetectionEngine {
    private ModelOperationRepository repository = null;
    private Set<OperationSignature> currentOperationSignatures = null;
    private String currentModelingLanguage;
    private DiffElementTypeComparator comparator = DiffElementTypeComparator.getInstance();
    private OperationoccurrenceFactory operationOccurrenceFactory = OperationoccurrenceFactory.eINSTANCE;
    private IConditionEvaluationEngine evaluationEngine = null;

    public OperationDetectionEngineImpl() {
        this.evaluationEngine = new ConditionsEvaluationEngineImpl();
    }

    public OperationDetectionEngineImpl(IConditionEvaluationEngine conditionEvaluationEngine) {
        this.evaluationEngine = conditionEvaluationEngine;
    }

    @Override
    public void setOperationsRepository(ModelOperationRepository repo) {
        this.repository = repo;
    }

    @Override
    public IConditionEvaluationEngine getEvaluationEngine() {
        return this.evaluationEngine;
    }

    @Override
    public void setEvaluationEngine(IConditionEvaluationEngine evaluationEngine) {
        this.evaluationEngine = evaluationEngine;
    }

    @Override
    public Set<OperationOccurrence> findOccurrences(ComparisonResourceSnapshot comparisonSnapshot) throws UnsupportedConditionLanguage {
        this.currentModelingLanguage = this.getModelingLanguage(comparisonSnapshot);
        if (this.repository == null || this.repository.getRegisteredOperationSpecifications(this.currentModelingLanguage).size() < 1) {
            return Collections.emptySet();
        }
        DiffSignature inputSignature = new DiffSignature(comparisonSnapshot.getDiff());
        List<OperationSpecification> preSelection = this.makePreSelection(inputSignature);
        Set<OperationOccurrence> performedOperations = this.checkPreselectedOccurrences(inputSignature, preSelection, comparisonSnapshot.getMatch());
        return performedOperations;
    }

    private Set<OperationOccurrence> checkPreselectedOccurrences(DiffSignature inputSignature, List<OperationSpecification> preSelection, MatchModel matchModel) throws UnsupportedConditionLanguage {
        ArrayList<OperationSignature> operationSignatures = new ArrayList<OperationSignature>();
        for (OperationSpecification os : preSelection) {
            OperationSignature operationSignature = new OperationSignature(os);
            operationSignatures.add(operationSignature);
        }
        Collections.sort(operationSignatures, new DiffSignatureSizeComparator());
        HashSet<OperationOccurrence> performedOperations = new HashSet<OperationOccurrence>();
        for (OperationSignature operationSignature : operationSignatures) {
            OperationChangeMap operationChangeMap = new OperationChangeMap(operationSignature, inputSignature, matchModel);
            for (OperationOccurrence otherOccurrence : performedOperations) {
                operationChangeMap.removeChanges(otherOccurrence);
            }
            if (!operationChangeMap.isOperationPossible()) continue;
            ITemplateBinding preconditionCandidateBinding = operationChangeMap.derivePreConditionCandidateBinding();
            this.prepareEvaluationEngine(operationSignature.getOperationSpecification().getPreconditions());
            ITemplateBindings preConditionBinding = this.evaluationEngine.findTemplateBinding(this.createEmptyTemplateBinding(), preconditionCandidateBinding);
            if (!preConditionBinding.validate().isOK()) continue;
            Set<ITemplateBindings> uniquePreConditionBindings = OperationsUtil.splitToUniqueBindings(preConditionBinding, operationSignature.getOperationSpecification());
            for (ITemplateBindings uniquePreConditionBinding : uniquePreConditionBindings) {
                if (!operationChangeMap.isOperationPossibleExlcudingOperations(performedOperations)) continue;
                try {
                    ITemplateBinding postconditionCandidateBinding = operationChangeMap.derivePostConditionBinding(uniquePreConditionBinding, matchModel);
                    this.prepareEvaluationEngine(operationSignature.getOperationSpecification().getPostconditions());
                    this.evaluationEngine.registerRelatedTemplateBinding(OperationsUtil.INITIAL_PREFIX, uniquePreConditionBinding);
                    this.evaluationEngine.isComplete(postconditionCandidateBinding);
                    ITemplateBindings postConditionBinding = this.evaluationEngine.findTemplateBinding(this.createEmptyTemplateBinding(), postconditionCandidateBinding);
                    if (!postConditionBinding.validate().isOK()) continue;
                    OperationOccurrence opOccurrence = this.operationOccurrenceFactory.createOperationOccurrence();
                    opOccurrence.setAppliedOperation(operationSignature.getOperationSpecification());
                    opOccurrence.setAppliedOperationId(OperationsUtil.getId(operationSignature.getOperationSpecification()));
                    opOccurrence.setAppliedOperationName(operationSignature.getOperationSpecification().getName());
                    Collection<DiffElement> hiddenChanges = operationChangeMap.getChanges(uniquePreConditionBinding, postConditionBinding);
                    opOccurrence.getHideElements().addAll(hiddenChanges);
                    opOccurrence.getHiddenChanges().clear();
                    opOccurrence.getHiddenChanges().addAll(hiddenChanges);
                    for (DiffElement change : hiddenChanges) {
                        change.getIsHiddenBy().add(opOccurrence);
                    }
                    opOccurrence.setPostConditionBinding(TemplateBindingsUtil.convert(postConditionBinding));
                    opOccurrence.setPreConditionBinding(TemplateBindingsUtil.convert(uniquePreConditionBinding));
                    this.evaluationEngine.registerRelatedTemplateBinding(OperationsUtil.INITIAL_PREFIX, uniquePreConditionBinding);
                    this.evaluationEngine.registerRelatedTemplateBinding(OperationsUtil.REVISED_PREFIX, postConditionBinding);
                    opOccurrence.setTitle(this.evaluationEngine.replaceTemplateValues(operationSignature.getOperationSpecification().getTitleTemplate(), uniquePreConditionBinding));
                    operationChangeMap.removeChanges(opOccurrence);
                    performedOperations.add(opOccurrence);
                }
                catch (BindException bindException) {}
            }
        }
        return performedOperations;
    }

    private void prepareEvaluationEngine(ConditionsModel conditionsModel) throws UnsupportedConditionLanguage {
        this.evaluationEngine.setConditionsModel(conditionsModel);
    }

    private ITemplateBinding createEmptyTemplateBinding() {
        return new TemplateBindingImpl();
    }

    private List<OperationSpecification> makePreSelection(DiffSignature inputSignature) {
        this.initializeRepositoryOperationSignatures();
        for (DiffElement currentDiffElement : inputSignature.getSignatureElements()) {
            HashSet<DiffSignature> impossibleSpecifications = new HashSet<DiffSignature>();
            for (DiffSignature diffSignature : this.currentOperationSignatures) {
                if (diffSignature.getSignatureElements().isEmpty()) continue;
                DiffElement firstDiffElement = diffSignature.getSignatureElements().iterator().next();
                int comparation = this.comparator.compare(firstDiffElement, currentDiffElement);
                if (comparation < 0) {
                    impossibleSpecifications.add(diffSignature);
                    continue;
                }
                if (comparation != 0) continue;
                diffSignature.getSignatureElements().remove(firstDiffElement);
            }
            this.currentOperationSignatures.removeAll(impossibleSpecifications);
        }
        ArrayList<OperationSpecification> preSelection = new ArrayList<OperationSpecification>();
        for (OperationSignature oSignature : this.currentOperationSignatures) {
            if (oSignature.getSignatureElements().size() != 0) continue;
            preSelection.add(oSignature.getOperationSpecification());
        }
        return preSelection;
    }

    private void initializeRepositoryOperationSignatures() {
        this.currentOperationSignatures = new HashSet<OperationSignature>();
        for (OperationSpecification specification : this.repository.getRegisteredOperationSpecifications(this.currentModelingLanguage)) {
            OperationSignature operationSignature = new OperationSignature(specification);
            this.currentOperationSignatures.add(operationSignature);
        }
    }

    private String getModelingLanguage(ComparisonResourceSnapshot comparisonSnapshot) {
        Assert.isTrue(comparisonSnapshot.getDiff().getLeftRoots().size() > 0, "Left model may not be empty");
        return ((EObject)comparisonSnapshot.getDiff().getLeftRoots().get(0)).eClass().getEPackage().getNsURI();
    }
}

