/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.operations.detection.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.core.util.EcoreUtil;
import org.modelversioning.operations.detection.operationoccurrence.OperationOccurrence;

public class OperationOccurrenceWeaver {
    public void weaveOperationOccurrence(OperationOccurrence occurrence, ComparisonResourceSnapshot comparisonSnapshot) {
        EList<DiffElement> changes = occurrence.getHiddenChanges();
        EObject topLevelChange = null;
        int minParentCount = 0;
        for (DiffElement change : changes) {
            if (topLevelChange == null) {
                topLevelChange = change;
                minParentCount = EcoreUtil.createParentList(change).size();
                continue;
            }
            int currentParentCount = EcoreUtil.createParentList(change).size();
            if (currentParentCount >= minParentCount) continue;
            topLevelChange = change;
            minParentCount = currentParentCount;
        }
        if (topLevelChange != null) {
            EObject container = topLevelChange.eContainer();
            if (container instanceof DiffElement) {
                DiffElement containerDiff = (DiffElement)container;
                containerDiff.getSubDiffElements().add(occurrence);
            } else {
                this.addToRoot(occurrence, comparisonSnapshot);
            }
        } else {
            this.addToRoot(occurrence, comparisonSnapshot);
        }
    }

    private void addToRoot(OperationOccurrence occurrence, ComparisonResourceSnapshot comparisonSnapshot) {
        comparisonSnapshot.getDiff().getDifferences().add(occurrence);
    }
}

