/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.operations.detection.service;

import java.util.Set;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.modelversioning.core.conditions.engines.IConditionEvaluationEngine;
import org.modelversioning.core.conditions.engines.UnsupportedConditionLanguage;
import org.modelversioning.core.conditions.engines.impl.ConditionsEvaluationEngineImpl;
import org.modelversioning.operations.detection.IOperationDetectionEngine;
import org.modelversioning.operations.detection.OperationDetectionPlugin;
import org.modelversioning.operations.detection.impl.OperationDetectionEngineImpl;
import org.modelversioning.operations.detection.impl.OperationOccurrenceWeaver;
import org.modelversioning.operations.detection.operationoccurrence.OperationOccurrence;
import org.modelversioning.operations.repository.ModelOperationRepository;
import org.modelversioning.operations.repository.ModelOperationRepositoryPlugin;

public class OperationDetectionService {
    private ModelOperationRepository modelOperationRepository = null;
    private IConditionEvaluationEngine conditionEvaluationEngine = null;
    private IOperationDetectionEngine operationDetectionEngine = null;

    public void findAndAddOperationOccurrences(ComparisonResourceSnapshot comparisonResourceSnapshot) {
        try {
            IOperationDetectionEngine detectionEngine = this.getOperationDetectionEngine();
            detectionEngine.setOperationsRepository(this.getModelOperationRepository());
            OperationOccurrenceWeaver weaver = new OperationOccurrenceWeaver();
            Set<OperationOccurrence> occurrences = detectionEngine.findOccurrences(comparisonResourceSnapshot);
            for (OperationOccurrence occurrence : occurrences) {
                weaver.weaveOperationOccurrence(occurrence, comparisonResourceSnapshot);
            }
        }
        catch (UnsupportedConditionLanguage e) {
            Status status = new Status(4, "org.modelversioning.operations.detection", "Unsupported condition language in registered operation specification.", e);
            OperationDetectionPlugin.getDefault().getLog().log(status);
        }
    }

    public ModelOperationRepository getModelOperationRepository() {
        if (this.modelOperationRepository == null) {
            this.modelOperationRepository = ModelOperationRepositoryPlugin.getDefault().getOperationRepository();
        }
        return this.modelOperationRepository;
    }

    public void setModelOperationRepository(ModelOperationRepository modelOperationRepository) {
        this.modelOperationRepository = modelOperationRepository;
    }

    public IConditionEvaluationEngine getConditionEvaluationEngine() {
        if (this.conditionEvaluationEngine == null) {
            this.conditionEvaluationEngine = new ConditionsEvaluationEngineImpl();
        }
        return this.conditionEvaluationEngine;
    }

    public void setConditionEvaluationEngine(IConditionEvaluationEngine conditionEvaluationEngine) {
        this.conditionEvaluationEngine = conditionEvaluationEngine;
    }

    public IOperationDetectionEngine getOperationDetectionEngine() {
        if (this.operationDetectionEngine == null) {
            this.operationDetectionEngine = new OperationDetectionEngineImpl(this.getConditionEvaluationEngine());
        }
        return this.operationDetectionEngine;
    }

    public void setOperationDetectionEngine(IOperationDetectionEngine operationDetectionEngine) {
        this.operationDetectionEngine = operationDetectionEngine;
    }
}

