/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.operations.engines.impl;

import java.util.Collection;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.modelversioning.core.conditions.ConditionsModel;
import org.modelversioning.core.conditions.engines.IConditionGenerationEngine;
import org.modelversioning.core.conditions.engines.impl.ConditionsGenerationEngineImpl;
import org.modelversioning.core.diff.service.DiffService;
import org.modelversioning.core.match.MatchException;
import org.modelversioning.core.match.service.MatchService;
import org.modelversioning.operations.NegativeApplicationCondition;
import org.modelversioning.operations.OperationSpecification;
import org.modelversioning.operations.OperationsFactory;
import org.modelversioning.operations.SpecificationState;
import org.modelversioning.operations.engines.IOperationGenerationEngine;

public class OperationGenerationEngineImpl
implements IOperationGenerationEngine {
    private static final String NAC_DEFAULT_NAME = "New NAC";
    private IConditionGenerationEngine conditionGenerationEngine = new ConditionsGenerationEngineImpl();

    @Override
    public IConditionGenerationEngine getConditionGenerationEngine() {
        return this.conditionGenerationEngine;
    }

    @Override
    public void setConditionGenerationEngine(IConditionGenerationEngine conditionGenerationEngine) {
        this.conditionGenerationEngine = conditionGenerationEngine;
    }

    @Override
    public OperationSpecification generateOperationSpecification(MatchModel matchModel) {
        ComparisonResourceSnapshot comparisonResourceSnapshot = new DiffService().generateComparisonResourceSnapshot(matchModel);
        EObject originRoot = ((Match2Elements)matchModel.getMatchedElements().get(0)).getRightElement();
        EObject workingRoot = ((Match2Elements)matchModel.getMatchedElements().get(0)).getLeftElement();
        ConditionsModel originConditionsModel = this.conditionGenerationEngine.generateConditionsModel(originRoot);
        ConditionsModel workingConditionsModel = this.conditionGenerationEngine.generateConditionsModel(workingRoot);
        OperationSpecification operationSpecification = OperationsFactory.eINSTANCE.createOperationSpecification();
        operationSpecification.setOriginModelRoot(originRoot);
        operationSpecification.setModelingLanguage(originRoot.eClass().getEPackage().getNsURI());
        operationSpecification.setWorkingModelRoot(workingRoot);
        operationSpecification.setDifferenceModel(comparisonResourceSnapshot);
        operationSpecification.setPreconditions(originConditionsModel);
        operationSpecification.setPostconditions(workingConditionsModel);
        operationSpecification.setState(SpecificationState.CONFIGURATION);
        return operationSpecification;
    }

    @Override
    public OperationSpecification generateOperationSpecification(Resource origin, Resource working) throws MatchException {
        return this.generateOperationSpecification(new MatchService().generateMatchModel(origin, working));
    }

    @Override
    public OperationSpecification generateInitialOperationSpecification(Resource origin, Resource originDiagram) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        EObject originRoot = copier.copy((EObject)origin.getContents().get(0));
        Collection<EObject> diagramRoots = null;
        if (originDiagram != null) {
            diagramRoots = copier.copyAll(originDiagram.getContents());
        }
        copier.copyReferences();
        ConditionsModel originConditionsModel = this.conditionGenerationEngine.generateConditionsModel(originRoot);
        OperationSpecification operationSpecification = OperationsFactory.eINSTANCE.createOperationSpecification();
        operationSpecification.setOriginModelRoot(originRoot);
        if (diagramRoots != null) {
            operationSpecification.getOriginDiagram().clear();
            operationSpecification.getOriginDiagram().addAll(diagramRoots);
        }
        operationSpecification.setModelingLanguage(originRoot.eClass().getEPackage().getNsURI());
        operationSpecification.setPreconditions(originConditionsModel);
        operationSpecification.setState(SpecificationState.INITIAL);
        return operationSpecification;
    }

    @Override
    public void putRevisedModel(MatchModel matchModel, Resource revisedDiagramResource, OperationSpecification operationSpecification) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        ComparisonResourceSnapshot comparisonResourceSnapshot = new DiffService().generateComparisonResourceSnapshot(matchModel);
        EObject workingRoot = (EObject)matchModel.getRightRoots().get(0);
        Collection<EObject> diagramRoots = null;
        if (revisedDiagramResource != null) {
            diagramRoots = copier.copyAll(revisedDiagramResource.getContents());
        }
        copier.copyReferences();
        ConditionsModel workingConditionsModel = this.conditionGenerationEngine.generateConditionsModel(workingRoot);
        if (diagramRoots != null) {
            operationSpecification.getWorkingDiagram().clear();
            operationSpecification.getWorkingDiagram().addAll(diagramRoots);
        }
        operationSpecification.setWorkingModelRoot(workingRoot);
        operationSpecification.setDifferenceModel(comparisonResourceSnapshot);
        operationSpecification.setPostconditions(workingConditionsModel);
        operationSpecification.setState(SpecificationState.CONFIGURATION);
    }

    @Override
    public NegativeApplicationCondition createNegativeApplicationCondition(MatchModel matchModel, Resource diagramResource, OperationSpecification operationSpecification) {
        ComparisonResourceSnapshot comparisonResourceSnapshot = new DiffService().generateComparisonResourceSnapshot(matchModel);
        EObject nacRoot = (EObject)matchModel.getRightRoots().get(0);
        ConditionsModel conditionsModel = this.conditionGenerationEngine.generateRefinedConditionsModel(nacRoot, operationSpecification.getPreconditions(), comparisonResourceSnapshot);
        NegativeApplicationCondition newNAC = OperationsFactory.eINSTANCE.createNegativeApplicationCondition();
        newNAC.setName(NAC_DEFAULT_NAME);
        newNAC.setDifferenceModel(comparisonResourceSnapshot);
        newNAC.setModelRoot(nacRoot);
        newNAC.setConditions(conditionsModel);
        if (diagramResource != null) {
            EcoreUtil.Copier copier = new EcoreUtil.Copier();
            Collection<EObject> diagramRoots = copier.copyAll(diagramResource.getContents());
            newNAC.getDiagram().clear();
            newNAC.getDiagram().addAll(diagramRoots);
            copier.copyReferences();
        }
        operationSpecification.getNegativeApplicationConditions().add(newNAC);
        return newNAC;
    }
}

