/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.operations.execution.engines.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.core.conditions.ConditionsModel;
import org.modelversioning.core.conditions.EvaluationResult;
import org.modelversioning.core.conditions.EvaluationStatus;
import org.modelversioning.core.conditions.RefinementTemplate;
import org.modelversioning.core.conditions.Template;
import org.modelversioning.core.conditions.engines.IConditionEvaluationEngine;
import org.modelversioning.core.conditions.engines.ITemplateBinding;
import org.modelversioning.core.conditions.engines.ITemplateBindings;
import org.modelversioning.core.conditions.engines.UnsupportedConditionLanguage;
import org.modelversioning.core.conditions.engines.impl.ConditionsEvaluationEngineImpl;
import org.modelversioning.core.conditions.engines.impl.TemplateBindingImpl;
import org.modelversioning.core.conditions.templatebindings.util.TemplateBindingsUtil;
import org.modelversioning.core.conditions.util.ConditionsUtil;
import org.modelversioning.operations.NegativeApplicationCondition;
import org.modelversioning.operations.NegativeApplicationConditionResult;
import org.modelversioning.operations.OperationSpecification;
import org.modelversioning.operations.OperationsFactory;
import org.modelversioning.operations.execution.IOperationBinding;
import org.modelversioning.operations.execution.engines.IOperationBindingGenerator;
import org.modelversioning.operations.execution.engines.impl.OperationBindingImpl;

public class OperationBindingGeneratorImpl
implements IOperationBindingGenerator {
    private static final String MSG_NAC_FAILS_PREFIX = "\"";
    private static final String MSG_NAC_FAILS_POSTFIX = "\" fails.";
    private static final String INITIAL = "initial";
    private static final String NAC_OK = "No Negative Application Condition violation";
    private IConditionEvaluationEngine evaluationEngine = null;

    @Override
    public IOperationBinding generateOperationBinding(OperationSpecification operationSpecification, EObject modelRoot) throws UnsupportedConditionLanguage {
        TemplateBindingImpl templateBinding = new TemplateBindingImpl();
        templateBinding.add(operationSpecification.getPreconditions().getRootTemplate(), modelRoot);
        return this.generateOperationBinding(operationSpecification, templateBinding);
    }

    @Override
    public IOperationBinding generateOperationBinding(OperationSpecification operationSpecification, ITemplateBinding preBinding) throws UnsupportedConditionLanguage {
        IConditionEvaluationEngine evalEngine = this.getInitializedEvaluationEngine(operationSpecification);
        ITemplateBindings templateBindings = evalEngine.findTemplateBinding(preBinding, true);
        return this.generateOperationBinding(operationSpecification, templateBindings);
    }

    @Override
    public IOperationBinding generateOperationBinding(OperationSpecification operationSpecification, ITemplateBindings templateBindings) throws UnsupportedConditionLanguage {
        OperationBindingImpl operationBinding = new OperationBindingImpl();
        operationBinding.setOperationSpecification(operationSpecification);
        operationBinding.setTemplateBinding(templateBindings);
        HashSet<ITemplateBinding> invalidBindings = new HashSet<ITemplateBinding>();
        HashMap<NegativeApplicationCondition, NegativeApplicationConditionResult> negativeNACResults = new HashMap<NegativeApplicationCondition, NegativeApplicationConditionResult>();
        for (NegativeApplicationCondition negativeApplicationCondition : operationSpecification.getNegativeApplicationConditions()) {
            IConditionEvaluationEngine engine = this.getInitializedEvaluationEngine(negativeApplicationCondition, templateBindings);
            boolean hadValidNAC = false;
            for (ITemplateBinding binding : templateBindings.getAllPossibleBindings()) {
                ITemplateBinding reWrittenBinding = this.rewriteBinding(negativeApplicationCondition, binding);
                ITemplateBindings nacBinding = engine.findTemplateBinding(reWrittenBinding, true);
                if (!nacBinding.validate().isOK()) continue;
                hadValidNAC = true;
                String message = "";
                message = negativeApplicationCondition.getErrorMessage() != null && negativeApplicationCondition.getErrorMessage().length() > 0 ? this.evaluationEngine.replaceTemplateValues(negativeApplicationCondition.getErrorMessage(), nacBinding) : MSG_NAC_FAILS_PREFIX + negativeApplicationCondition.getName() + MSG_NAC_FAILS_POSTFIX;
                invalidBindings.add(binding);
                negativeNACResults.put(negativeApplicationCondition, this.createNACResult(nacBinding, message, negativeApplicationCondition));
            }
            if (hadValidNAC) continue;
            operationBinding.addNegativeApplicationConditionResult(negativeApplicationCondition, this.createPositiveNACResult(negativeApplicationCondition));
        }
        if (templateBindings.getAllPossibleBindings().size() > invalidBindings.size()) {
            templateBindings.getAllPossibleBindings().removeAll(invalidBindings);
        } else {
            for (Map.Entry entry : negativeNACResults.entrySet()) {
                operationBinding.addNegativeApplicationConditionResult((NegativeApplicationCondition)entry.getKey(), (NegativeApplicationConditionResult)entry.getValue());
            }
        }
        return operationBinding;
    }

    private NegativeApplicationConditionResult createPositiveNACResult(NegativeApplicationCondition nac) {
        NegativeApplicationConditionResult result = OperationsFactory.eINSTANCE.createNegativeApplicationConditionResult();
        result.setMessage(NAC_OK);
        result.setNegativeApplicationCondition(nac);
        result.setStatus(EvaluationStatus.SATISFIED);
        return result;
    }

    private NegativeApplicationConditionResult createNACResult(ITemplateBindings nacBinding, String message, NegativeApplicationCondition nac) {
        NegativeApplicationConditionResult result = OperationsFactory.eINSTANCE.createNegativeApplicationConditionResult();
        EvaluationResult validation = nacBinding.validate();
        if (EvaluationStatus.ERROR.equals(validation.getStatus())) {
            result.setException(validation.getException());
            result.setMessage(validation.getMessage());
            result.setStatus(EvaluationStatus.ERROR);
            result.setEvaluator(validation.getEvaluator());
        } else {
            result.setBinding(TemplateBindingsUtil.convert(nacBinding));
            result.setMessage(message);
            result.setNegativeApplicationCondition(nac);
            result.setStatus(EvaluationStatus.UNSATISFIED);
            result.setEvaluator(validation.getEvaluator());
        }
        return result;
    }

    private ITemplateBinding rewriteBinding(NegativeApplicationCondition nac, ITemplateBinding binding) {
        TemplateBindingImpl rewrittenBinding = new TemplateBindingImpl();
        EList<Template> allTemplates = ConditionsUtil.getAllTemplates(nac.getConditions());
        for (Template template : allTemplates) {
            if (!(template instanceof RefinementTemplate)) continue;
            RefinementTemplate refinementTemplate = (RefinementTemplate)template;
            rewrittenBinding.add((Template)refinementTemplate, binding.getBoundObjects(refinementTemplate.getRefinedTemplate()));
        }
        return rewrittenBinding;
    }

    private IConditionEvaluationEngine getInitializedEvaluationEngine(OperationSpecification operationSpecification) throws UnsupportedConditionLanguage {
        if (!this.isEvaluationEngineInitialized(operationSpecification.getPreconditions())) {
            this.evaluationEngine = new ConditionsEvaluationEngineImpl();
            this.evaluationEngine.setConditionsModel(operationSpecification.getPreconditions());
        }
        return this.evaluationEngine;
    }

    private IConditionEvaluationEngine getInitializedEvaluationEngine(NegativeApplicationCondition nac, ITemplateBindings preConditionTemplateBinding) throws UnsupportedConditionLanguage {
        if (!this.isEvaluationEngineInitialized(nac.getConditions())) {
            this.evaluationEngine = new ConditionsEvaluationEngineImpl();
            this.evaluationEngine.setConditionsModel(nac.getConditions());
            this.evaluationEngine.registerRelatedTemplateBinding(INITIAL, preConditionTemplateBinding);
        }
        return this.evaluationEngine;
    }

    private boolean isEvaluationEngineInitialized(ConditionsModel conditionsModel) {
        return this.evaluationEngine != null && conditionsModel.equals(this.evaluationEngine.getConditionsModel());
    }

    @Override
    public IConditionEvaluationEngine getEvaluationEngine() {
        return this.evaluationEngine;
    }

    @Override
    public void setEvaluationEngine(IConditionEvaluationEngine evaluationEngine) {
        this.evaluationEngine = evaluationEngine;
    }
}

