/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.operations.execution.engines.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.core.conditions.Template;
import org.modelversioning.core.conditions.engines.BindingException;
import org.modelversioning.core.conditions.engines.ITemplateBindings;
import org.modelversioning.operations.NegativeApplicationCondition;
import org.modelversioning.operations.NegativeApplicationConditionResult;
import org.modelversioning.operations.OperationSpecification;
import org.modelversioning.operations.UserInput;
import org.modelversioning.operations.execution.IOperationBinding;
import org.modelversioning.operations.util.OperationsUtil;

public class OperationBindingImpl
implements IOperationBinding {
    private static final String OK = "Binding is valid";
    private static final String INVALID_BINDING = "Binding is not valid";
    private static final String FIRED_NAC = "Negative Application Condition is true";
    private static final String NOT_UNIQUE = "Binding is not unique";
    private OperationSpecification operationSpecification;
    private ITemplateBindings binding;
    private Map<NegativeApplicationCondition, NegativeApplicationConditionResult> nacResults = new HashMap<NegativeApplicationCondition, NegativeApplicationConditionResult>();
    private Map<UserInput, Object> userInputValues = new HashMap<UserInput, Object>();

    protected OperationBindingImpl() {
    }

    protected OperationBindingImpl(OperationSpecification operationSpecification) {
        this.operationSpecification = operationSpecification;
    }

    protected OperationBindingImpl(OperationSpecification operationSpecification, ITemplateBindings binding) {
        this.operationSpecification = operationSpecification;
        this.binding = binding;
    }

    @Override
    public OperationSpecification getOperationSpecification() {
        return this.operationSpecification;
    }

    protected void setOperationSpecification(OperationSpecification operationSpecification) {
        this.operationSpecification = operationSpecification;
    }

    @Override
    public EObject getWorkingModelRoot() {
        if (this.operationSpecification == null || this.operationSpecification.getPreconditions() == null) {
            return null;
        }
        if (this.binding == null) {
            return null;
        }
        Set<EObject> boundRootObjects = this.binding.getBoundObjects(this.operationSpecification.getPreconditions().getRootTemplate());
        if (boundRootObjects.size() > 0) {
            return boundRootObjects.iterator().next();
        }
        return null;
    }

    @Override
    public ITemplateBindings getTemplateBinding() {
        return this.binding;
    }

    protected void setTemplateBinding(ITemplateBindings templateBinding) {
        this.binding = templateBinding;
    }

    @Override
    public IStatus validate() {
        Status status = new Status(0, "org.modelversioning.operations.execution", OK);
        if (this.binding == null || !this.binding.validate().isOK()) {
            status = new Status(4, "org.modelversioning.operations.execution", 1, INVALID_BINDING, new BindingException(INVALID_BINDING, null));
        }
        for (NegativeApplicationConditionResult result : this.nacResults.values()) {
            if (result.isOK()) continue;
            status = new Status(4, "org.modelversioning.operations.execution", 4, result.getMessage(), new BindingException(FIRED_NAC, null));
        }
        if (!this.isUnique()) {
            status = new Status(2, "org.modelversioning.operations.execution", 2, NOT_UNIQUE, new BindingException(NOT_UNIQUE, null));
        }
        return status;
    }

    @Override
    public boolean isUnique() {
        return OperationsUtil.isUnique(this.binding, this.operationSpecification);
    }

    public boolean isUnique(Template template, Set<EObject> objects) {
        return OperationsUtil.isUnique(template, objects, this.operationSpecification);
    }

    public boolean allowsMultipleBinding(Template template) {
        return OperationsUtil.allowsMultipleBinding(template, this.operationSpecification);
    }

    @Override
    public Map<UserInput, Object> getUserInputValues() {
        return this.userInputValues;
    }

    @Override
    public Set<UserInput> getMissingUserInputs() {
        HashSet<UserInput> missingInputs = new HashSet<UserInput>();
        missingInputs.addAll(this.operationSpecification.getUserInputs());
        missingInputs.removeAll(this.userInputValues.keySet());
        return missingInputs;
    }

    @Override
    public void setUserInputValue(UserInput userInput, Object value) {
        this.userInputValues.put(userInput, value);
    }

    @Override
    public Collection<NegativeApplicationConditionResult> getNegativeApplicationConditionResults() {
        return Collections.unmodifiableCollection(this.nacResults.values());
    }

    @Override
    public NegativeApplicationConditionResult getNegativeApplicationConditionResult(NegativeApplicationCondition nac) {
        return this.nacResults.get(nac);
    }

    public void addNegativeApplicationConditionResult(NegativeApplicationCondition nac, NegativeApplicationConditionResult nacResult) {
        this.nacResults.put(nac, nacResult);
    }
}

