/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.operations.execution.engines.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.util.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.core.conditions.Condition;
import org.modelversioning.core.conditions.ConditionsModel;
import org.modelversioning.core.conditions.FeatureCondition;
import org.modelversioning.core.conditions.Template;
import org.modelversioning.core.conditions.engines.ITemplateBinding;
import org.modelversioning.core.conditions.engines.UnsupportedConditionLanguage;
import org.modelversioning.core.conditions.engines.impl.ConditionsEvaluationEngineImpl;
import org.modelversioning.core.conditions.engines.impl.TemplateBindingImpl;
import org.modelversioning.core.conditions.util.ConditionsUtil;
import org.modelversioning.core.diff.propagation.IDiffPropagationEngine;
import org.modelversioning.core.diff.propagation.IPropagationMappingProvider;
import org.modelversioning.core.diff.propagation.impl.DiffPropagationEngine;
import org.modelversioning.core.match.util.MatchUtil;
import org.modelversioning.core.util.EcoreUtil;
import org.modelversioning.operations.UserInput;
import org.modelversioning.operations.execution.IOperationBinding;
import org.modelversioning.operations.execution.OperationsExecutionPlugin;
import org.modelversioning.operations.execution.engines.IOperationExecutionEngine;
import org.modelversioning.operations.util.OperationsUtil;

public class OperationExecutionEngineImpl
implements IOperationExecutionEngine,
IPropagationMappingProvider {
    private static final String USER_INPUT_ERROR = "Error assigning user input value";
    private static final String CANNOT_ASSING_VALUE = "Cannot assign value";
    private Map<EObject, Template> representativeToTemplateMap = new HashMap<EObject, Template>();
    private Set<DiffElement> diffElementsToAdd = new HashSet<DiffElement>();
    private IOperationBinding operationBinding = null;
    private IDiffPropagationEngine propagationEngine;

    @Override
    public EObject execute(IOperationBinding operationBinding) {
        this.initialize(operationBinding);
        this.propagationEngine = new DiffPropagationEngine();
        this.propagationEngine.propagate(operationBinding.getOperationSpecification().getDifferenceModel().getDiff(), operationBinding.getOperationSpecification().getDifferenceModel().getMatch(), (IPropagationMappingProvider)this, (IProgressMonitor)new NullProgressMonitor());
        this.assignUserInputs();
        this.assignImplicitValues();
        return operationBinding.getWorkingModelRoot();
    }

    private void initialize(IOperationBinding operationBinding) {
        this.operationBinding = operationBinding;
        this.representativeToTemplateMap.clear();
        this.fillRepresentativeToTemplateMap(operationBinding.getOperationSpecification().getPreconditions());
        this.diffElementsToAdd.clear();
    }

    @Override
    public boolean isInOriginModel(EObject object) {
        EObject originRoot = this.operationBinding.getOperationSpecification().getOriginModelRoot();
        return EcoreUtil.createParentList(object).contains(originRoot);
    }

    private void fillRepresentativeToTemplateMap(ConditionsModel conditionsModel) {
        this.representativeToTemplateMap = ConditionsUtil.getRepresentativeToTemplateMap(conditionsModel);
    }

    private Template getPostTemplateByRepresentative(EObject representative) {
        return ConditionsUtil.getTemplateByRepresentative(representative, this.operationBinding.getOperationSpecification().getPostconditions());
    }

    private Template getTemplateByRepresentative(EObject representative) {
        return this.representativeToTemplateMap.get(representative);
    }

    public Set<EObject> getCounterpartObjects(EObject eObject) {
        Template template = this.getTemplateByRepresentative(eObject);
        Set<EObject> boundObjects = this.operationBinding.getTemplateBinding().getBoundObjects(template);
        if (boundObjects == null) {
            boundObjects = Collections.emptySet();
        }
        return boundObjects;
    }

    @Override
    public EObject getCounterpartObject(EObject eObject, DiffElement diffElement, EObject context) {
        Collection counterpartObjects = this.getCounterpartObjects(eObject);
        if (counterpartObjects.size() > 0) {
            return (EObject)counterpartObjects.iterator().next();
        }
        return null;
    }

    private void assignUserInputs() {
        for (UserInput userInput : this.operationBinding.getUserInputValues().keySet()) {
            try {
                EObject match = null;
                match = this.getMatchingObject(userInput.getTemplate().getRepresentative());
                if (match != null) {
                    Set<EObject> objects = this.operationBinding.getTemplateBinding().getBoundObjects(this.getTemplateByRepresentative(match));
                    for (EObject eObject : objects) {
                        EFactory.eSet(eObject, userInput.getFeature().getName(), this.operationBinding.getUserInputValues().get(userInput));
                    }
                    continue;
                }
                if (this.propagationEngine.getCopies(userInput.getTemplate().getRepresentative()).size() <= 0) continue;
                EList<EObject> copies = this.propagationEngine.getCopies(userInput.getTemplate().getRepresentative());
                for (EObject copy : copies) {
                    EFactory.eSet(copy, userInput.getFeature().getName(), this.operationBinding.getUserInputValues().get(userInput));
                }
            }
            catch (FactoryException e) {
                OperationsExecutionPlugin.getDefault().getLog().log(new Status(2, "org.modelversioning.operations.execution", USER_INPUT_ERROR, e));
            }
        }
    }

    private void assignImplicitValues() {
        try {
            ConditionsEvaluationEngineImpl postEvaluationEngine = new ConditionsEvaluationEngineImpl();
            postEvaluationEngine.setConditionsModel(this.operationBinding.getOperationSpecification().getPostconditions());
            postEvaluationEngine.registerRelatedTemplateBinding(OperationsUtil.INITIAL_PREFIX, this.operationBinding.getTemplateBinding());
            ITemplateBinding executedBinding = this.deriveExecutedBinding();
            for (Template postTemplate : executedBinding.getTemplates()) {
                for (EObject boundObject : executedBinding.getBoundObjects(postTemplate)) {
                    for (Condition condition : postTemplate.getSpecifications()) {
                        if (!(condition instanceof FeatureCondition) || !condition.isActive() || postEvaluationEngine.evaluate(condition, boundObject, executedBinding).isOK()) continue;
                        Object value = null;
                        try {
                            value = postEvaluationEngine.getValidValue((FeatureCondition)condition, boundObject, executedBinding);
                            if (value == null) continue;
                            boundObject.eSet(((FeatureCondition)condition).getFeature(), value);
                        }
                        catch (Exception e) {
                            OperationsExecutionPlugin.getDefault().getLog().log(new Status(2, "org.modelversioning.operations.execution", CANNOT_ASSING_VALUE, e));
                        }
                    }
                }
            }
        }
        catch (UnsupportedConditionLanguage e) {
            e.printStackTrace();
        }
    }

    private ITemplateBinding deriveExecutedBinding() {
        TemplateBindingImpl executedBinding = new TemplateBindingImpl();
        Template postRootTemplate = this.operationBinding.getOperationSpecification().getPostconditions().getRootTemplate();
        executedBinding.add(postRootTemplate, this.operationBinding.getWorkingModelRoot());
        TreeIterator<EObject> iterator = this.operationBinding.getWorkingModelRoot().eAllContents();
        while (iterator.hasNext()) {
            EObject currentObject = (EObject)iterator.next();
            Template postTemplate = null;
            EObject original = this.propagationEngine.getOriginalEObjectFromCopy(currentObject);
            if (original != null) {
                postTemplate = this.getPostTemplateByRepresentative(original);
            } else {
                Template preTemplate = this.getBoundTemplate(currentObject);
                if (preTemplate != null) {
                    EObject postRepresentative = this.getMatchingObject(preTemplate.getRepresentative());
                    postTemplate = this.getPostTemplateByRepresentative(postRepresentative);
                }
            }
            if (postTemplate == null) continue;
            executedBinding.add(postTemplate, currentObject);
        }
        return executedBinding;
    }

    private Template getBoundTemplate(EObject eObject) {
        Set<Template> templates = this.getBoundTemplates(eObject);
        if (templates.size() < 1) {
            return null;
        }
        return templates.iterator().next();
    }

    private Set<Template> getBoundTemplates(EObject eObject) {
        return this.operationBinding.getTemplateBinding().getBoundTemplates(eObject);
    }

    private EObject getMatchingObject(EObject eObject) {
        return MatchUtil.getMatchingObject(eObject, this.operationBinding.getOperationSpecification().getDifferenceModel().getMatch());
    }
}

