/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.operations.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.operations.OperationSpecification;

public class OperationModelToTextGenerator {
    private static final String H1_PREFIX = "======= ";
    private static final String H1_POSTFIX = " =======";
    private static final String H2_PREFIX = "====== ";
    private static final String H2_POSTFIX = " ======";
    private static final String NEW_LINE = "\n";

    public void generateText(OperationSpecification operation, OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out);
        writer.write(H1_PREFIX);
        writer.write(operation.getName());
        writer.write(H1_POSTFIX);
        writer.write(NEW_LINE);
        writer.write(NEW_LINE);
        writer.write(H2_PREFIX);
        writer.write("Differences");
        writer.write(H2_POSTFIX);
        writer.write(NEW_LINE);
        TreeIterator<EObject> diffIter = operation.getDifferenceModel().getDiff().eAllContents();
        while (diffIter.hasNext()) {
            EObject currentDiff = (EObject)diffIter.next();
            writer.write("-" + currentDiff.toString());
            writer.write(NEW_LINE);
        }
        writer.write(NEW_LINE);
        writer.write(H2_PREFIX);
        writer.write("Pre conditions");
        writer.write(H2_POSTFIX);
        writer.write(NEW_LINE);
        writer.write(NEW_LINE);
        writer.write(H2_PREFIX);
        writer.write("Post conditions");
        writer.write(H2_POSTFIX);
        writer.write(NEW_LINE);
        writer.flush();
    }
}

