/*
 * Decompiled with CFR 0.152.
 */
package org.modelversioning.operations.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.ecore.EObject;
import org.modelversioning.core.conditions.Template;
import org.modelversioning.core.conditions.engines.ITemplateBinding;
import org.modelversioning.core.conditions.engines.ITemplateBindings;
import org.modelversioning.core.conditions.engines.impl.TemplateBindingImpl;
import org.modelversioning.core.conditions.util.ConditionsUtil;
import org.modelversioning.core.diff.util.DiffUtil;
import org.modelversioning.core.match.util.MatchUtil;
import org.modelversioning.operations.Iteration;
import org.modelversioning.operations.OperationSpecification;

public class OperationsUtil {
    public static String INITIAL_PREFIX = "initial";
    public static String REVISED_PREFIX = "revised";

    public static boolean isIterated(Template template, OperationSpecification operationSpecification) {
        return OperationsUtil.getIteration(template, operationSpecification) != null;
    }

    public static Iteration getIteration(Template template, OperationSpecification operationSpecification) {
        for (Iteration iteration : operationSpecification.getIterations()) {
            if (!template.equals(iteration.getTemplate())) continue;
            return iteration;
        }
        return null;
    }

    public static boolean isParentIterated(Template template, OperationSpecification operationSpecification) {
        List<Template> parents = ConditionsUtil.createParentList(template);
        for (Template parent : parents) {
            if (!OperationsUtil.isIterated(parent, operationSpecification)) continue;
            return true;
        }
        return false;
    }

    public static Template getPreconditionTemplateByDiffElement(DiffElement diffElement, OperationSpecification operationSpecification) {
        EObject rightElement = DiffUtil.getRightElement(diffElement);
        if (rightElement != null) {
            return ConditionsUtil.getTemplateByRepresentative(rightElement, operationSpecification.getPreconditions());
        }
        return null;
    }

    public static Template getPostconditionTemplateByDiffElement(DiffElement diffElement, OperationSpecification operationSpecification) {
        EObject leftElement = DiffUtil.getLeftElement(diffElement);
        if (leftElement != null) {
            return ConditionsUtil.getTemplateByRepresentative(leftElement, operationSpecification.getPostconditions());
        }
        return null;
    }

    public static boolean isUnique(ITemplateBindings templateBindings, OperationSpecification operationSpecification) {
        boolean isUnique = true;
        EList<Template> allTemplates = ConditionsUtil.getAllTemplates(operationSpecification.getPreconditions());
        for (Template template : allTemplates) {
            if (OperationsUtil.isUnique(template, templateBindings.getBoundObjects(template), operationSpecification)) continue;
            isUnique = false;
            break;
        }
        return isUnique;
    }

    public static boolean isUnique(Template template, Set<EObject> objects, OperationSpecification operationSpecification) {
        boolean isUnique = true;
        if (objects.size() > 1 && !OperationsUtil.allowsMultipleBinding(template, operationSpecification)) {
            isUnique = false;
        }
        return isUnique;
    }

    public static boolean allowsMultipleBinding(Template template, OperationSpecification operationSpecification) {
        return OperationsUtil.isIterated(template, operationSpecification) || OperationsUtil.isParentIterated(template, operationSpecification);
    }

    public static Set<ITemplateBindings> splitToUniqueBindings(ITemplateBindings templateBindings, OperationSpecification operationSpecification) {
        HashSet<ITemplateBindings> splitTemplateBindings = new HashSet<ITemplateBindings>();
        boolean hadToSplit = false;
        EList<Template> allTemplates = ConditionsUtil.getAllTemplates(operationSpecification.getPreconditions());
        for (Template template : allTemplates) {
            Set<EObject> boundObjects;
            if (!OperationsUtil.isUnique(template, boundObjects = templateBindings.getBoundObjects(template), operationSpecification)) {
                hadToSplit = true;
                for (EObject boundObject : boundObjects) {
                    ITemplateBindings extractedBinding = templateBindings.extractSubBindings(template, boundObject, true);
                    splitTemplateBindings.addAll(OperationsUtil.splitToUniqueBindings(extractedBinding, operationSpecification));
                }
            }
            if (hadToSplit) break;
        }
        if (!hadToSplit) {
            splitTemplateBindings.add(templateBindings);
        }
        return splitTemplateBindings;
    }

    public static String getId(OperationSpecification operationSpecification) {
        return String.valueOf(operationSpecification.getModelingLanguage()) + "/" + operationSpecification.getVersion() + "/" + operationSpecification.getName();
    }

    public static Template getCorrespondingPostConditionTemplate(Template preConditionTemplate, OperationSpecification operationSpecification) {
        MatchModel matchModel = operationSpecification.getDifferenceModel().getMatch();
        EObject preConditionRepresentative = preConditionTemplate.getRepresentative();
        EObject postConditionRepresentative = MatchUtil.getMatchingObject(preConditionRepresentative, matchModel);
        Template postConditionTemplate = ConditionsUtil.getTemplateByRepresentative(postConditionRepresentative, operationSpecification.getPostconditions());
        return postConditionTemplate;
    }

    public static ITemplateBinding derivePostConditionTemplateBinding(ITemplateBindings preConditionTemplateBindings, MatchModel matchModel, OperationSpecification operationSpecification) {
        TemplateBindingImpl templateBinding = new TemplateBindingImpl();
        for (Template boundPreTemplate : preConditionTemplateBindings.getTemplates()) {
            Set<EObject> boundPreObjects = preConditionTemplateBindings.getBoundObjects(boundPreTemplate);
            Template postConditionTemplate = OperationsUtil.getCorrespondingPostConditionTemplate(boundPreTemplate, operationSpecification);
            for (EObject boundPreObject : boundPreObjects) {
                templateBinding.add(postConditionTemplate, MatchUtil.getMatchingObject(boundPreObject, matchModel));
            }
        }
        return templateBinding;
    }
}

