/*
 * Decompiled with CFR 0.152.
 */
import at.jku.fmv.qbf.nnf.formula.FormulaData;
import at.jku.fmv.qbf.nnf.parser.ParseException;
import at.jku.fmv.qbf.nnf.parser.Parser;
import at.jku.fmv.qbf.nnf.transform.matrix.FormulaToCNF;
import at.jku.fmv.qbf.nnf.transform.prenex.AppendPrenexPrinter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class qpro2qdimacs {
    public static void main(String[] args) {
        String filename = null;
        boolean doHashing = true;
        boolean printBoole = false;
        boolean pol = true;
        Options options = new Options();
        options.addOption("n", false, "negate Formula");
        options.addOption("h", false, "print this help");
        options.addOption("b", false, "print Formula in Boole format and quit");
        options.addOption("i", true, "input file (formula to transform in qpro format");
        options.addOption("f", false, "put Tseitin as left as possible in prefix");
        HelpFormatter formatter = new HelpFormatter();
        Object merger = null;
        boolean tseitinPos = false;
        PosixParser parser = new PosixParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("b")) {
                printBoole = true;
            }
            if (cmd.hasOption("h")) {
                formatter.printHelp("qpro2qdimacs", options);
                System.exit(0);
            }
            if (cmd.hasOption("n")) {
                pol = false;
            }
            if (cmd.hasOption("i")) {
                filename = cmd.getOptionValue("i");
            }
            if (cmd.hasOption("f")) {
                tseitinPos = true;
            }
            FormulaData fd = filename != null ? Parser.parse(new File(filename), pol) : Parser.parse(System.in, pol);
            if (printBoole) {
                fd.printBoole();
                System.exit(0);
            }
            FormulaToCNF ftc = new FormulaToCNF(fd, true);
            ftc.label();
            System.out.println("p cnf " + fd.getVarNumber() + " " + ftc.countClauses());
            AppendPrenexPrinter pp = new AppendPrenexPrinter(fd);
            pp.printPrefix();
            ftc.printCNFMatrix();
        }
        catch (org.apache.commons.cli.ParseException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

