/*
 * Decompiled with CFR 0.152.
 */
package at.jku.fmv.qbf.nnf.parser;

import at.jku.fmv.qbf.nnf.formula.CType;
import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.FormulaData;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.QType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Scanner;

public class ParserBoole {
    private HashMap<String, Integer> vars;
    private Scanner input;
    private String nextToken;
    private int varCounter = 2;
    private FormulaData fd;
    private boolean pol = true;

    private ParserBoole(int varNumber, String f) {
        Formula root = new Formula();
        f = f.replaceAll("!", " ! ");
        f = f.replaceAll(" > ", " > ");
        f = f.replaceAll("\\&", " \\& ");
        f = f.replaceAll("\\|", " \\| ");
        f = f.replaceAll("\\)", " \\) ");
        f = f.replaceAll("\\(", " \\( ");
        f = f.replaceAll("\\]", " \\] ");
        f = f.replaceAll("\\[", " \\[ ");
        this.input = new Scanner(f);
        this.fd = new FormulaData(varNumber, root);
        this.nextToken();
        this.parseFormula(root);
        this.fd.setVarNumber(this.varCounter);
    }

    private FormulaData getFormulaData() {
        return this.fd;
    }

    private void parseFormula(Formula f) {
        this.vars = new HashMap();
        if (this.nextToken.equals("(")) {
            this.parseBrack(f);
        } else if (this.nextToken.equals("forall") || this.nextToken.equals("exists")) {
            this.parseQuant(f);
        }
    }

    private int getNewVarName() {
        return this.varCounter++;
    }

    private void parseBrack(Formula f) {
        this.nextToken();
        this.parseConnective(f);
        if (!this.nextToken.equals(")")) {
            // empty if block
        }
    }

    private void parseConnective(Formula f) {
        if (this.nextToken.equals("forall") || this.nextToken.equals("exists")) {
            Formula f1 = new Formula();
            this.parseQuant(f1);
            f.addSubFormula(f1);
        } else if (this.nextToken.equals("(")) {
            Formula f1 = new Formula();
            this.parseBrack(f1);
            f.addSubFormula(f1);
        } else if (this.nextToken.equals("!")) {
            this.nextToken();
            if (this.nextToken.equals("(")) {
                this.pol = !this.pol;
                Formula f1 = new Formula();
                this.parseBrack(f1);
                f.addSubFormula(f1);
                this.pol = !this.pol;
            } else {
                assert (this.vars.containsKey(this.nextToken)) : "unknown element";
                assert (this.vars.get(this.nextToken) != null) : "variable not quantified";
                if (this.pol) {
                    this.fd.addNegVarOcc(this.vars.get(this.nextToken), f);
                } else {
                    this.fd.addPosVarOcc(this.vars.get(this.nextToken), f);
                }
            }
        } else {
            assert (this.vars.containsKey(this.nextToken)) : "unknown element";
            assert (this.vars.get(this.nextToken) != null) : "variable not quantified";
            this.fd.addPosVarOcc(this.vars.get(this.nextToken), f);
        }
        this.nextToken();
        if (this.nextToken.equals("&")) {
            this.parseConj(f);
            return;
        }
        if (this.nextToken.equals("|")) {
            this.parseDisj(f);
            return;
        }
    }

    private void parseDisj(Formula f) {
        if (this.pol) {
            f.setConnective(CType.OR);
        } else {
            f.setConnective(CType.AND);
        }
        do {
            Formula f1;
            this.nextToken();
            if (this.nextToken.equals("forall") || this.nextToken.equals("exists")) {
                f1 = new Formula();
                this.parseQuant(f1);
                f.addSubFormula(f1);
            } else if (this.nextToken.equals("(")) {
                f1 = new Formula();
                this.parseBrack(f1);
                f.addSubFormula(f1);
            } else if (this.nextToken.equals("!")) {
                this.nextToken();
                if (this.nextToken.equals("(")) {
                    this.pol = !this.pol;
                    f1 = new Formula();
                    this.parseBrack(f1);
                    f.addSubFormula(f1);
                    this.pol = !this.pol;
                } else {
                    assert (this.vars.containsKey(this.nextToken)) : "unknown element";
                    assert (this.vars.get(this.nextToken) != null) : "variable not quantified";
                    if (this.pol) {
                        this.fd.addNegVarOcc(this.vars.get(this.nextToken), f);
                    } else {
                        this.fd.addPosVarOcc(this.vars.get(this.nextToken), f);
                    }
                }
            } else {
                assert (this.vars.containsKey(this.nextToken)) : "unknown element";
                this.fd.addPosVarOcc(this.vars.get(this.nextToken), f);
            }
            this.nextToken();
        } while (this.nextToken.equals("|"));
    }

    private void parseConj(Formula f) {
        if (this.pol) {
            f.setConnective(CType.AND);
        } else {
            f.setConnective(CType.OR);
        }
        do {
            Formula f1;
            this.nextToken();
            if (this.nextToken.equals("forall") || this.nextToken.equals("exists")) {
                f1 = new Formula();
                this.parseQuant(f1);
                f.addSubFormula(f1);
            } else if (this.nextToken.equals("(")) {
                f1 = new Formula();
                this.parseBrack(f1);
                f.addSubFormula(f1);
            } else if (this.nextToken.equals("!")) {
                this.nextToken();
                if (this.nextToken.equals("(")) {
                    this.pol = !this.pol;
                    f1 = new Formula();
                    this.parseBrack(f1);
                    f.addSubFormula(f1);
                    this.pol = !this.pol;
                } else {
                    assert (this.vars.containsKey(this.nextToken)) : "unknown element";
                    assert (this.vars.get(this.nextToken) != null) : "variable not quantified";
                    if (this.pol) {
                        this.fd.addNegVarOcc(this.vars.get(this.nextToken), f);
                    } else {
                        this.fd.addPosVarOcc(this.vars.get(this.nextToken), f);
                    }
                }
                assert (this.vars.containsKey(this.nextToken)) : "unknown element";
            } else {
                assert (this.vars.containsKey(this.nextToken)) : "unknown element";
                assert (this.vars.get(this.nextToken) != null) : "variable not quantified";
                this.fd.addPosVarOcc(this.vars.get(this.nextToken), f);
            }
            this.nextToken();
        } while (this.nextToken.equals("&"));
    }

    private void parseQuant(Formula f) {
        String quant = this.nextToken;
        ArrayList<String> quantVars = new ArrayList<String>();
        QBlock qBlock = quant.equals("forall") ? (this.pol ? new QBlock(QType.FORALL, f) : new QBlock(QType.EXISTS, f)) : (this.pol ? new QBlock(QType.EXISTS, f) : new QBlock(QType.FORALL, f));
        this.nextToken();
        assert (this.nextToken.equals("[")) : "unexpected character";
        this.nextToken();
        do {
            assert (!this.vars.containsKey(this.nextToken)) : "variable already defined";
            int newVar = this.getNewVarName();
            this.vars.put(this.nextToken, newVar);
            quantVars.add(this.nextToken);
            this.fd.addVar(newVar, qBlock);
            this.nextToken();
        } while (!this.nextToken.equals("]"));
        this.nextToken();
        this.parseBrack(f);
        for (String s : quantVars) {
            this.vars.put(s, null);
        }
    }

    private void nextToken() {
        this.nextToken = this.input.next();
    }

    public static FormulaData parse(int varNumber, String f) {
        ParserBoole p = new ParserBoole(varNumber, f);
        return p.getFormulaData();
    }

    public static void main(String[] args) {
        FormulaData fd = ParserBoole.parse(20, "exists [a b c d] (forall [x y] ((a & b) | !x | !d))");
        fd = ParserBoole.parse(5, "forall [x] (x)");
        fd.print();
    }
}

