/*
 * Decompiled with CFR 0.152.
 */
package at.jku.fmv.qbf.nnf.transform.matrix;

import at.jku.fmv.qbf.nnf.formula.CType;
import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.FormulaData;
import at.jku.fmv.qbf.nnf.formula.TseitinVar;
import at.jku.fmv.qbf.nnf.formula.VOccurrence;
import at.jku.fmv.qbf.nnf.parser.ParseException;
import at.jku.fmv.qbf.nnf.parser.Parser;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class FormulaToCNF {
    private Formula formulaRoot;
    private LinkedList<Formula> recent;
    private LinkedList<Formula> next;
    private HashMap<Integer, TseitinVar> labels;
    private int varNumber;
    private int counter;
    FormulaData fd;
    private boolean[] definedLabels;
    private int cl;
    private boolean doHashing = true;

    public FormulaToCNF(FormulaData fd, boolean doHashing) {
        this.fd = fd;
        this.doHashing = doHashing;
        this.formulaRoot = fd.getFormula();
        this.next = new LinkedList();
        this.recent = new LinkedList();
        this.varNumber = fd.getVarNumber();
        this.counter = this.varNumber + 1;
        this.labels = new HashMap();
    }

    public void label() {
        this.labelClauses(this.formulaRoot);
        this.labelNonClauses();
        this.definedLabels = new boolean[this.counter];
    }

    private void labelNonClauses() {
        while (!this.next.isEmpty()) {
            this.recent = this.next;
            this.next = new LinkedList();
            while (!this.recent.isEmpty()) {
                this.setLabel(this.recent.poll());
            }
        }
    }

    private void labelClauses(Formula f) {
        if (f.getSubformulas().size() != 0) {
            for (Formula sf : f.getSubformulas()) {
                this.labelClauses(sf);
            }
            return;
        }
        this.setLabel(f);
    }

    private int getHashValue(Formula f) {
        int[] tv = new int[f.getPosLits().size() + f.getNegLits().size() + f.getSubformulas().size() + 1];
        int i = 1;
        tv[0] = f.getConnective() == CType.AND ? 0 : 1;
        for (Formula sf : f.getSubformulas()) {
            if (sf.getTseitinVar() == null) {
                return -1;
            }
            tv[i++] = sf.getTseitinVar().getName();
        }
        for (VOccurrence v : f.getPosLits()) {
            tv[i++] = v.getVariable();
        }
        for (VOccurrence v : f.getNegLits()) {
            tv[i++] = v.getVariable() * -1;
        }
        Arrays.sort(tv);
        int hc = Arrays.hashCode(tv);
        if (!this.labels.containsKey(hc)) {
            return hc;
        }
        if (this.labels.get(hc).getFormulaOccurrences().get(0).comp(f)) {
            return hc;
        }
        do {
            tv[0] = tv[0] + 2;
            hc = Arrays.hashCode(tv);
            if (this.labels.containsKey(hc)) continue;
            return hc;
        } while (!this.labels.get(hc).getFormulaOccurrences().get(0).comp(f));
        return hc;
    }

    private void setLabel(Formula f) {
        TseitinVar t;
        if (f.getTseitinVar() != null) {
            return;
        }
        int hash = this.getHashValue(f);
        if (this.doHashing && hash == -1) {
            f.push();
            this.next.add(f);
            return;
        }
        f.unpush();
        if (this.doHashing && this.labels.containsKey(hash)) {
            t = this.labels.get(hash);
            assert (t != null);
        } else {
            t = new TseitinVar(hash, this.getNextLabelName());
            this.labels.put(hash, t);
        }
        t.addFormulaOccurrence(f);
        this.fd.setVarNumber(this.fd.getVarNumber() + 1);
        f.setTseitinVar(t);
        Formula s = f.getSuperFormula();
        if (s != null && !s.isPushed()) {
            s.push();
            this.next.add(s);
        }
    }

    private int getNextLabelName() {
        return this.counter++;
    }

    public void printCNF2() {
        int i = 0;
        while (i < this.definedLabels.length) {
            this.definedLabels[i] = false;
            ++i;
        }
        this.printCNF2(this.formulaRoot);
    }

    public void printCNF2(Formula f) {
        if (f.getConnective() == CType.AND) {
            for (VOccurrence v : f.getPosLits()) {
                this.print(v.getVariable());
                this.printNewLine();
            }
            for (VOccurrence v : f.getNegLits()) {
                this.print(v.getVariable() * -1);
                this.printNewLine();
            }
            for (Formula sf : f.getSubformulas()) {
                this.printCNF2(sf);
            }
        } else {
            if (f.getSubformulas().size() != 0) {
                this.printCNFMatrix(f);
                return;
            }
            for (VOccurrence v : f.getPosLits()) {
                this.print(v.getVariable());
            }
            for (VOccurrence v : f.getNegLits()) {
                this.print(v.getVariable() * -1);
            }
            this.printNewLine();
        }
    }

    public void printCNFMatrix() {
        int i = 0;
        while (i < this.definedLabels.length) {
            this.definedLabels[i] = false;
            ++i;
        }
        this.printCNFMatrix(this.formulaRoot);
    }

    private void printCNFMatrix(Formula f) {
        this.print(f.getTseitinVar().getName());
        this.printNewLine();
        if (f.getConnective() == CType.AND) {
            this.printConjunction(f);
            for (Formula sf : f.getSubformulas()) {
                this.printTseitinEncoding(sf);
            }
        } else {
            this.print(f.getTseitinVar().getName() * -1);
            this.printDisjunction(f);
            for (Formula sf : f.getSubformulas()) {
                this.printTseitinEncoding(sf);
            }
        }
    }

    private void printTseitinEncoding(Formula f) {
        if (!this.definedLabels[f.getTseitinVar().getName()]) {
            if (f.getConnective() == CType.AND) {
                this.printConjunction(f);
            } else {
                this.print(f.getTseitinVar().getName() * -1);
                this.printDisjunction(f);
            }
            this.definedLabels[f.getTseitinVar().getName()] = true;
            for (Formula sf : f.getSubformulas()) {
                this.printTseitinEncoding(sf);
            }
        }
    }

    private void printConjunction(Formula f) {
        for (VOccurrence v : f.getPosLits()) {
            this.print(f.getTseitinVar().getName() * -1);
            this.print(v.getVariable());
            this.printNewLine();
        }
        for (VOccurrence v : f.getNegLits()) {
            this.print(f.getTseitinVar().getName() * -1);
            this.print(v.getVariable() * -1);
            this.printNewLine();
        }
        for (Formula sf : f.getSubformulas()) {
            this.print(f.getTseitinVar().getName() * -1);
            this.print(sf.getTseitinVar().getName());
            this.printNewLine();
        }
    }

    private void printDisjunction(Formula f) {
        for (VOccurrence v : f.getPosLits()) {
            this.print(v.getVariable());
        }
        for (VOccurrence v : f.getNegLits()) {
            this.print(v.getVariable() * -1);
        }
        for (Formula sf : f.getSubformulas()) {
            this.print(sf.getTseitinVar().getName());
        }
        this.printNewLine();
    }

    public int countClauses() {
        this.cl = 1;
        int i = 0;
        while (i < this.definedLabels.length) {
            this.definedLabels[i] = false;
            ++i;
        }
        this.countClauses(this.formulaRoot);
        return this.cl;
    }

    private void countClauses(Formula f) {
        if (f.getConnective() == CType.AND) {
            for (VOccurrence v : f.getPosLits()) {
                ++this.cl;
            }
            for (VOccurrence v : f.getNegLits()) {
                ++this.cl;
            }
            for (Formula sf : f.getSubformulas()) {
                this.countClauses(sf);
            }
        } else {
            this.countDisjunction(f);
            for (Formula sf : f.getSubformulas()) {
                this.countTseitinEncoding(sf);
            }
        }
    }

    private void countTseitinEncoding(Formula f) {
        if (!this.definedLabels[f.getTseitinVar().getName()]) {
            if (f.getConnective() == CType.AND) {
                this.countConjunction(f);
            } else {
                this.countDisjunction(f);
            }
            this.definedLabels[f.getTseitinVar().getName()] = true;
            for (Formula sf : f.getSubformulas()) {
                this.countTseitinEncoding(sf);
            }
        }
    }

    private void countConjunction(Formula f) {
        for (VOccurrence v : f.getPosLits()) {
            ++this.cl;
        }
        for (VOccurrence v : f.getNegLits()) {
            ++this.cl;
        }
        for (Formula sf : f.getSubformulas()) {
            ++this.cl;
        }
    }

    private void countDisjunction(Formula f) {
        ++this.cl;
    }

    private void printNewLine() {
        System.out.println(" 0");
    }

    private void print(int var) {
        System.out.print(" " + var);
    }

    public static void main(String[] args) {
        System.out.println("starting parsing");
        try {
            FormulaData fd = Parser.parse(new File("tests/f4.qpro"));
            System.out.println("---");
            FormulaToCNF ftc = new FormulaToCNF(fd, true);
            ftc.label();
            ftc.printCNFMatrix();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

