/*
 * Decompiled with CFR 0.152.
 */
package at.jku.fmv.qbf.nnf.formula;

import at.jku.fmv.qbf.nnf.formula.CType;
import at.jku.fmv.qbf.nnf.formula.IVar;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.QType;
import at.jku.fmv.qbf.nnf.formula.Quantifiers;
import at.jku.fmv.qbf.nnf.formula.TseitinVar;
import at.jku.fmv.qbf.nnf.formula.VOccurrence;
import java.util.ArrayList;
import java.util.List;

public class Formula {
    private Formula superFormula = null;
    private CType connective;
    private Quantifiers quantifiers;
    private boolean isPushed = false;
    private ArrayList<Formula> subFormulas = new ArrayList();
    private ArrayList<VOccurrence> plits;
    private ArrayList<VOccurrence> nlits;
    private TseitinVar tseitinVar = null;

    public Formula() {
        this.quantifiers = new Quantifiers(this);
        this.plits = new ArrayList();
        this.nlits = new ArrayList();
    }

    public boolean comp(Formula f) {
        if (f.getQuantifiers().size() != 0) {
            return false;
        }
        if (this.getQuantifiers().size() != 0) {
            return false;
        }
        if (f.getConnective() != this.getConnective()) {
            return false;
        }
        if (f.getPosLits().size() != this.plits.size()) {
            return false;
        }
        if (f.getNegLits().size() != this.nlits.size()) {
            return false;
        }
        if (f.getSubformulas().size() != this.getSubformulas().size()) {
            return false;
        }
        int i = 0;
        while (i < f.getPosLits().size()) {
            if (f.getPosLits().get(i).getVariable() != this.plits.get(i).getVariable()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < f.getNegLits().size()) {
            if (f.getNegLits().get(i).getVariable() != this.nlits.get(i).getVariable()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < f.getSubformulas().size()) {
            if (f.getSubformulas().get(i).getTseitinVar().getName() != this.subFormulas.get(i).getTseitinVar().getName()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void unpush() {
        this.isPushed = false;
    }

    public void push() {
        this.isPushed = true;
    }

    public boolean isPushed() {
        return this.isPushed;
    }

    public void setTseitinVar(TseitinVar t) {
        this.tseitinVar = t;
    }

    public TseitinVar getTseitinVar() {
        return this.tseitinVar;
    }

    public void setConnective(CType connective) {
        this.connective = connective;
    }

    public List<Formula> getSubformulas() {
        return this.subFormulas;
    }

    public List<VOccurrence> getPosLits() {
        return this.plits;
    }

    public List<VOccurrence> getNegLits() {
        return this.nlits;
    }

    public Quantifiers getQuantifiers() {
        return this.quantifiers;
    }

    public void addPlit(VOccurrence v) {
        this.plits.add(v);
        v.setFormulaPosition(this, true);
    }

    public void addNlit(VOccurrence v) {
        this.nlits.add(v);
        v.setFormulaPosition(this, false);
    }

    public void addSubFormula(Formula subFormula) {
        subFormula.setSuperFormula(this);
        this.subFormulas.add(subFormula);
    }

    public void setSuperFormula(Formula sf) {
        this.superFormula = sf;
    }

    public Formula getSuperFormula() {
        return this.superFormula;
    }

    public CType getConnective() {
        return this.connective;
    }

    public void addQBlock(QBlock q) {
        this.quantifiers.addQuantBlock(q);
    }

    public void print() {
        this.printFormula(this);
    }

    private void printFormula(Formula f) {
        if (f.getQuantifiers().size() != 0) {
            this.printQuantifiers(f);
            return;
        }
        if (f.getConnective() == CType.AND) {
            this.printConjunction(f);
        } else {
            this.printDisjunction(f);
        }
    }

    private void printDisjunction(Formula f) {
        System.out.println("d");
        this.printConnective(f);
        System.out.println("/d");
    }

    private void printConjunction(Formula f) {
        System.out.println("c");
        this.printConnective(f);
        System.out.println("/c");
    }

    private void printConnective(Formula f) {
        for (VOccurrence v : f.getPosLits()) {
            System.out.print(v.getVariable() + " ");
        }
        System.out.println();
        for (VOccurrence v : f.getNegLits()) {
            System.out.print(v.getVariable() + " ");
        }
        System.out.println();
        for (Formula sf : f.getSubformulas()) {
            this.printFormula(sf);
        }
    }

    private void printQuantifiers(Formula f) {
        Quantifiers q = f.getQuantifiers();
        System.out.println("q");
        for (QBlock b : q.getQuantifierBlocks()) {
            if (b.getQType() == QType.EXISTS) {
                System.out.print("e ");
            } else {
                System.out.print("a ");
            }
            for (IVar v : b.getVars()) {
                System.out.print(String.valueOf(v.getName()) + " ");
            }
            System.out.println();
        }
        if (f.getConnective() == CType.AND) {
            this.printConjunction(f);
        } else {
            this.printDisjunction(f);
        }
        System.out.println("/q");
    }

    public void printBoole() {
        if (this.quantifiers.size() != 0) {
            this.printQuantifiers();
            return;
        }
        this.printConnective();
    }

    private void printQuantifiers() {
        int count = 0;
        for (QBlock qb : this.quantifiers.getQuantifierBlocks()) {
            if (qb.getVars().size() == 0) continue;
            if (qb.getQType() == QType.FORALL) {
                System.out.print("forall [");
            } else {
                System.out.print("exists [");
            }
            for (IVar vi : qb.getVars()) {
                System.out.print("v" + vi.getName() + " ");
            }
            System.out.print("](");
            ++count;
        }
        this.printConnective();
        int i = 0;
        while (i < count) {
            System.out.print(")");
            ++i;
        }
    }

    private void printConnective() {
        char token = this.connective == CType.AND ? (char)'&' : '|';
        int count = this.plits.size() + this.nlits.size() + this.subFormulas.size();
        for (VOccurrence c : this.plits) {
            System.out.print("v" + c.getVariable());
            if (count > 1) {
                System.out.print(" " + token + " ");
            }
            --count;
        }
        for (VOccurrence c : this.nlits) {
            System.out.print("!v" + c.getVariable());
            if (count > 1) {
                System.out.print(" " + token + " ");
            }
            --count;
        }
        for (Formula f : this.subFormulas) {
            System.out.print("(");
            f.printBoole();
            System.out.print(")");
            if (count > 1) {
                System.out.print(" " + token + " ");
            }
            --count;
        }
    }

    public void setQuantifier(Quantifiers q) {
        this.quantifiers = q;
    }
}

