/*
 * Decompiled with CFR 0.152.
 */
package at.jku.fmv.qbf.nnf.formula;

import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.VOccurrence;
import at.jku.fmv.qbf.nnf.formula.VariableInfo;
import at.jku.fmv.qbf.nnf.formula.Variables;
import java.util.HashMap;

public class FormulaData {
    private Variables vars;
    private int varNumber;
    private HashMap<Integer, Integer> nameOfVars;
    private Formula root;
    private boolean[] varInScope;

    public FormulaData(int varNumber, Formula rootFormula) {
        this.root = rootFormula;
        this.vars = new Variables();
        this.varNumber = varNumber;
        this.nameOfVars = new HashMap();
        this.varInScope = new boolean[varNumber];
    }

    public FormulaData(Formula rootFormula) {
        this.root = rootFormula;
        this.vars = new Variables();
        this.varNumber = Integer.MAX_VALUE;
        this.nameOfVars = new HashMap();
        this.varInScope = new boolean[this.varNumber];
    }

    public void setVarNumber(int varNumber) {
        this.varNumber = varNumber;
    }

    public int getVarNumber() {
        return this.varNumber;
    }

    public void setFormula(Formula root) {
        this.root = root;
    }

    public Formula getFormula() {
        return this.root;
    }

    public void print() {
        System.out.println("QBF\n" + this.varNumber);
        this.root.print();
    }

    public void addPosVarOcc(int v, Formula f) {
        assert (this.varInScope[v]) : "variable not in scope of quantifier";
        assert (v <= this.varNumber) : "variable too big: " + v;
        assert (this.nameOfVars.get(v) != 0) : "variable not quantified: " + v;
        VOccurrence vOcc = new VOccurrence(this.nameOfVars.get(v));
        this.vars.addPosOccurrence(vOcc);
        f.addPlit(vOcc);
    }

    public void addNegVarOcc(int v, Formula f) {
        assert (this.varInScope[v]) : "variable not in scope of quantifier";
        assert (v <= this.varNumber) : "variable too big: " + v;
        assert (this.nameOfVars.get(v) != 0) : "variable not quantified: " + v;
        VOccurrence vOcc = new VOccurrence(this.nameOfVars.get(v));
        this.vars.addNegOccurrence(vOcc);
        f.addNlit(vOcc);
    }

    public void addVar(int var, QBlock qblock) {
        this.varInScope[var] = true;
        assert (this.nameOfVars.get(var) == null) : "variable is already quantified: " + var;
        VariableInfo vinfo = new VariableInfo(qblock);
        int vi = this.vars.addVar(vinfo);
        this.nameOfVars.put(var, vi);
        qblock.add(vinfo);
    }

    public void removeVarFromScpe(int var) {
        this.varInScope[var] = false;
    }

    public void printBoole() {
        this.root.printBoole();
    }
}

