/*
 * Decompiled with CFR 0.152.
 */
package at.jku.fmv.qbf.nnf.transform.prenex;

import at.jku.fmv.qbf.nnf.formula.Formula;
import at.jku.fmv.qbf.nnf.formula.FormulaData;
import at.jku.fmv.qbf.nnf.formula.IVar;
import at.jku.fmv.qbf.nnf.formula.QBlock;
import at.jku.fmv.qbf.nnf.formula.QType;
import at.jku.fmv.qbf.nnf.formula.Quantifiers;
import at.jku.fmv.qbf.nnf.formula.TseitinVar;
import at.jku.fmv.qbf.nnf.parser.ParseException;
import at.jku.fmv.qbf.nnf.parser.Parser;
import at.jku.fmv.qbf.nnf.transform.matrix.FormulaToCNF;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;

public class PrenexPrinter {
    FormulaData fd;
    LinkedList<QBlock> ex;
    LinkedList<QBlock> all;
    LinkedList<TseitinVar> tseitin;
    boolean[] printedTseitinVars;

    public PrenexPrinter(FormulaData fd) {
        this.fd = fd;
    }

    public void printPrenex() {
        this.ex = new LinkedList();
        this.all = new LinkedList();
        this.tseitin = new LinkedList();
        this.sublookforQuant(this.fd.getFormula());
        this.printedTseitinVars = new boolean[this.fd.getVarNumber() + 1];
        if (!this.ex.isEmpty() || !this.tseitin.isEmpty()) {
            this.printExists();
        } else {
            this.printForall();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void printExists() {
        while (!this.tseitin.isEmpty() && this.printedTseitinVars[this.tseitin.peek().getName()]) {
            this.tseitin.pop();
        }
        if (this.tseitin.isEmpty() && this.ex.isEmpty()) {
            return;
        }
        this.print("e ");
        while (!this.tseitin.isEmpty()) {
            TseitinVar t = this.tseitin.pop();
            if (this.printedTseitinVars[t.getName()]) continue;
            this.print(String.valueOf(t.getName()) + " ");
            this.printedTseitinVars[t.getName()] = true;
        }
        while (!this.ex.isEmpty()) {
            QBlock q = this.ex.poll();
            for (IVar v : q.getVars()) {
                if (this.printedTseitinVars[v.getName()]) continue;
                this.print(String.valueOf(v.getName()) + " ");
                this.printedTseitinVars[v.getName()] = true;
            }
            int i = q.getQuantifiers().getQuantifierBlocks().indexOf(q);
            if (q.getQuantifiers().getQuantifierBlocks().size() > i + 1) {
                this.all.push(q.getQuantifiers().getQuantifierBlocks().get(i + 1));
            } else {
                this.lookforQuant(q.getQuantifiers().getFormula());
            }
            while (!this.tseitin.isEmpty()) {
                TseitinVar t = this.tseitin.pop();
                if (this.printedTseitinVars[t.getName()]) continue;
                this.print(String.valueOf(t.getName()) + " ");
                this.printedTseitinVars[t.getName()] = true;
            }
        }
        this.print("0\n");
        this.printForall();
    }

    private void print(String s) {
        System.out.print(s);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void printForall() {
        if (this.all.isEmpty()) {
            return;
        }
        this.print("a ");
        while (!this.all.isEmpty()) {
            QBlock q = this.all.poll();
            for (IVar v : q.getVars()) {
                if (this.printedTseitinVars[v.getName()]) continue;
                this.print(String.valueOf(v.getName()) + " ");
                this.printedTseitinVars[v.getName()] = true;
            }
            int i = q.getQuantifiers().getQuantifierBlocks().indexOf(q);
            if (q.getQuantifiers().getQuantifierBlocks().size() > i + 1) {
                this.ex.push(q.getQuantifiers().getQuantifierBlocks().get(i + 1));
                continue;
            }
            this.lookforQuant(q.getQuantifiers().getFormula());
        }
        this.print("0\n");
        this.printExists();
    }

    private void lookforQuant(Formula f) {
        for (Formula fs : f.getSubformulas()) {
            this.sublookforQuant(fs);
        }
    }

    private void sublookforQuant(Formula f) {
        if (f.getTseitinVar() != null) {
            this.tseitin.add(f.getTseitinVar());
        }
        if (f.getQuantifiers() == null || f.getQuantifiers().getQuantifierBlocks() == null || f.getQuantifiers().getQuantifierBlocks().size() == 0) {
            for (Formula fs : f.getSubformulas()) {
                this.sublookforQuant(fs);
            }
            return;
        }
        Quantifiers q1 = f.getQuantifiers();
        ArrayList qb = (ArrayList)q1.getQuantifierBlocks();
        if (qb.size() != 0) {
            QBlock q = (QBlock)qb.get(0);
            if (q.getQType() == QType.EXISTS) {
                this.ex.push(q);
            } else {
                this.all.push(q);
            }
        }
    }

    public static void main(String[] args) {
        try {
            FormulaData fd = Parser.parse(new File("tests/f11"));
            FormulaToCNF ftc = new FormulaToCNF(fd, true);
            ftc.label();
            System.out.println("p cnf " + fd.getVarNumber() + " " + ftc.countClauses());
            PrenexPrinter p = new PrenexPrinter(fd);
            p.printPrenex();
            ftc.printCNFMatrix();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }
}

