/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.modelevolution.multiview.conflictreport.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.modelevolution.multiview.MultiviewModel;

import org.modelevolution.multiview.conflictreport.ConflictFragment;
import org.modelevolution.multiview.conflictreport.ConflictReport;
import org.modelevolution.multiview.conflictreport.ConflictReportPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Conflict Report</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.ConflictReportImpl#getRightComparisonSnapshot <em>Right Comparison Snapshot</em>}</li>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.ConflictReportImpl#getLeftComparisonSnapshot <em>Left Comparison Snapshot</em>}</li>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.ConflictReportImpl#getOriginVersion <em>Origin Version</em>}</li>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.ConflictReportImpl#getLeftVersion <em>Left Version</em>}</li>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.ConflictReportImpl#getRightVersion <em>Right Version</em>}</li>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.ConflictReportImpl#getConflicts <em>Conflicts</em>}</li>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.ConflictReportImpl#getMergedVersions <em>Merged Versions</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ConflictReportImpl extends EObjectImpl implements ConflictReport {
	/**
	 * The cached value of the '{@link #getRightComparisonSnapshot() <em>Right Comparison Snapshot</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRightComparisonSnapshot()
	 * @generated
	 * @ordered
	 */
	protected ComparisonResourceSnapshot rightComparisonSnapshot;

	/**
	 * The cached value of the '{@link #getLeftComparisonSnapshot() <em>Left Comparison Snapshot</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLeftComparisonSnapshot()
	 * @generated
	 * @ordered
	 */
	protected ComparisonResourceSnapshot leftComparisonSnapshot;

	/**
	 * The cached value of the '{@link #getOriginVersion() <em>Origin Version</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOriginVersion()
	 * @generated
	 * @ordered
	 */
	protected MultiviewModel originVersion;

	/**
	 * This is true if the Origin Version reference has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean originVersionESet;

	/**
	 * The cached value of the '{@link #getLeftVersion() <em>Left Version</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLeftVersion()
	 * @generated
	 * @ordered
	 */
	protected MultiviewModel leftVersion;

	/**
	 * This is true if the Left Version reference has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean leftVersionESet;

	/**
	 * The cached value of the '{@link #getRightVersion() <em>Right Version</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRightVersion()
	 * @generated
	 * @ordered
	 */
	protected MultiviewModel rightVersion;

	/**
	 * This is true if the Right Version reference has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean rightVersionESet;

	/**
	 * The cached value of the '{@link #getConflicts() <em>Conflicts</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConflicts()
	 * @generated
	 * @ordered
	 */
	protected EList<ConflictFragment> conflicts;

	/**
	 * The cached value of the '{@link #getMergedVersions() <em>Merged Versions</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMergedVersions()
	 * @generated
	 * @ordered
	 */
	protected EList<MultiviewModel> mergedVersions;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConflictReportImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ConflictReportPackage.Literals.CONFLICT_REPORT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComparisonResourceSnapshot getRightComparisonSnapshot() {
		return rightComparisonSnapshot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRightComparisonSnapshot(ComparisonResourceSnapshot newRightComparisonSnapshot, NotificationChain msgs) {
		ComparisonResourceSnapshot oldRightComparisonSnapshot = rightComparisonSnapshot;
		rightComparisonSnapshot = newRightComparisonSnapshot;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ConflictReportPackage.CONFLICT_REPORT__RIGHT_COMPARISON_SNAPSHOT, oldRightComparisonSnapshot, newRightComparisonSnapshot);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRightComparisonSnapshot(ComparisonResourceSnapshot newRightComparisonSnapshot) {
		if (newRightComparisonSnapshot != rightComparisonSnapshot) {
			NotificationChain msgs = null;
			if (rightComparisonSnapshot != null)
				msgs = ((InternalEObject)rightComparisonSnapshot).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ConflictReportPackage.CONFLICT_REPORT__RIGHT_COMPARISON_SNAPSHOT, null, msgs);
			if (newRightComparisonSnapshot != null)
				msgs = ((InternalEObject)newRightComparisonSnapshot).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ConflictReportPackage.CONFLICT_REPORT__RIGHT_COMPARISON_SNAPSHOT, null, msgs);
			msgs = basicSetRightComparisonSnapshot(newRightComparisonSnapshot, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConflictReportPackage.CONFLICT_REPORT__RIGHT_COMPARISON_SNAPSHOT, newRightComparisonSnapshot, newRightComparisonSnapshot));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComparisonResourceSnapshot getLeftComparisonSnapshot() {
		return leftComparisonSnapshot;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLeftComparisonSnapshot(ComparisonResourceSnapshot newLeftComparisonSnapshot, NotificationChain msgs) {
		ComparisonResourceSnapshot oldLeftComparisonSnapshot = leftComparisonSnapshot;
		leftComparisonSnapshot = newLeftComparisonSnapshot;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ConflictReportPackage.CONFLICT_REPORT__LEFT_COMPARISON_SNAPSHOT, oldLeftComparisonSnapshot, newLeftComparisonSnapshot);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLeftComparisonSnapshot(ComparisonResourceSnapshot newLeftComparisonSnapshot) {
		if (newLeftComparisonSnapshot != leftComparisonSnapshot) {
			NotificationChain msgs = null;
			if (leftComparisonSnapshot != null)
				msgs = ((InternalEObject)leftComparisonSnapshot).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ConflictReportPackage.CONFLICT_REPORT__LEFT_COMPARISON_SNAPSHOT, null, msgs);
			if (newLeftComparisonSnapshot != null)
				msgs = ((InternalEObject)newLeftComparisonSnapshot).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ConflictReportPackage.CONFLICT_REPORT__LEFT_COMPARISON_SNAPSHOT, null, msgs);
			msgs = basicSetLeftComparisonSnapshot(newLeftComparisonSnapshot, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConflictReportPackage.CONFLICT_REPORT__LEFT_COMPARISON_SNAPSHOT, newLeftComparisonSnapshot, newLeftComparisonSnapshot));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MultiviewModel getOriginVersion() {
		if (originVersion != null && originVersion.eIsProxy()) {
			InternalEObject oldOriginVersion = (InternalEObject)originVersion;
			originVersion = (MultiviewModel)eResolveProxy(oldOriginVersion);
			if (originVersion != oldOriginVersion) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ConflictReportPackage.CONFLICT_REPORT__ORIGIN_VERSION, oldOriginVersion, originVersion));
			}
		}
		return originVersion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MultiviewModel basicGetOriginVersion() {
		return originVersion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOriginVersion(MultiviewModel newOriginVersion) {
		MultiviewModel oldOriginVersion = originVersion;
		originVersion = newOriginVersion;
		boolean oldOriginVersionESet = originVersionESet;
		originVersionESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConflictReportPackage.CONFLICT_REPORT__ORIGIN_VERSION, oldOriginVersion, originVersion, !oldOriginVersionESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetOriginVersion() {
		MultiviewModel oldOriginVersion = originVersion;
		boolean oldOriginVersionESet = originVersionESet;
		originVersion = null;
		originVersionESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, ConflictReportPackage.CONFLICT_REPORT__ORIGIN_VERSION, oldOriginVersion, null, oldOriginVersionESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetOriginVersion() {
		return originVersionESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MultiviewModel getLeftVersion() {
		if (leftVersion != null && leftVersion.eIsProxy()) {
			InternalEObject oldLeftVersion = (InternalEObject)leftVersion;
			leftVersion = (MultiviewModel)eResolveProxy(oldLeftVersion);
			if (leftVersion != oldLeftVersion) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ConflictReportPackage.CONFLICT_REPORT__LEFT_VERSION, oldLeftVersion, leftVersion));
			}
		}
		return leftVersion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MultiviewModel basicGetLeftVersion() {
		return leftVersion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLeftVersion(MultiviewModel newLeftVersion) {
		MultiviewModel oldLeftVersion = leftVersion;
		leftVersion = newLeftVersion;
		boolean oldLeftVersionESet = leftVersionESet;
		leftVersionESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConflictReportPackage.CONFLICT_REPORT__LEFT_VERSION, oldLeftVersion, leftVersion, !oldLeftVersionESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetLeftVersion() {
		MultiviewModel oldLeftVersion = leftVersion;
		boolean oldLeftVersionESet = leftVersionESet;
		leftVersion = null;
		leftVersionESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, ConflictReportPackage.CONFLICT_REPORT__LEFT_VERSION, oldLeftVersion, null, oldLeftVersionESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetLeftVersion() {
		return leftVersionESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MultiviewModel getRightVersion() {
		if (rightVersion != null && rightVersion.eIsProxy()) {
			InternalEObject oldRightVersion = (InternalEObject)rightVersion;
			rightVersion = (MultiviewModel)eResolveProxy(oldRightVersion);
			if (rightVersion != oldRightVersion) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ConflictReportPackage.CONFLICT_REPORT__RIGHT_VERSION, oldRightVersion, rightVersion));
			}
		}
		return rightVersion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MultiviewModel basicGetRightVersion() {
		return rightVersion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRightVersion(MultiviewModel newRightVersion) {
		MultiviewModel oldRightVersion = rightVersion;
		rightVersion = newRightVersion;
		boolean oldRightVersionESet = rightVersionESet;
		rightVersionESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConflictReportPackage.CONFLICT_REPORT__RIGHT_VERSION, oldRightVersion, rightVersion, !oldRightVersionESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetRightVersion() {
		MultiviewModel oldRightVersion = rightVersion;
		boolean oldRightVersionESet = rightVersionESet;
		rightVersion = null;
		rightVersionESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, ConflictReportPackage.CONFLICT_REPORT__RIGHT_VERSION, oldRightVersion, null, oldRightVersionESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetRightVersion() {
		return rightVersionESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<ConflictFragment> getConflicts() {
		if (conflicts == null) {
			conflicts = new EObjectContainmentWithInverseEList<ConflictFragment>(ConflictFragment.class, this, ConflictReportPackage.CONFLICT_REPORT__CONFLICTS, ConflictReportPackage.CONFLICT_FRAGMENT__CONFLICT_REPORT);
		}
		return conflicts;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<MultiviewModel> getMergedVersions() {
		if (mergedVersions == null) {
			mergedVersions = new EObjectResolvingEList<MultiviewModel>(MultiviewModel.class, this, ConflictReportPackage.CONFLICT_REPORT__MERGED_VERSIONS);
		}
		return mergedVersions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ConflictReportPackage.CONFLICT_REPORT__CONFLICTS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getConflicts()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ConflictReportPackage.CONFLICT_REPORT__RIGHT_COMPARISON_SNAPSHOT:
				return basicSetRightComparisonSnapshot(null, msgs);
			case ConflictReportPackage.CONFLICT_REPORT__LEFT_COMPARISON_SNAPSHOT:
				return basicSetLeftComparisonSnapshot(null, msgs);
			case ConflictReportPackage.CONFLICT_REPORT__CONFLICTS:
				return ((InternalEList<?>)getConflicts()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ConflictReportPackage.CONFLICT_REPORT__RIGHT_COMPARISON_SNAPSHOT:
				return getRightComparisonSnapshot();
			case ConflictReportPackage.CONFLICT_REPORT__LEFT_COMPARISON_SNAPSHOT:
				return getLeftComparisonSnapshot();
			case ConflictReportPackage.CONFLICT_REPORT__ORIGIN_VERSION:
				if (resolve) return getOriginVersion();
				return basicGetOriginVersion();
			case ConflictReportPackage.CONFLICT_REPORT__LEFT_VERSION:
				if (resolve) return getLeftVersion();
				return basicGetLeftVersion();
			case ConflictReportPackage.CONFLICT_REPORT__RIGHT_VERSION:
				if (resolve) return getRightVersion();
				return basicGetRightVersion();
			case ConflictReportPackage.CONFLICT_REPORT__CONFLICTS:
				return getConflicts();
			case ConflictReportPackage.CONFLICT_REPORT__MERGED_VERSIONS:
				return getMergedVersions();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ConflictReportPackage.CONFLICT_REPORT__RIGHT_COMPARISON_SNAPSHOT:
				setRightComparisonSnapshot((ComparisonResourceSnapshot)newValue);
				return;
			case ConflictReportPackage.CONFLICT_REPORT__LEFT_COMPARISON_SNAPSHOT:
				setLeftComparisonSnapshot((ComparisonResourceSnapshot)newValue);
				return;
			case ConflictReportPackage.CONFLICT_REPORT__ORIGIN_VERSION:
				setOriginVersion((MultiviewModel)newValue);
				return;
			case ConflictReportPackage.CONFLICT_REPORT__LEFT_VERSION:
				setLeftVersion((MultiviewModel)newValue);
				return;
			case ConflictReportPackage.CONFLICT_REPORT__RIGHT_VERSION:
				setRightVersion((MultiviewModel)newValue);
				return;
			case ConflictReportPackage.CONFLICT_REPORT__CONFLICTS:
				getConflicts().clear();
				getConflicts().addAll((Collection<? extends ConflictFragment>)newValue);
				return;
			case ConflictReportPackage.CONFLICT_REPORT__MERGED_VERSIONS:
				getMergedVersions().clear();
				getMergedVersions().addAll((Collection<? extends MultiviewModel>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ConflictReportPackage.CONFLICT_REPORT__RIGHT_COMPARISON_SNAPSHOT:
				setRightComparisonSnapshot((ComparisonResourceSnapshot)null);
				return;
			case ConflictReportPackage.CONFLICT_REPORT__LEFT_COMPARISON_SNAPSHOT:
				setLeftComparisonSnapshot((ComparisonResourceSnapshot)null);
				return;
			case ConflictReportPackage.CONFLICT_REPORT__ORIGIN_VERSION:
				unsetOriginVersion();
				return;
			case ConflictReportPackage.CONFLICT_REPORT__LEFT_VERSION:
				unsetLeftVersion();
				return;
			case ConflictReportPackage.CONFLICT_REPORT__RIGHT_VERSION:
				unsetRightVersion();
				return;
			case ConflictReportPackage.CONFLICT_REPORT__CONFLICTS:
				getConflicts().clear();
				return;
			case ConflictReportPackage.CONFLICT_REPORT__MERGED_VERSIONS:
				getMergedVersions().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ConflictReportPackage.CONFLICT_REPORT__RIGHT_COMPARISON_SNAPSHOT:
				return rightComparisonSnapshot != null;
			case ConflictReportPackage.CONFLICT_REPORT__LEFT_COMPARISON_SNAPSHOT:
				return leftComparisonSnapshot != null;
			case ConflictReportPackage.CONFLICT_REPORT__ORIGIN_VERSION:
				return isSetOriginVersion();
			case ConflictReportPackage.CONFLICT_REPORT__LEFT_VERSION:
				return isSetLeftVersion();
			case ConflictReportPackage.CONFLICT_REPORT__RIGHT_VERSION:
				return isSetRightVersion();
			case ConflictReportPackage.CONFLICT_REPORT__CONFLICTS:
				return conflicts != null && !conflicts.isEmpty();
			case ConflictReportPackage.CONFLICT_REPORT__MERGED_VERSIONS:
				return mergedVersions != null && !mergedVersions.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //ConflictReportImpl
