/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.modelevolution.multiview.conflictreport.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.compare.diff.metamodel.DifferenceKind;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;

import org.modelevolution.multiview.Message;

import org.modelevolution.multiview.conflictreport.ConflictFragment;
import org.modelevolution.multiview.conflictreport.ConflictReportPackage;
import org.modelevolution.multiview.conflictreport.MergeOption;
import org.modelevolution.multiview.util.BubbleSorter;
import org.modelevolution.multiview.util.MessageComparator;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Merge Option</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.MergeOptionImpl#getStartMessage <em>Start Message</em>}</li>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.MergeOptionImpl#getEndMessage <em>End Message</em>}</li>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.MergeOptionImpl#getConflictFragment <em>Conflict Fragment</em>}</li>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.MergeOptionImpl#getLeftMessages <em>Left Messages</em>}</li>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.MergeOptionImpl#getRightMessages <em>Right Messages</em>}</li>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.MergeOptionImpl#getLeftAddedMessages <em>Left Added Messages</em>}</li>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.MergeOptionImpl#getRightAddedMessages <em>Right Added Messages</em>}</li>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.MergeOptionImpl#getLeftDeletedMessages <em>Left Deleted Messages</em>}</li>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.MergeOptionImpl#getRightDeletedMessages <em>Right Deleted Messages</em>}</li>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.MergeOptionImpl#getLeftUpdatedMessages <em>Left Updated Messages</em>}</li>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.MergeOptionImpl#getRightUpdatedMessages <em>Right Updated Messages</em>}</li>
 *   <li>{@link org.modelevolution.multiview.conflictreport.impl.MergeOptionImpl#getMessages <em>Messages</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class MergeOptionImpl extends EObjectImpl implements MergeOption {
	/**
	 * The cached value of the '{@link #getStartMessage() <em>Start Message</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStartMessage()
	 * @generated
	 * @ordered
	 */
	protected Message startMessage;

	/**
	 * The cached value of the '{@link #getEndMessage() <em>End Message</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEndMessage()
	 * @generated
	 * @ordered
	 */
	protected Message endMessage;

	/**
	 * The cached value of the '{@link #getLeftMessages() <em>Left Messages</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLeftMessages()
	 * @generated
	 * @ordered
	 */
	protected EList<Message> leftMessages;

	/**
	 * The cached value of the '{@link #getRightMessages() <em>Right Messages</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRightMessages()
	 * @generated
	 * @ordered
	 */
	protected EList<Message> rightMessages;

	/**
	 * The cached value of the '{@link #getLeftAddedMessages() <em>Left Added Messages</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLeftAddedMessages()
	 * @generated
	 * @ordered
	 */
	protected EList<Message> leftAddedMessages;

	/**
	 * The cached value of the '{@link #getRightAddedMessages() <em>Right Added Messages</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRightAddedMessages()
	 * @generated
	 * @ordered
	 */
	protected EList<Message> rightAddedMessages;

	/**
	 * The cached value of the '{@link #getLeftDeletedMessages() <em>Left Deleted Messages</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLeftDeletedMessages()
	 * @generated
	 * @ordered
	 */
	protected EList<Message> leftDeletedMessages;

	/**
	 * The cached value of the '{@link #getRightDeletedMessages() <em>Right Deleted Messages</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRightDeletedMessages()
	 * @generated
	 * @ordered
	 */
	protected EList<Message> rightDeletedMessages;

	/**
	 * The cached value of the '{@link #getLeftUpdatedMessages() <em>Left Updated Messages</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLeftUpdatedMessages()
	 * @generated
	 * @ordered
	 */
	protected EList<Message> leftUpdatedMessages;

	/**
	 * The cached value of the '{@link #getRightUpdatedMessages() <em>Right Updated Messages</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRightUpdatedMessages()
	 * @generated
	 * @ordered
	 */
	protected EList<Message> rightUpdatedMessages;

	/**
	 * The cached value of the '{@link #getMessages() <em>Messages</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMessages()
	 * @generated
	 * @ordered
	 */
	protected EList<Message> messages;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MergeOptionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ConflictReportPackage.Literals.MERGE_OPTION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Message getStartMessage() {
		if (startMessage != null && startMessage.eIsProxy()) {
			InternalEObject oldStartMessage = (InternalEObject)startMessage;
			startMessage = (Message)eResolveProxy(oldStartMessage);
			if (startMessage != oldStartMessage) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ConflictReportPackage.MERGE_OPTION__START_MESSAGE, oldStartMessage, startMessage));
			}
		}
		return startMessage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Message basicGetStartMessage() {
		return startMessage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStartMessage(Message newStartMessage) {
		Message oldStartMessage = startMessage;
		startMessage = newStartMessage;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConflictReportPackage.MERGE_OPTION__START_MESSAGE, oldStartMessage, startMessage));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Message getEndMessage() {
		if (endMessage != null && endMessage.eIsProxy()) {
			InternalEObject oldEndMessage = (InternalEObject)endMessage;
			endMessage = (Message)eResolveProxy(oldEndMessage);
			if (endMessage != oldEndMessage) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ConflictReportPackage.MERGE_OPTION__END_MESSAGE, oldEndMessage, endMessage));
			}
		}
		return endMessage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Message basicGetEndMessage() {
		return endMessage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setEndMessage(Message newEndMessage) {
		Message oldEndMessage = endMessage;
		endMessage = newEndMessage;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConflictReportPackage.MERGE_OPTION__END_MESSAGE, oldEndMessage, endMessage));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConflictFragment getConflictFragment() {
		if (eContainerFeatureID() != ConflictReportPackage.MERGE_OPTION__CONFLICT_FRAGMENT) return null;
		return (ConflictFragment)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetConflictFragment(ConflictFragment newConflictFragment, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newConflictFragment, ConflictReportPackage.MERGE_OPTION__CONFLICT_FRAGMENT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConflictFragment(ConflictFragment newConflictFragment) {
		if (newConflictFragment != eInternalContainer() || (eContainerFeatureID() != ConflictReportPackage.MERGE_OPTION__CONFLICT_FRAGMENT && newConflictFragment != null)) {
			if (EcoreUtil.isAncestor(this, newConflictFragment))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newConflictFragment != null)
				msgs = ((InternalEObject)newConflictFragment).eInverseAdd(this, ConflictReportPackage.CONFLICT_FRAGMENT__MERGE_OPTIONS, ConflictFragment.class, msgs);
			msgs = basicSetConflictFragment(newConflictFragment, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ConflictReportPackage.MERGE_OPTION__CONFLICT_FRAGMENT, newConflictFragment, newConflictFragment));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<Message> getLeftMessages() {
		leftMessages = new BasicEList<Message>();
		leftMessages.addAll(leftAddedMessages);
		leftMessages.addAll(leftDeletedMessages);
		leftMessages.addAll(leftUpdatedMessages);
		
		BubbleSorter.sort(leftMessages, new MessageComparator());

		return leftMessages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<Message> getRightMessages() {
		rightMessages = new BasicEList<Message>();
		rightMessages.addAll(rightAddedMessages);
		rightMessages.addAll(rightDeletedMessages);
		rightMessages.addAll(rightUpdatedMessages);
		
		BubbleSorter.sort(rightMessages, new MessageComparator());

		return rightMessages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<Message> getLeftAddedMessages() {
		if (leftAddedMessages == null) {
			leftAddedMessages = new EObjectResolvingEList<Message>(Message.class, this, ConflictReportPackage.MERGE_OPTION__LEFT_ADDED_MESSAGES);
		}
		return leftAddedMessages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Message> getRightAddedMessages() {
		if (rightAddedMessages == null) {
			rightAddedMessages = new EObjectResolvingEList<Message>(Message.class, this, ConflictReportPackage.MERGE_OPTION__RIGHT_ADDED_MESSAGES);
		}
		return rightAddedMessages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Message> getLeftDeletedMessages() {
		if (leftDeletedMessages == null) {
			leftDeletedMessages = new EObjectResolvingEList<Message>(Message.class, this, ConflictReportPackage.MERGE_OPTION__LEFT_DELETED_MESSAGES);
		}
		return leftDeletedMessages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Message> getRightDeletedMessages() {
		if (rightDeletedMessages == null) {
			rightDeletedMessages = new EObjectResolvingEList<Message>(Message.class, this, ConflictReportPackage.MERGE_OPTION__RIGHT_DELETED_MESSAGES);
		}
		return rightDeletedMessages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Message> getLeftUpdatedMessages() {
		if (leftUpdatedMessages == null) {
			leftUpdatedMessages = new EObjectResolvingEList<Message>(Message.class, this, ConflictReportPackage.MERGE_OPTION__LEFT_UPDATED_MESSAGES);
		}
		return leftUpdatedMessages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Message> getRightUpdatedMessages() {
		if (rightUpdatedMessages == null) {
			rightUpdatedMessages = new EObjectResolvingEList<Message>(Message.class, this, ConflictReportPackage.MERGE_OPTION__RIGHT_UPDATED_MESSAGES);
		}
		return rightUpdatedMessages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<Message> getMessages() {
		
		if (messages == null || messages.isEmpty() || eResource().isModified()) {
			messages = new BasicEList<Message>();
			messages.addAll(getLeftMessages());
			messages.addAll(getRightMessages());
			BubbleSorter.sort(messages, new MessageComparator());
		}
		
		return messages;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DifferenceKind getDifferenceKind(Message msg) {
		// TODO: implement this method
		// Ensure that you remove @generated or mark it @generated NOT
		throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ConflictReportPackage.MERGE_OPTION__CONFLICT_FRAGMENT:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetConflictFragment((ConflictFragment)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ConflictReportPackage.MERGE_OPTION__CONFLICT_FRAGMENT:
				return basicSetConflictFragment(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case ConflictReportPackage.MERGE_OPTION__CONFLICT_FRAGMENT:
				return eInternalContainer().eInverseRemove(this, ConflictReportPackage.CONFLICT_FRAGMENT__MERGE_OPTIONS, ConflictFragment.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ConflictReportPackage.MERGE_OPTION__START_MESSAGE:
				if (resolve) return getStartMessage();
				return basicGetStartMessage();
			case ConflictReportPackage.MERGE_OPTION__END_MESSAGE:
				if (resolve) return getEndMessage();
				return basicGetEndMessage();
			case ConflictReportPackage.MERGE_OPTION__CONFLICT_FRAGMENT:
				return getConflictFragment();
			case ConflictReportPackage.MERGE_OPTION__LEFT_MESSAGES:
				return getLeftMessages();
			case ConflictReportPackage.MERGE_OPTION__RIGHT_MESSAGES:
				return getRightMessages();
			case ConflictReportPackage.MERGE_OPTION__LEFT_ADDED_MESSAGES:
				return getLeftAddedMessages();
			case ConflictReportPackage.MERGE_OPTION__RIGHT_ADDED_MESSAGES:
				return getRightAddedMessages();
			case ConflictReportPackage.MERGE_OPTION__LEFT_DELETED_MESSAGES:
				return getLeftDeletedMessages();
			case ConflictReportPackage.MERGE_OPTION__RIGHT_DELETED_MESSAGES:
				return getRightDeletedMessages();
			case ConflictReportPackage.MERGE_OPTION__LEFT_UPDATED_MESSAGES:
				return getLeftUpdatedMessages();
			case ConflictReportPackage.MERGE_OPTION__RIGHT_UPDATED_MESSAGES:
				return getRightUpdatedMessages();
			case ConflictReportPackage.MERGE_OPTION__MESSAGES:
				return getMessages();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ConflictReportPackage.MERGE_OPTION__START_MESSAGE:
				setStartMessage((Message)newValue);
				return;
			case ConflictReportPackage.MERGE_OPTION__END_MESSAGE:
				setEndMessage((Message)newValue);
				return;
			case ConflictReportPackage.MERGE_OPTION__CONFLICT_FRAGMENT:
				setConflictFragment((ConflictFragment)newValue);
				return;
			case ConflictReportPackage.MERGE_OPTION__LEFT_MESSAGES:
				getLeftMessages().clear();
				getLeftMessages().addAll((Collection<? extends Message>)newValue);
				return;
			case ConflictReportPackage.MERGE_OPTION__RIGHT_MESSAGES:
				getRightMessages().clear();
				getRightMessages().addAll((Collection<? extends Message>)newValue);
				return;
			case ConflictReportPackage.MERGE_OPTION__LEFT_ADDED_MESSAGES:
				getLeftAddedMessages().clear();
				getLeftAddedMessages().addAll((Collection<? extends Message>)newValue);
				return;
			case ConflictReportPackage.MERGE_OPTION__RIGHT_ADDED_MESSAGES:
				getRightAddedMessages().clear();
				getRightAddedMessages().addAll((Collection<? extends Message>)newValue);
				return;
			case ConflictReportPackage.MERGE_OPTION__LEFT_DELETED_MESSAGES:
				getLeftDeletedMessages().clear();
				getLeftDeletedMessages().addAll((Collection<? extends Message>)newValue);
				return;
			case ConflictReportPackage.MERGE_OPTION__RIGHT_DELETED_MESSAGES:
				getRightDeletedMessages().clear();
				getRightDeletedMessages().addAll((Collection<? extends Message>)newValue);
				return;
			case ConflictReportPackage.MERGE_OPTION__LEFT_UPDATED_MESSAGES:
				getLeftUpdatedMessages().clear();
				getLeftUpdatedMessages().addAll((Collection<? extends Message>)newValue);
				return;
			case ConflictReportPackage.MERGE_OPTION__RIGHT_UPDATED_MESSAGES:
				getRightUpdatedMessages().clear();
				getRightUpdatedMessages().addAll((Collection<? extends Message>)newValue);
				return;
			case ConflictReportPackage.MERGE_OPTION__MESSAGES:
				getMessages().clear();
				getMessages().addAll((Collection<? extends Message>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ConflictReportPackage.MERGE_OPTION__START_MESSAGE:
				setStartMessage((Message)null);
				return;
			case ConflictReportPackage.MERGE_OPTION__END_MESSAGE:
				setEndMessage((Message)null);
				return;
			case ConflictReportPackage.MERGE_OPTION__CONFLICT_FRAGMENT:
				setConflictFragment((ConflictFragment)null);
				return;
			case ConflictReportPackage.MERGE_OPTION__LEFT_MESSAGES:
				getLeftMessages().clear();
				return;
			case ConflictReportPackage.MERGE_OPTION__RIGHT_MESSAGES:
				getRightMessages().clear();
				return;
			case ConflictReportPackage.MERGE_OPTION__LEFT_ADDED_MESSAGES:
				getLeftAddedMessages().clear();
				return;
			case ConflictReportPackage.MERGE_OPTION__RIGHT_ADDED_MESSAGES:
				getRightAddedMessages().clear();
				return;
			case ConflictReportPackage.MERGE_OPTION__LEFT_DELETED_MESSAGES:
				getLeftDeletedMessages().clear();
				return;
			case ConflictReportPackage.MERGE_OPTION__RIGHT_DELETED_MESSAGES:
				getRightDeletedMessages().clear();
				return;
			case ConflictReportPackage.MERGE_OPTION__LEFT_UPDATED_MESSAGES:
				getLeftUpdatedMessages().clear();
				return;
			case ConflictReportPackage.MERGE_OPTION__RIGHT_UPDATED_MESSAGES:
				getRightUpdatedMessages().clear();
				return;
			case ConflictReportPackage.MERGE_OPTION__MESSAGES:
				getMessages().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ConflictReportPackage.MERGE_OPTION__START_MESSAGE:
				return startMessage != null;
			case ConflictReportPackage.MERGE_OPTION__END_MESSAGE:
				return endMessage != null;
			case ConflictReportPackage.MERGE_OPTION__CONFLICT_FRAGMENT:
				return getConflictFragment() != null;
			case ConflictReportPackage.MERGE_OPTION__LEFT_MESSAGES:
				return leftMessages != null && !leftMessages.isEmpty();
			case ConflictReportPackage.MERGE_OPTION__RIGHT_MESSAGES:
				return rightMessages != null && !rightMessages.isEmpty();
			case ConflictReportPackage.MERGE_OPTION__LEFT_ADDED_MESSAGES:
				return leftAddedMessages != null && !leftAddedMessages.isEmpty();
			case ConflictReportPackage.MERGE_OPTION__RIGHT_ADDED_MESSAGES:
				return rightAddedMessages != null && !rightAddedMessages.isEmpty();
			case ConflictReportPackage.MERGE_OPTION__LEFT_DELETED_MESSAGES:
				return leftDeletedMessages != null && !leftDeletedMessages.isEmpty();
			case ConflictReportPackage.MERGE_OPTION__RIGHT_DELETED_MESSAGES:
				return rightDeletedMessages != null && !rightDeletedMessages.isEmpty();
			case ConflictReportPackage.MERGE_OPTION__LEFT_UPDATED_MESSAGES:
				return leftUpdatedMessages != null && !leftUpdatedMessages.isEmpty();
			case ConflictReportPackage.MERGE_OPTION__RIGHT_UPDATED_MESSAGES:
				return rightUpdatedMessages != null && !rightUpdatedMessages.isEmpty();
			case ConflictReportPackage.MERGE_OPTION__MESSAGES:
				return messages != null && !messages.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //MergeOptionImpl
