/**
 * <copyright>
 *
 * Copyright (c) 2011 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.diff.encoding.test;

import java.io.File;
import java.io.IOException;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.modelevolution.multiview.diff.encoding.engine.impl.Sequence2SATEncodingEngine;
import org.modelevolution.multiview.diff.encoding.service.EncodingService;
import org.modelversioning.conflictreport.EquivalentChange;
import org.modelversioning.conflictreport.conflict.Conflict;
import org.modelversioning.conflicts.detection.impl.ThreeWayDiffProvider;
import org.modelversioning.core.diff.service.DiffService;
import org.modelversioning.core.impl.UUIDResourceFactoryImpl;
import org.modelversioning.core.match.service.MatchService;

/**
 * @author lena
 * 
 */
public class EncodingEngineTest {
	
	public static final String FILE_EXTENSION = ".mvml";
	public static final String ORIGIN_FILE = "origin";
	public static final String WCP1_FILE = "working_copy_1";
	public static final String WCP2_FILE = "working_copy_2";

	public static final String path = "models/generated/big/";

	Resource origin = null;
	Resource workingCopy1 = null;
	Resource workingCopy2 = null;

	ComparisonResourceSnapshot leftCRS2 = null;
	ComparisonResourceSnapshot rightCRS2 = null;

	ThreeWayDiffProvider threeWayDiffProvider = null;
	EList<Conflict> conflicts = null;
	EList<EquivalentChange> equivalentChanges = null;

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
		// load id resources
		ResourceSet resourceSet = new ResourceSetImpl();
		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
				.put(FILE_EXTENSION, new UUIDResourceFactoryImpl());

		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
				.put("xmi", new UUIDResourceFactoryImpl());

		URI fileURI_id = URI.createFileURI(new File(path + ORIGIN_FILE + FILE_EXTENSION)
				.getAbsolutePath());

		origin = resourceSet.getResource(fileURI_id, true);
		URI fileURI1_id = URI.createFileURI(new File(path
				+ WCP1_FILE + FILE_EXTENSION).getAbsolutePath());
		workingCopy1 = resourceSet.getResource(fileURI1_id, true);
		URI fileURI2_id = URI.createFileURI(new File(path
				+ WCP2_FILE + FILE_EXTENSION).getAbsolutePath());
		workingCopy2 = resourceSet.getResource(fileURI2_id, true);

		MatchService matchService = new MatchService();
		DiffService diffService = new DiffService();

		leftCRS2 = diffService.generateComparisonResourceSnapshot(matchService
				.generateMatchModel(origin, workingCopy1));
		rightCRS2 = diffService.generateComparisonResourceSnapshot(matchService
				.generateMatchModel(origin, workingCopy2));
		// create ThreeWayDiffProvider instance
		threeWayDiffProvider = new ThreeWayDiffProvider(leftCRS2, rightCRS2);

		conflicts = new BasicEList<Conflict>();
		equivalentChanges = new BasicEList<EquivalentChange>();

//		MultivaluedFeatureUpdateConflictDetector operationConflictDetector = new MultivaluedFeatureUpdateConflictDetector();
//		operationConflictDetector.detectOverlappingChanges(
//				threeWayDiffProvider, conflicts, equivalentChanges,
//				new NullProgressMonitor());
	}

	/**
	 * @throws java.lang.Exception
	 */
	@After
	public void tearDown() throws Exception {
		this.origin.unload();
		this.workingCopy1.unload();
		this.workingCopy2.unload();
	}

	/**
	 * Test method for
	 * {@link org.modelevolution.multiview.diff.encoding.engine.impl.Sequence2SATEncodingEngine#generateEncoding(EList, ThreeWayDiffProvider, File)}
	 * .
	 */
	@Test
	public void testGenerateSATEncoding() {
		EncodingService encodingService = new EncodingService(
				new Sequence2SATEncodingEngine());
		File encodingOutput = new File(path+"encoding.cnf");

		try {
			encodingService.generateEncodedDiffModel(conflicts,
					threeWayDiffProvider, encodingOutput);
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Test method for
	 * {@link org.modelevolution.multiview.diff.encoding.engine.impl.Sequence2PrologEncodingEngine#generateEncoding(EList, ThreeWayDiffProvider, File)}
	 * .
	 */
//	@Test
//	public void testGeneratePrologEncoding() {
//		EncodingService encodingService = new EncodingService(
//				new Sequence2PrologEncodingEngine());
//		File encodingOutput = new File(path + "encoding.pl");
//
//		try {
//			encodingService.generateEncodedDiffModel(conflicts,
//					threeWayDiffProvider, encodingOutput);
//		} catch (IOException e) {
//			e.printStackTrace();
//		}
//	}

}
