/**
 * <copyright>
 *
 * Copyright (c) 2011 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.diff.encoding.engine;

import java.io.File;
import java.io.IOException;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelevolution.multiview.conflictreport.ConflictFragment;
import org.modelevolution.multiview.conflictreport.ConflictReport;
import org.modelversioning.conflictreport.conflict.Conflict;
import org.modelversioning.conflicts.detection.impl.ThreeWayDiffProvider;

/**
 * @author <a href="mailto:brosch@big.tuwien.ac.at">Petra Brosch</a>
 *
 */
public interface IEncodingEngine {
	
	/**
	 * Generates an encoded representation of the differences given in the {@link ThreeWayDiffProvider} and returns a {@link Resource}. 
	 * @param threeWayDiff
	 *  			the basis for generating the encoding.
	 * @param output
	 * 				the {@link File} holding the generated encoding.
	 * @throws IOException
	 */
	public void generateEncoding(ThreeWayDiffProvider threeWayDiff, File output) throws IOException;
	
	/**
	 * Generates an encoded representation of the differences given in the {@link ThreeWayDiffProvider} and returns a {@link Resource}. 
	 * @param conflict
	 * 			    the conflict detected in the model.
	 * @param threeWayDiff
	 *  			the basis for generating the encoding.
	 * @param output
	 * 				the {@link File} holding the generated encoding.
	 * @throws IOException
	 */
	public void generateEncoding(EList<Conflict> conflicts, ThreeWayDiffProvider threeWayDiff, File output) throws IOException;
	
	/**
	 * Generates an encoded representation of the differences given in the {@link ThreeWayDiffProvider}
	 * and adds a {@link ConflictFragment} for each overlapping difference to the given {@link ConflictReport}.
	 * @param threeWayDiffProvider
	 * 			the basis for generating the encoding.
	 * @param conflictReport
	 * 		the {@link ConflictReport} to add detected {@link ConflictFragment}s to
	 * @param output 
	 * 		the {@link File} to store the generated encoding
	 */
	public void generateEncoding(ThreeWayDiffProvider threeWayDiffProvider, ConflictReport conflictReport, File output) throws IOException;
}
