/**
 * <copyright>
 *
 * Copyright (c) 2011 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.diff.encoding.engine;

import java.util.HashMap;

/**
 * @author <a href="mailto:brosch@big.tuwien.ac.at">Petra Brosch</a>
 *
 */
public interface ILogObservable {
	
	/**
	 * Specifies subprocesses of the workflow, for which the execution time
	 * needs to be observed. 
	 * 
	 * @author <a href="mailto:brosch@big.tuwien.ac.at">Petra Brosch</a>
	 */
	public enum LogObservation {
		DIFF_EMF,
		DIFF_POST,
		ENC,
		SAT,
		DEC,
		MERGE,
		VERIFY,
		MSG_COUNT,
		ADD_MSG_COUNT,
		STATE_COUNT,
		TRANSITION_COUNT,
		CNF_VAR_COUNT,
		CNF_CLAUSE_COUNT,
		VALID;
	}
	
	public HashMap<LogObservation, Long> logObservations = new HashMap<LogObservation, Long>();
		
	public Long getLogObservation(LogObservation observation);
}
