/**
 * <copyright>
 *
 * Copyright (c) 2011 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.diff.encoding.service;

import java.io.File;
import java.io.IOException;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.modelevolution.multiview.conflictreport.ConflictFragment;
import org.modelevolution.multiview.conflictreport.ConflictReport;
import org.modelevolution.multiview.diff.encoding.engine.IEncodingEngine;
import org.modelevolution.multiview.diff.encoding.engine.impl.DefaultEncodingEngine;
import org.modelevolution.multiview.merge.MergeAdvice;
import org.modelversioning.conflictreport.conflict.Conflict;
import org.modelversioning.conflicts.detection.impl.ThreeWayDiffProvider;

/**
 * @author <a href="mailto:brosch@big.tuwien.ac.at">Petra Brosch</a>
 *
 */
public class EncodingService {

	/**
	 * An instance of the {@link IEncodingEngine} to use.
	 */
	private IEncodingEngine encodingEngine;
	
	/**
	 * Constructor setting the {@link IEncodingEngine} to use.
	 * 
	 * @param encodingEngine
	 *            the {@link IEncodingEngine} to use.
	 */
	public EncodingService(IEncodingEngine encodingEngine) {
		this.encodingEngine = encodingEngine;
	}
	
	/**
	 * Empty default constructor.
	 */
	public EncodingService() {
		encodingEngine = new DefaultEncodingEngine();
	}
	
	/**
	 * Generates an encoded representation of the differences given in the {@link ThreeWayDiffProvider}.
	 * @param conflict
	 * 			the conflict detected in the model.
	 * @param threeWayDiffProvider
	 * 			the basis for generating the encoding.
	 * @param the {@link File} to store the generated encoding
	 */
	@Deprecated
	public void generateEncodedDiffModel(EList<Conflict> conflicts, ThreeWayDiffProvider threeWayDiffProvider, File output) throws IOException {
		encodingEngine.generateEncoding(conflicts, threeWayDiffProvider, output);
	}
	
	/**
	 * Generates an encoded representation of the differences given in the {@link ThreeWayDiffProvider}.
	 * @param threeWayDiffProvider
	 * 			the basis for generating the encoding.
	 * @param the {@link File} to store the generated encoding
	 */
	public void generateEncodedDiffModel(ThreeWayDiffProvider threeWayDiffProvider, File output) throws IOException {
		encodingEngine.generateEncoding(threeWayDiffProvider, output);
	}
	
	/**
	 * Generates an encoded representation of the differences given in the {@link ThreeWayDiffProvider}
	 * and adds a {@link ConflictFragment} for each overlapping difference to the given {@link ConflictReport}.
	 * @param threeWayDiffProvider
	 * 			the basis for generating the encoding.
	 * @param conflictReport
	 * 		the {@link ConflictReport} to add detected {@link ConflictFragment}s to
	 * @param output 
	 * 		the {@link File} to store the generated encoding
	 */
	public void generateEncodedDiffModel(ThreeWayDiffProvider threeWayDiffProvider, ConflictReport conflictReport, File output) throws IOException {
		encodingEngine.generateEncoding(threeWayDiffProvider, conflictReport, output);
	}
	
	/**
	 * Returns the {@link IEncodingEngine} in use.
	 * 
	 * @return the encodingEngine in use.
	 */
	public IEncodingEngine getEncodingEngine() {
		return encodingEngine;
	}
	
	/**
	 * Sets the {@link IEncodingEngine} to use.
	 * 
	 * @param encodingEngine
	 *            the encodingEngine to use.
	 */
	public void setEncodingEngine(IEncodingEngine encodingEngine) {
		this.encodingEngine = encodingEngine;
	}
}
