/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.modelevolution.multiview.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.modelevolution.multiview.util.MultiviewAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class MultiviewItemProviderAdapterFactory extends MultiviewAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MultiviewItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.NamedElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NamedElementItemProvider namedElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.NamedElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNamedElementAdapter() {
		if (namedElementItemProvider == null) {
			namedElementItemProvider = new NamedElementItemProvider(this);
		}

		return namedElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.Region} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RegionItemProvider regionItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.Region}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRegionAdapter() {
		if (regionItemProvider == null) {
			regionItemProvider = new RegionItemProvider(this);
		}

		return regionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.State} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StateItemProvider stateItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.State}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStateAdapter() {
		if (stateItemProvider == null) {
			stateItemProvider = new StateItemProvider(this);
		}

		return stateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.Symbol} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SymbolItemProvider symbolItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.Symbol}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSymbolAdapter() {
		if (symbolItemProvider == null) {
			symbolItemProvider = new SymbolItemProvider(this);
		}

		return symbolItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.Transition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TransitionItemProvider transitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.Transition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTransitionAdapter() {
		if (transitionItemProvider == null) {
			transitionItemProvider = new TransitionItemProvider(this);
		}

		return transitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.MultiviewModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultiviewModelItemProvider multiviewModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.MultiviewModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMultiviewModelAdapter() {
		if (multiviewModelItemProvider == null) {
			multiviewModelItemProvider = new MultiviewModelItemProvider(this);
		}

		return multiviewModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.Class} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClassItemProvider classItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.Class}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClassAdapter() {
		if (classItemProvider == null) {
			classItemProvider = new ClassItemProvider(this);
		}

		return classItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.Operation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OperationItemProvider operationItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.Operation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOperationAdapter() {
		if (operationItemProvider == null) {
			operationItemProvider = new OperationItemProvider(this);
		}

		return operationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.ClassView} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ClassViewItemProvider classViewItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.ClassView}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createClassViewAdapter() {
		if (classViewItemProvider == null) {
			classViewItemProvider = new ClassViewItemProvider(this);
		}

		return classViewItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.StateView} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StateViewItemProvider stateViewItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.StateView}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStateViewAdapter() {
		if (stateViewItemProvider == null) {
			stateViewItemProvider = new StateViewItemProvider(this);
		}

		return stateViewItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.SequenceView} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SequenceViewItemProvider sequenceViewItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.SequenceView}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSequenceViewAdapter() {
		if (sequenceViewItemProvider == null) {
			sequenceViewItemProvider = new SequenceViewItemProvider(this);
		}

		return sequenceViewItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.Guard} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GuardItemProvider guardItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.Guard}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createGuardAdapter() {
		if (guardItemProvider == null) {
			guardItemProvider = new GuardItemProvider(this);
		}

		return guardItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.Lifeline} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LifelineItemProvider lifelineItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.Lifeline}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createLifelineAdapter() {
		if (lifelineItemProvider == null) {
			lifelineItemProvider = new LifelineItemProvider(this);
		}

		return lifelineItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.SendEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SendEventItemProvider sendEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.SendEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSendEventAdapter() {
		if (sendEventItemProvider == null) {
			sendEventItemProvider = new SendEventItemProvider(this);
		}

		return sendEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.ReceiveEvent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReceiveEventItemProvider receiveEventItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.ReceiveEvent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReceiveEventAdapter() {
		if (receiveEventItemProvider == null) {
			receiveEventItemProvider = new ReceiveEventItemProvider(this);
		}

		return receiveEventItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.Message} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MessageItemProvider messageItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.Message}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMessageAdapter() {
		if (messageItemProvider == null) {
			messageItemProvider = new MessageItemProvider(this);
		}

		return messageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.OneOperandCF} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OneOperandCFItemProvider oneOperandCFItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.OneOperandCF}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOneOperandCFAdapter() {
		if (oneOperandCFItemProvider == null) {
			oneOperandCFItemProvider = new OneOperandCFItemProvider(this);
		}

		return oneOperandCFItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.MultipleOperandCF} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultipleOperandCFItemProvider multipleOperandCFItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.MultipleOperandCF}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMultipleOperandCFAdapter() {
		if (multipleOperandCFItemProvider == null) {
			multipleOperandCFItemProvider = new MultipleOperandCFItemProvider(this);
		}

		return multipleOperandCFItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.Operand} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OperandItemProvider operandItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.Operand}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOperandAdapter() {
		if (operandItemProvider == null) {
			operandItemProvider = new OperandItemProvider(this);
		}

		return operandItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.modelevolution.multiview.StateCondition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StateConditionItemProvider stateConditionItemProvider;

	/**
	 * This creates an adapter for a {@link org.modelevolution.multiview.StateCondition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStateConditionAdapter() {
		if (stateConditionItemProvider == null) {
			stateConditionItemProvider = new StateConditionItemProvider(this);
		}

		return stateConditionItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (namedElementItemProvider != null) namedElementItemProvider.dispose();
		if (regionItemProvider != null) regionItemProvider.dispose();
		if (stateItemProvider != null) stateItemProvider.dispose();
		if (symbolItemProvider != null) symbolItemProvider.dispose();
		if (transitionItemProvider != null) transitionItemProvider.dispose();
		if (multiviewModelItemProvider != null) multiviewModelItemProvider.dispose();
		if (classItemProvider != null) classItemProvider.dispose();
		if (operationItemProvider != null) operationItemProvider.dispose();
		if (classViewItemProvider != null) classViewItemProvider.dispose();
		if (stateViewItemProvider != null) stateViewItemProvider.dispose();
		if (sequenceViewItemProvider != null) sequenceViewItemProvider.dispose();
		if (guardItemProvider != null) guardItemProvider.dispose();
		if (lifelineItemProvider != null) lifelineItemProvider.dispose();
		if (sendEventItemProvider != null) sendEventItemProvider.dispose();
		if (receiveEventItemProvider != null) receiveEventItemProvider.dispose();
		if (messageItemProvider != null) messageItemProvider.dispose();
		if (oneOperandCFItemProvider != null) oneOperandCFItemProvider.dispose();
		if (multipleOperandCFItemProvider != null) multipleOperandCFItemProvider.dispose();
		if (operandItemProvider != null) operandItemProvider.dispose();
		if (stateConditionItemProvider != null) stateConditionItemProvider.dispose();
	}

}
