/**
 * <copyright>
 *
 * Copyright (c) 2011 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.merge;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.SortedMap;
import java.util.TreeMap;

import org.eclipse.emf.common.util.BasicEList.UnmodifiableEList;

/**
 * @author <a href="mailto:brosch@big.tuwien.ac.at">Petra Brosch</a>
 *
 */
public class MergeAdvice {
	// FIXME this should be more flexible!
	public static final String POS_REGEX = "\\d+-[LOR]-\\d+.*";

	private SortedMap<Integer, MergePosition> mergePositions = new TreeMap<Integer, MergePosition>();

	
	public MergeAdvice() {	}
	
	public MergeAdvice(File mergeAdvice) throws IOException {
		FileReader fr = new FileReader(mergeAdvice);
		BufferedReader br = new BufferedReader(fr);

		String line;
		while ((line = br.readLine()) != null) {
			if (line.matches(POS_REGEX)) {
				String[] words = line.substring(2).split("-");
				mergePositions.put(Integer.parseInt(words[0].trim()),
						new MergePosition(Integer.parseInt(words[2].trim()),
								MergeType.valueOf(words[1].trim())));
			}
		}
		fr.close();
	}

	public void addPosition(int position, MergePosition mergePosition){
		mergePositions.put(position, mergePosition);
	}
	
	public void addPosition(int newPosition, MergeType type, int prevPosition){
		mergePositions.put(newPosition, new MergePosition(prevPosition,type));
	}
	
	public void addPosition(String variable){
		if (variable.matches(POS_REGEX)) {
			String[] words = variable.split("_")[0].split("-");
			
			int newPosition = Integer.parseInt(words[0].trim());
			int oldPosition = Integer.parseInt(words[2].trim());
			MergeType type = MergeType.valueOf(words[1].trim());
									
			mergePositions.put(newPosition,
					new MergePosition(oldPosition,type));
	
		}
	}
	
	public UnmodifiableEList<MergePosition> getMergePositions() {
		return new UnmodifiableEList<MergePosition>(mergePositions.size(), mergePositions.values().toArray());
	}
}
