/**
 * <copyright>
 *
 * Copyright (c) 2011 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.merge;

import java.util.Comparator;

import org.eclipse.emf.compare.match.metamodel.Side;
import org.modelevolution.multiview.Message;

/**
 * The position where a set of {@link Message} <code>messages</code> added
 * in the respective {@link Side} shall be inserted.
 * 
 * @author <a href="mailto:brosch@big.tuwien.ac.at">Petra Brosch</a>
 * 
 */
public class MergePosition implements Comparable<MergePosition>,
		Comparator<MergePosition> {
	int index;
	MergeType type;

	public MergePosition(int index, MergeType type) {
		this.index = index;
		this.type = type;
	}

	public MergeType getType() {
		return type;
	}
	
	public int getIndex() {
		return index;
	}

	@Override
	public int compare(MergePosition o1, MergePosition o2) {
		if (o1.index == o2.index) {
			if (o1.type.equals(o2.type)) {
				return 0;
			} else {
				return (o1.type.ordinal() > o2.type.ordinal()) ? 1 : -1;
			}
		} else if (o1.index > o2.index) {
			return 1;
		} else {
			return -1;
		}
	}

	@Override
	public int compareTo(MergePosition o) {
		return compare(this, o);
	}
	
	@Override
	public String toString() {
		return type.toString() + " " + index;
	}
}
