/**
 * <copyright>
 *
 * Copyright (c) 2011 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.merge.engine;

import org.eclipse.emf.ecore.resource.Resource;
import org.modelevolution.multiview.merge.MergeAdvice;
import org.modelversioning.conflicts.detection.impl.ThreeWayDiffProvider;

/**
 * @author <a href="mailto:brosch@big.tuwien.ac.at">Petra Brosch</a>
 *
 */
public interface IMergeEngine {
	
	/**
	 * Generates a merged model based on the differences given in the {@link ThreeWayDiffProvider} and {@link MergeAdvice}.
	 * @param threeWayDiff
	 * 				the basis for generating the merge.
	 * @param mergeAdvice
	 * 				the {@link MergeAdvice} to use for generating the merged version.
	 * @param mergedModelResource
	 * 				the {@link Resource} holding the merged model.
	 */
	public void merge(ThreeWayDiffProvider threeWayDiff, MergeAdvice mergeAdvice, Resource mergedModelResource);
	
	/**
	 * Generates a merged model based on the differences given in the {@link ThreeWayDiffProvider} and <code>mergeAdvice</code>.
	 * @param threeWayDiff
	 * 				the basis for generating the merge.
	 * @param mergeAdvice
	 * 				the {@link MergeAdvice} to use for generating the merged version.
	 * @param mergedModelResource
	 * 				the {@link Resource} holding the merged model.
	 * @param conflictModelResource
	 * 				the {@line Resource} holding the conflict model, where the merged model should be added to.
	 */
	public void merge(ThreeWayDiffProvider threeWayDiff, MergeAdvice mergeAdvice, Resource mergedModelResource, Resource conflictModelResource);
}
