/**
 * <copyright>
 *
 * Copyright (c) 2011 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.merge.service;

import java.io.IOException;

import org.eclipse.emf.ecore.resource.Resource;
import org.modelevolution.multiview.merge.MergeAdvice;
import org.modelevolution.multiview.merge.engine.IMergeEngine;
import org.modelevolution.multiview.merge.engine.impl.DefaultMergeEngine;
import org.modelversioning.conflicts.detection.impl.ThreeWayDiffProvider;

/**
 * @author <a href="mailto:brosch@big.tuwien.ac.at">Petra Brosch</a>
 *
 */
public class MergeService {
	
	/**
	 * An instance of the {@link IMergeEngine} to use.
	 */
	private IMergeEngine mergeEngine;

	/**
	 * Constructor setting the {@link IMergeEngine} to use.
	 * 
	 * @param mergeEngine
	 *            the {@link IMergeEngine} to use.
	 */
	public MergeService(IMergeEngine mergeEngine) {
		this.mergeEngine = mergeEngine;
	}
	
	/**
	 * Empty default constructor.
	 */
	public MergeService() {
		mergeEngine = new DefaultMergeEngine();
	}
	
	/**
	 * Generates a merged model based on the differences given in the {@link ThreeWayDiffProvider} and <code>mergeAdvice</code>.
	 * @param threeWayDiff
	 * 				the basis for generating the merge.
	 * @param mergeAdvice
	 * 				the {@link MergeAdvice} to use for generating the merged version.
	 * @param mergedModelResource
	 * 				the {@link Resource} holding the merged model.
	 */
	public void generateMergedModel(ThreeWayDiffProvider threeWayDiff, MergeAdvice mergeAdvice, Resource mergedModelResource) throws IOException {
		mergeEngine.merge(threeWayDiff, mergeAdvice, mergedModelResource);
	}
	
	/**
	 * Generates a merged model based on the differences given in the {@link ThreeWayDiffProvider} and <code>mergeAdvice</code>.
	 * @param threeWayDiff
	 * 				the basis for generating the merge.
	 * @param mergeAdvice
	 * 				the {@link MergeAdvice} to use for generating the merged version.
	 * @param mergedModelResource
	 * 				the {@link Resource} holding the merged model.
	 * @param conflictModelResource
	 * 				the {@line Resource} holding the conflict model, where the merged model should be added to.
	 */
	public void generateMergedModel(ThreeWayDiffProvider threeWayDiff, MergeAdvice mergeAdvice, Resource mergedModelResource, Resource conflictModelResource) throws IOException {
		mergeEngine.merge(threeWayDiff, mergeAdvice, mergedModelResource, conflictModelResource);
	}
}
