package org.modelevolution.multiview.util.command.handler;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.internal.filesystem.local.LocalFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.ui.ISources;
import org.eclipse.ui.handlers.HandlerUtil;
import org.modelevolution.multiview.util.Activator;
import org.modelversioning.core.impl.UUIDResourceFactoryImpl;
import org.modelversioning.core.util.UUIDUtil;

@SuppressWarnings("restriction")
public class CopyCommandHandler extends AbstractHandler {

	private boolean enabled = false;

	private ISelection selection;
	protected ITreeSelection treeSelection;
	private ResourceSet resourceSet = new ResourceSetImpl();
	private IFile selectedFile;

	public static final String WORKING_COPY_1 = "working_copy_1";
	public static final String WORKING_COPY_2 = "working_copy_2";

	@Override
	public boolean isEnabled() {
		return enabled;
	}

	@Override
	public void setEnabled(Object evaluationContext) {
		enabled = false;

		if (evaluationContext != null
				&& evaluationContext instanceof IEvaluationContext) {
			IEvaluationContext context = (IEvaluationContext) evaluationContext;

			Object currentSelection = context
					.getVariable(ISources.ACTIVE_CURRENT_SELECTION_NAME);

			if (currentSelection != null
					&& currentSelection instanceof ISelection) {
				selection = (ISelection) currentSelection;

				if (selection instanceof ITreeSelection) {
					treeSelection = (ITreeSelection) selection;

					if (treeSelection.size() > 0) {
						selectedFile = (IFile) Platform.getAdapterManager()
								.getAdapter(treeSelection.getFirstElement(),
										IFile.class);

						enabled = true;
					}
				}
			}
		}
	}

	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		Assert.isTrue(selection.equals(HandlerUtil.getCurrentSelection(event)),
				"the selection is not equal.");

		initResourceSet();

		try {
			process(selectedFile);
		} catch (InvocationTargetException e) {
			e.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		return null;
	}

	/**
	 * Performs the execution of the copy command.
	 * 
	 * @param originFile
	 * @throws InvocationTargetException
	 * @throws InterruptedException
	 */
	private void process(final IFile originFile)
			throws InvocationTargetException, InterruptedException {
		Activator.getDefault().getWorkbench().getProgressService()
				.run(false, false, new IRunnableWithProgress() {
					@Override
					public void run(IProgressMonitor progressMonitor)
							throws InvocationTargetException,
							InterruptedException {

						SubMonitor monitor = SubMonitor
								.convert(progressMonitor);

						monitor.beginTask("Create working copies", 3);

						try {
							// Add UUIDs to origin model
							monitor.subTask("Add UUIDs");
							Resource origin = resourceSet.getResource(
									URI.createURI(originFile.getLocationURI().toString()), true);
							if (origin.getContents() != null
									&& !origin.getContents().isEmpty()) {
								UUIDUtil.addUUIDs(origin.getContents().get(0));
							}
							origin.save(Collections.EMPTY_MAP);
							originFile.refreshLocal(0, monitor);
							monitor.worked(1);

							// Create working copy 1
							new LocalFile(originFile.getLocation().toFile())
									.copy(new LocalFile(new File(originFile
											.getLocation()
											.removeFileExtension()
											.removeLastSegments(1).toOSString()
											+ File.separator
											+ WORKING_COPY_1
											+ "."
											+ originFile.getFileExtension())),
											EFS.NONE, monitor);
							monitor.worked(1);

							// Create working copy 2
							new LocalFile(originFile.getLocation().toFile())
							.copy(new LocalFile(new File(originFile
									.getLocation()
									.removeFileExtension()
									.removeLastSegments(1).toOSString()
									+ File.separator
									+ WORKING_COPY_2
									+ "."
									+ originFile.getFileExtension())),
									EFS.NONE, monitor);
							monitor.worked(1);
						} catch (IOException e) {
							e.printStackTrace();
						} catch (CoreException e) {
							e.printStackTrace();
						} finally {
							monitor.done();
						}
					}
				});
	}

	/**
	 * Initializes a {@link ResourceSet}.
	 */
	private void initResourceSet() {
		// load resources
		resourceSet = new ResourceSetImpl();
		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
				.put("mvml", new UUIDResourceFactoryImpl());
		resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap()
				.put("xmi", new UUIDResourceFactoryImpl());

		resourceSet
				.getResourceFactoryRegistry()
				.getExtensionToFactoryMap()
				.put(Resource.Factory.Registry.DEFAULT_EXTENSION,
						new UUIDResourceFactoryImpl());
	}

}
