/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Class</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.modelevolution.multiview.Class#getOperations <em>Operations</em>}</li>
 *   <li>{@link org.modelevolution.multiview.Class#getStatemachine <em>Statemachine</em>}</li>
 *   <li>{@link org.modelevolution.multiview.Class#getLifelines <em>Lifelines</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.modelevolution.multiview.MultiviewPackage#getClass_()
 * @model
 * @generated
 */
public interface Class extends NamedElement {
	/**
	 * Returns the value of the '<em><b>Operations</b></em>' containment reference list.
	 * The list contents are of type {@link org.modelevolution.multiview.Operation}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operations</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Operations</em>' containment reference list.
	 * @see org.modelevolution.multiview.MultiviewPackage#getClass_Operations()
	 * @model containment="true"
	 * @generated
	 */
	EList<Operation> getOperations();

	/**
	 * Returns the value of the '<em><b>Statemachine</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.Region#getClass_ <em>Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Statemachine</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Statemachine</em>' reference.
	 * @see #setStatemachine(Region)
	 * @see org.modelevolution.multiview.MultiviewPackage#getClass_Statemachine()
	 * @see org.modelevolution.multiview.Region#getClass_
	 * @model opposite="class"
	 * @generated
	 */
	Region getStatemachine();

	/**
	 * Sets the value of the '{@link org.modelevolution.multiview.Class#getStatemachine <em>Statemachine</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Statemachine</em>' reference.
	 * @see #getStatemachine()
	 * @generated
	 */
	void setStatemachine(Region value);

	/**
	 * Returns the value of the '<em><b>Lifelines</b></em>' reference list.
	 * The list contents are of type {@link org.modelevolution.multiview.Lifeline}.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.Lifeline#getClass_ <em>Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Lifelines</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Lifelines</em>' reference list.
	 * @see org.modelevolution.multiview.MultiviewPackage#getClass_Lifelines()
	 * @see org.modelevolution.multiview.Lifeline#getClass_
	 * @model opposite="class" ordered="false"
	 * @generated
	 */
	EList<Lifeline> getLifelines();

} // Class
