/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Lifeline</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.modelevolution.multiview.Lifeline#getElements <em>Elements</em>}</li>
 *   <li>{@link org.modelevolution.multiview.Lifeline#getClass_ <em>Class</em>}</li>
 *   <li>{@link org.modelevolution.multiview.Lifeline#getSequenceView <em>Sequence View</em>}</li>
 *   <li>{@link org.modelevolution.multiview.Lifeline#getDefault_statemachine_name <em>Default statemachine name</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.modelevolution.multiview.MultiviewPackage#getLifeline()
 * @model
 * @generated
 */
public interface Lifeline extends NamedElement {
	/**
	 * Returns the value of the '<em><b>Elements</b></em>' containment reference list.
	 * The list contents are of type {@link org.modelevolution.multiview.LifelineElement}.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.LifelineElement#getLifeline <em>Lifeline</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Elements</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Elements</em>' containment reference list.
	 * @see org.modelevolution.multiview.MultiviewPackage#getLifeline_Elements()
	 * @see org.modelevolution.multiview.LifelineElement#getLifeline
	 * @model opposite="lifeline" containment="true"
	 * @generated
	 */
	EList<LifelineElement> getElements();

	/**
	 * Returns the value of the '<em><b>Class</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.Class#getLifelines <em>Lifelines</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Class</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Class</em>' reference.
	 * @see #setClass(org.modelevolution.multiview.Class)
	 * @see org.modelevolution.multiview.MultiviewPackage#getLifeline_Class()
	 * @see org.modelevolution.multiview.Class#getLifelines
	 * @model opposite="lifelines"
	 * @generated
	 */
	org.modelevolution.multiview.Class getClass_();

	/**
	 * Sets the value of the '{@link org.modelevolution.multiview.Lifeline#getClass_ <em>Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Class</em>' reference.
	 * @see #getClass_()
	 * @generated
	 */
	void setClass(org.modelevolution.multiview.Class value);

	/**
	 * Returns the value of the '<em><b>Sequence View</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.SequenceView#getLifelines <em>Lifelines</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sequence View</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Sequence View</em>' container reference.
	 * @see #setSequenceView(SequenceView)
	 * @see org.modelevolution.multiview.MultiviewPackage#getLifeline_SequenceView()
	 * @see org.modelevolution.multiview.SequenceView#getLifelines
	 * @model opposite="lifelines" required="true" transient="false"
	 * @generated
	 */
	SequenceView getSequenceView();

	/**
	 * Sets the value of the '{@link org.modelevolution.multiview.Lifeline#getSequenceView <em>Sequence View</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Sequence View</em>' container reference.
	 * @see #getSequenceView()
	 * @generated
	 */
	void setSequenceView(SequenceView value);

	/**
	 * Returns the value of the '<em><b>Default statemachine name</b></em>' attribute.
	 * The default value is <code>"DEFAULT"</code>.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Default statemachine name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Default statemachine name</em>' attribute.
	 * @see #setDefault_statemachine_name(String)
	 * @see org.modelevolution.multiview.MultiviewPackage#getLifeline_Default_statemachine_name()
	 * @model default="DEFAULT"
	 * @generated
	 */
	String getDefault_statemachine_name();

	/**
	 * Sets the value of the '{@link org.modelevolution.multiview.Lifeline#getDefault_statemachine_name <em>Default statemachine name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Default statemachine name</em>' attribute.
	 * @see #getDefault_statemachine_name()
	 * @generated
	 */
	void setDefault_statemachine_name(String value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	void initDummyStatemachine();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	void unsetDummyStatemachine();

} // Lifeline
