/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Message</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.modelevolution.multiview.Message#getSender <em>Sender</em>}</li>
 *   <li>{@link org.modelevolution.multiview.Message#getReceiver <em>Receiver</em>}</li>
 *   <li>{@link org.modelevolution.multiview.Message#getBody <em>Body</em>}</li>
 *   <li>{@link org.modelevolution.multiview.Message#getSequenceView <em>Sequence View</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.modelevolution.multiview.MultiviewPackage#getMessage()
 * @model
 * @generated
 */
public interface Message extends EObject {
	/**
	 * Returns the value of the '<em><b>Sender</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.SendEvent#getMessage <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sender</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Sender</em>' reference.
	 * @see #setSender(SendEvent)
	 * @see org.modelevolution.multiview.MultiviewPackage#getMessage_Sender()
	 * @see org.modelevolution.multiview.SendEvent#getMessage
	 * @model opposite="message"
	 * @generated
	 */
	SendEvent getSender();

	/**
	 * Sets the value of the '{@link org.modelevolution.multiview.Message#getSender <em>Sender</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Sender</em>' reference.
	 * @see #getSender()
	 * @generated
	 */
	void setSender(SendEvent value);

	/**
	 * Returns the value of the '<em><b>Receiver</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.ReceiveEvent#getMessage <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Receiver</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Receiver</em>' reference.
	 * @see #setReceiver(ReceiveEvent)
	 * @see org.modelevolution.multiview.MultiviewPackage#getMessage_Receiver()
	 * @see org.modelevolution.multiview.ReceiveEvent#getMessage
	 * @model opposite="message"
	 * @generated
	 */
	ReceiveEvent getReceiver();

	/**
	 * Sets the value of the '{@link org.modelevolution.multiview.Message#getReceiver <em>Receiver</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Receiver</em>' reference.
	 * @see #getReceiver()
	 * @generated
	 */
	void setReceiver(ReceiveEvent value);

	/**
	 * Returns the value of the '<em><b>Body</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Body</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Body</em>' reference.
	 * @see #setBody(Symbol)
	 * @see org.modelevolution.multiview.MultiviewPackage#getMessage_Body()
	 * @model ordered="false"
	 * @generated
	 */
	Symbol getBody();

	/**
	 * Sets the value of the '{@link org.modelevolution.multiview.Message#getBody <em>Body</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Body</em>' reference.
	 * @see #getBody()
	 * @generated
	 */
	void setBody(Symbol value);

	/**
	 * Returns the value of the '<em><b>Sequence View</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.SequenceView#getMessages <em>Messages</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Sequence View</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Sequence View</em>' container reference.
	 * @see #setSequenceView(SequenceView)
	 * @see org.modelevolution.multiview.MultiviewPackage#getMessage_SequenceView()
	 * @see org.modelevolution.multiview.SequenceView#getMessages
	 * @model opposite="messages" required="true" transient="false"
	 * @generated
	 */
	SequenceView getSequenceView();

	/**
	 * Sets the value of the '{@link org.modelevolution.multiview.Message#getSequenceView <em>Sequence View</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Sequence View</em>' container reference.
	 * @see #getSequenceView()
	 * @generated
	 */
	void setSequenceView(SequenceView value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation"
	 * @generated
	 */
	Message getPrevious();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation"
	 * @generated
	 */
	Message getNext();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation"
	 * @generated
	 */
	int getPosition();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	String toString();

} // Message
