/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.modelevolution.multiview.MultiviewFactory
 * @model kind="package"
 * @generated
 */
public interface MultiviewPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "multiview";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://modelevolution.org/multiview/1.0";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "mv";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	MultiviewPackage eINSTANCE = org.modelevolution.multiview.impl.MultiviewPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.NamedElementImpl <em>Named Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.NamedElementImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getNamedElement()
	 * @generated
	 */
	int NAMED_ELEMENT = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_ELEMENT__NAME = 0;

	/**
	 * The number of structural features of the '<em>Named Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NAMED_ELEMENT_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.RegionImpl <em>Region</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.RegionImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getRegion()
	 * @generated
	 */
	int REGION = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REGION__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>States</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REGION__STATES = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Initial Transition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REGION__INITIAL_TRANSITION = NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REGION__CLASS = NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Region</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REGION_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.StateImpl <em>State</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.StateImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getState()
	 * @generated
	 */
	int STATE = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Outgoing</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE__OUTGOING = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Subregion</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE__SUBREGION = NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Incoming</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE__INCOMING = NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>State</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.SymbolImpl <em>Symbol</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.SymbolImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getSymbol()
	 * @generated
	 */
	int SYMBOL = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYMBOL__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Triggers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYMBOL__TRIGGERS = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Triggered By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYMBOL__IS_TRIGGERED_BY = NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Symbol</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SYMBOL_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.TransitionImpl <em>Transition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.TransitionImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getTransition()
	 * @generated
	 */
	int TRANSITION = 4;

	/**
	 * The feature id for the '<em><b>Executes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION__EXECUTES = 0;

	/**
	 * The feature id for the '<em><b>Guard</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION__GUARD = 1;

	/**
	 * The feature id for the '<em><b>Effects</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION__EFFECTS = 2;

	/**
	 * The feature id for the '<em><b>Trigger</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION__TRIGGER = 3;

	/**
	 * The feature id for the '<em><b>Source</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION__SOURCE = 4;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION__TARGET = 5;

	/**
	 * The number of structural features of the '<em>Transition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRANSITION_FEATURE_COUNT = 6;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.MultiviewModelImpl <em>Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.MultiviewModelImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getMultiviewModel()
	 * @generated
	 */
	int MULTIVIEW_MODEL = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIVIEW_MODEL__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Classview</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIVIEW_MODEL__CLASSVIEW = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Stateview</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIVIEW_MODEL__STATEVIEW = NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Sequenceview</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIVIEW_MODEL__SEQUENCEVIEW = NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIVIEW_MODEL_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.ClassImpl <em>Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.ClassImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getClass_()
	 * @generated
	 */
	int CLASS = 6;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Operations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS__OPERATIONS = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Statemachine</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS__STATEMACHINE = NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Lifelines</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS__LIFELINES = NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.OperationImpl <em>Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.OperationImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getOperation()
	 * @generated
	 */
	int OPERATION = 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The number of structural features of the '<em>Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.ClassViewImpl <em>Class View</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.ClassViewImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getClassView()
	 * @generated
	 */
	int CLASS_VIEW = 8;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_VIEW__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_VIEW__CLASSES = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Class View</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CLASS_VIEW_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.StateViewImpl <em>State View</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.StateViewImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getStateView()
	 * @generated
	 */
	int STATE_VIEW = 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_VIEW__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Statemachines</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_VIEW__STATEMACHINES = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Alphabet</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_VIEW__ALPHABET = NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>State View</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_VIEW_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.SequenceViewImpl <em>Sequence View</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.SequenceViewImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getSequenceView()
	 * @generated
	 */
	int SEQUENCE_VIEW = 10;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_VIEW__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Lifelines</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_VIEW__LIFELINES = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Fragments</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_VIEW__FRAGMENTS = NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Messages</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_VIEW__MESSAGES = NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Sequence View</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEQUENCE_VIEW_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.GuardImpl <em>Guard</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.GuardImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getGuard()
	 * @generated
	 */
	int GUARD = 11;

	/**
	 * The feature id for the '<em><b>Ocl Expression</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GUARD__OCL_EXPRESSION = 0;

	/**
	 * The number of structural features of the '<em>Guard</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GUARD_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.LifelineImpl <em>Lifeline</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.LifelineImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getLifeline()
	 * @generated
	 */
	int LIFELINE = 12;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIFELINE__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIFELINE__ELEMENTS = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Class</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIFELINE__CLASS = NAMED_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Sequence View</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIFELINE__SEQUENCE_VIEW = NAMED_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Default statemachine name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIFELINE__DEFAULT_STATEMACHINE_NAME = NAMED_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Lifeline</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIFELINE_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.LifelineElementImpl <em>Lifeline Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.LifelineElementImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getLifelineElement()
	 * @generated
	 */
	int LIFELINE_ELEMENT = 13;

	/**
	 * The feature id for the '<em><b>Lifeline</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIFELINE_ELEMENT__LIFELINE = 0;

	/**
	 * The number of structural features of the '<em>Lifeline Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LIFELINE_ELEMENT_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.EventImpl <em>Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.EventImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getEvent()
	 * @generated
	 */
	int EVENT = 14;

	/**
	 * The feature id for the '<em><b>Lifeline</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__LIFELINE = LIFELINE_ELEMENT__LIFELINE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__NAME = LIFELINE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT__TIME = LIFELINE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EVENT_FEATURE_COUNT = LIFELINE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.ConditionImpl <em>Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.ConditionImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getCondition()
	 * @generated
	 */
	int CONDITION = 15;

	/**
	 * The feature id for the '<em><b>Lifeline</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITION__LIFELINE = LIFELINE_ELEMENT__LIFELINE;

	/**
	 * The number of structural features of the '<em>Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CONDITION_FEATURE_COUNT = LIFELINE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.SendEventImpl <em>Send Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.SendEventImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getSendEvent()
	 * @generated
	 */
	int SEND_EVENT = 16;

	/**
	 * The feature id for the '<em><b>Lifeline</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_EVENT__LIFELINE = EVENT__LIFELINE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_EVENT__NAME = EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_EVENT__TIME = EVENT__TIME;

	/**
	 * The feature id for the '<em><b>Message</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_EVENT__MESSAGE = EVENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Send Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEND_EVENT_FEATURE_COUNT = EVENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.ReceiveEventImpl <em>Receive Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.ReceiveEventImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getReceiveEvent()
	 * @generated
	 */
	int RECEIVE_EVENT = 17;

	/**
	 * The feature id for the '<em><b>Lifeline</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE_EVENT__LIFELINE = EVENT__LIFELINE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE_EVENT__NAME = EVENT__NAME;

	/**
	 * The feature id for the '<em><b>Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE_EVENT__TIME = EVENT__TIME;

	/**
	 * The feature id for the '<em><b>Message</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE_EVENT__MESSAGE = EVENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Receive Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RECEIVE_EVENT_FEATURE_COUNT = EVENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.MessageImpl <em>Message</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.MessageImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getMessage()
	 * @generated
	 */
	int MESSAGE = 18;

	/**
	 * The feature id for the '<em><b>Sender</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__SENDER = 0;

	/**
	 * The feature id for the '<em><b>Receiver</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__RECEIVER = 1;

	/**
	 * The feature id for the '<em><b>Body</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__BODY = 2;

	/**
	 * The feature id for the '<em><b>Sequence View</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE__SEQUENCE_VIEW = 3;

	/**
	 * The number of structural features of the '<em>Message</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MESSAGE_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.CombinedFragmentImpl <em>Combined Fragment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.CombinedFragmentImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getCombinedFragment()
	 * @generated
	 */
	int COMBINED_FRAGMENT = 19;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_FRAGMENT__NAME = NAMED_ELEMENT__NAME;

	/**
	 * The number of structural features of the '<em>Combined Fragment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMBINED_FRAGMENT_FEATURE_COUNT = NAMED_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.OneOperandCFImpl <em>One Operand CF</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.OneOperandCFImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getOneOperandCF()
	 * @generated
	 */
	int ONE_OPERAND_CF = 20;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONE_OPERAND_CF__NAME = COMBINED_FRAGMENT__NAME;

	/**
	 * The feature id for the '<em><b>Operand</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONE_OPERAND_CF__OPERAND = COMBINED_FRAGMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Operand Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONE_OPERAND_CF__OPERAND_TYPE = COMBINED_FRAGMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>One Operand CF</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ONE_OPERAND_CF_FEATURE_COUNT = COMBINED_FRAGMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.MultipleOperandCFImpl <em>Multiple Operand CF</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.MultipleOperandCFImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getMultipleOperandCF()
	 * @generated
	 */
	int MULTIPLE_OPERAND_CF = 21;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLE_OPERAND_CF__NAME = COMBINED_FRAGMENT__NAME;

	/**
	 * The feature id for the '<em><b>Operands</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLE_OPERAND_CF__OPERANDS = COMBINED_FRAGMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Operand Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLE_OPERAND_CF__OPERAND_TYPE = COMBINED_FRAGMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Multiple Operand CF</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MULTIPLE_OPERAND_CF_FEATURE_COUNT = COMBINED_FRAGMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.OperandImpl <em>Operand</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.OperandImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getOperand()
	 * @generated
	 */
	int OPERAND = 22;

	/**
	 * The feature id for the '<em><b>Covers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERAND__COVERS = 0;

	/**
	 * The number of structural features of the '<em>Operand</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERAND_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.impl.StateConditionImpl <em>State Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.impl.StateConditionImpl
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getStateCondition()
	 * @generated
	 */
	int STATE_CONDITION = 23;

	/**
	 * The feature id for the '<em><b>Lifeline</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_CONDITION__LIFELINE = CONDITION__LIFELINE;

	/**
	 * The feature id for the '<em><b>State</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_CONDITION__STATE = CONDITION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>State Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATE_CONDITION_FEATURE_COUNT = CONDITION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.OneOperandType <em>One Operand Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.OneOperandType
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getOneOperandType()
	 * @generated
	 */
	int ONE_OPERAND_TYPE = 24;

	/**
	 * The meta object id for the '{@link org.modelevolution.multiview.MultipleOperandType <em>Multiple Operand Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.modelevolution.multiview.MultipleOperandType
	 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getMultipleOperandType()
	 * @generated
	 */
	int MULTIPLE_OPERAND_TYPE = 25;


	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.NamedElement <em>Named Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Named Element</em>'.
	 * @see org.modelevolution.multiview.NamedElement
	 * @generated
	 */
	EClass getNamedElement();

	/**
	 * Returns the meta object for the attribute '{@link org.modelevolution.multiview.NamedElement#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.modelevolution.multiview.NamedElement#getName()
	 * @see #getNamedElement()
	 * @generated
	 */
	EAttribute getNamedElement_Name();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.Region <em>Region</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Region</em>'.
	 * @see org.modelevolution.multiview.Region
	 * @generated
	 */
	EClass getRegion();

	/**
	 * Returns the meta object for the containment reference list '{@link org.modelevolution.multiview.Region#getStates <em>States</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>States</em>'.
	 * @see org.modelevolution.multiview.Region#getStates()
	 * @see #getRegion()
	 * @generated
	 */
	EReference getRegion_States();

	/**
	 * Returns the meta object for the containment reference '{@link org.modelevolution.multiview.Region#getInitialTransition <em>Initial Transition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Initial Transition</em>'.
	 * @see org.modelevolution.multiview.Region#getInitialTransition()
	 * @see #getRegion()
	 * @generated
	 */
	EReference getRegion_InitialTransition();

	/**
	 * Returns the meta object for the reference '{@link org.modelevolution.multiview.Region#getClass_ <em>Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Class</em>'.
	 * @see org.modelevolution.multiview.Region#getClass_()
	 * @see #getRegion()
	 * @generated
	 */
	EReference getRegion_Class();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.State <em>State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>State</em>'.
	 * @see org.modelevolution.multiview.State
	 * @generated
	 */
	EClass getState();

	/**
	 * Returns the meta object for the containment reference list '{@link org.modelevolution.multiview.State#getOutgoing <em>Outgoing</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Outgoing</em>'.
	 * @see org.modelevolution.multiview.State#getOutgoing()
	 * @see #getState()
	 * @generated
	 */
	EReference getState_Outgoing();

	/**
	 * Returns the meta object for the containment reference '{@link org.modelevolution.multiview.State#getSubregion <em>Subregion</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Subregion</em>'.
	 * @see org.modelevolution.multiview.State#getSubregion()
	 * @see #getState()
	 * @generated
	 */
	EReference getState_Subregion();

	/**
	 * Returns the meta object for the reference list '{@link org.modelevolution.multiview.State#getIncoming <em>Incoming</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Incoming</em>'.
	 * @see org.modelevolution.multiview.State#getIncoming()
	 * @see #getState()
	 * @generated
	 */
	EReference getState_Incoming();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.Symbol <em>Symbol</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Symbol</em>'.
	 * @see org.modelevolution.multiview.Symbol
	 * @generated
	 */
	EClass getSymbol();

	/**
	 * Returns the meta object for the reference list '{@link org.modelevolution.multiview.Symbol#getTriggers <em>Triggers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Triggers</em>'.
	 * @see org.modelevolution.multiview.Symbol#getTriggers()
	 * @see #getSymbol()
	 * @generated
	 */
	EReference getSymbol_Triggers();

	/**
	 * Returns the meta object for the reference list '{@link org.modelevolution.multiview.Symbol#getIsTriggeredBy <em>Is Triggered By</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Is Triggered By</em>'.
	 * @see org.modelevolution.multiview.Symbol#getIsTriggeredBy()
	 * @see #getSymbol()
	 * @generated
	 */
	EReference getSymbol_IsTriggeredBy();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.Transition <em>Transition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Transition</em>'.
	 * @see org.modelevolution.multiview.Transition
	 * @generated
	 */
	EClass getTransition();

	/**
	 * Returns the meta object for the reference '{@link org.modelevolution.multiview.Transition#getExecutes <em>Executes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Executes</em>'.
	 * @see org.modelevolution.multiview.Transition#getExecutes()
	 * @see #getTransition()
	 * @generated
	 */
	EReference getTransition_Executes();

	/**
	 * Returns the meta object for the containment reference '{@link org.modelevolution.multiview.Transition#getGuard <em>Guard</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Guard</em>'.
	 * @see org.modelevolution.multiview.Transition#getGuard()
	 * @see #getTransition()
	 * @generated
	 */
	EReference getTransition_Guard();

	/**
	 * Returns the meta object for the reference list '{@link org.modelevolution.multiview.Transition#getEffects <em>Effects</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Effects</em>'.
	 * @see org.modelevolution.multiview.Transition#getEffects()
	 * @see #getTransition()
	 * @generated
	 */
	EReference getTransition_Effects();

	/**
	 * Returns the meta object for the reference '{@link org.modelevolution.multiview.Transition#getTrigger <em>Trigger</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Trigger</em>'.
	 * @see org.modelevolution.multiview.Transition#getTrigger()
	 * @see #getTransition()
	 * @generated
	 */
	EReference getTransition_Trigger();

	/**
	 * Returns the meta object for the container reference '{@link org.modelevolution.multiview.Transition#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Source</em>'.
	 * @see org.modelevolution.multiview.Transition#getSource()
	 * @see #getTransition()
	 * @generated
	 */
	EReference getTransition_Source();

	/**
	 * Returns the meta object for the reference '{@link org.modelevolution.multiview.Transition#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Target</em>'.
	 * @see org.modelevolution.multiview.Transition#getTarget()
	 * @see #getTransition()
	 * @generated
	 */
	EReference getTransition_Target();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.MultiviewModel <em>Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Model</em>'.
	 * @see org.modelevolution.multiview.MultiviewModel
	 * @generated
	 */
	EClass getMultiviewModel();

	/**
	 * Returns the meta object for the containment reference '{@link org.modelevolution.multiview.MultiviewModel#getClassview <em>Classview</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Classview</em>'.
	 * @see org.modelevolution.multiview.MultiviewModel#getClassview()
	 * @see #getMultiviewModel()
	 * @generated
	 */
	EReference getMultiviewModel_Classview();

	/**
	 * Returns the meta object for the containment reference '{@link org.modelevolution.multiview.MultiviewModel#getStateview <em>Stateview</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Stateview</em>'.
	 * @see org.modelevolution.multiview.MultiviewModel#getStateview()
	 * @see #getMultiviewModel()
	 * @generated
	 */
	EReference getMultiviewModel_Stateview();

	/**
	 * Returns the meta object for the containment reference '{@link org.modelevolution.multiview.MultiviewModel#getSequenceview <em>Sequenceview</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Sequenceview</em>'.
	 * @see org.modelevolution.multiview.MultiviewModel#getSequenceview()
	 * @see #getMultiviewModel()
	 * @generated
	 */
	EReference getMultiviewModel_Sequenceview();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.Class <em>Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Class</em>'.
	 * @see org.modelevolution.multiview.Class
	 * @generated
	 */
	EClass getClass_();

	/**
	 * Returns the meta object for the containment reference list '{@link org.modelevolution.multiview.Class#getOperations <em>Operations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Operations</em>'.
	 * @see org.modelevolution.multiview.Class#getOperations()
	 * @see #getClass_()
	 * @generated
	 */
	EReference getClass_Operations();

	/**
	 * Returns the meta object for the reference '{@link org.modelevolution.multiview.Class#getStatemachine <em>Statemachine</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Statemachine</em>'.
	 * @see org.modelevolution.multiview.Class#getStatemachine()
	 * @see #getClass_()
	 * @generated
	 */
	EReference getClass_Statemachine();

	/**
	 * Returns the meta object for the reference list '{@link org.modelevolution.multiview.Class#getLifelines <em>Lifelines</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Lifelines</em>'.
	 * @see org.modelevolution.multiview.Class#getLifelines()
	 * @see #getClass_()
	 * @generated
	 */
	EReference getClass_Lifelines();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.Operation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Operation</em>'.
	 * @see org.modelevolution.multiview.Operation
	 * @generated
	 */
	EClass getOperation();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.ClassView <em>Class View</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Class View</em>'.
	 * @see org.modelevolution.multiview.ClassView
	 * @generated
	 */
	EClass getClassView();

	/**
	 * Returns the meta object for the containment reference list '{@link org.modelevolution.multiview.ClassView#getClasses <em>Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Classes</em>'.
	 * @see org.modelevolution.multiview.ClassView#getClasses()
	 * @see #getClassView()
	 * @generated
	 */
	EReference getClassView_Classes();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.StateView <em>State View</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>State View</em>'.
	 * @see org.modelevolution.multiview.StateView
	 * @generated
	 */
	EClass getStateView();

	/**
	 * Returns the meta object for the containment reference list '{@link org.modelevolution.multiview.StateView#getStatemachines <em>Statemachines</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Statemachines</em>'.
	 * @see org.modelevolution.multiview.StateView#getStatemachines()
	 * @see #getStateView()
	 * @generated
	 */
	EReference getStateView_Statemachines();

	/**
	 * Returns the meta object for the containment reference list '{@link org.modelevolution.multiview.StateView#getAlphabet <em>Alphabet</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Alphabet</em>'.
	 * @see org.modelevolution.multiview.StateView#getAlphabet()
	 * @see #getStateView()
	 * @generated
	 */
	EReference getStateView_Alphabet();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.SequenceView <em>Sequence View</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Sequence View</em>'.
	 * @see org.modelevolution.multiview.SequenceView
	 * @generated
	 */
	EClass getSequenceView();

	/**
	 * Returns the meta object for the containment reference list '{@link org.modelevolution.multiview.SequenceView#getLifelines <em>Lifelines</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Lifelines</em>'.
	 * @see org.modelevolution.multiview.SequenceView#getLifelines()
	 * @see #getSequenceView()
	 * @generated
	 */
	EReference getSequenceView_Lifelines();

	/**
	 * Returns the meta object for the containment reference list '{@link org.modelevolution.multiview.SequenceView#getFragments <em>Fragments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Fragments</em>'.
	 * @see org.modelevolution.multiview.SequenceView#getFragments()
	 * @see #getSequenceView()
	 * @generated
	 */
	EReference getSequenceView_Fragments();

	/**
	 * Returns the meta object for the containment reference list '{@link org.modelevolution.multiview.SequenceView#getMessages <em>Messages</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Messages</em>'.
	 * @see org.modelevolution.multiview.SequenceView#getMessages()
	 * @see #getSequenceView()
	 * @generated
	 */
	EReference getSequenceView_Messages();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.Guard <em>Guard</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Guard</em>'.
	 * @see org.modelevolution.multiview.Guard
	 * @generated
	 */
	EClass getGuard();

	/**
	 * Returns the meta object for the attribute '{@link org.modelevolution.multiview.Guard#getOclExpression <em>Ocl Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ocl Expression</em>'.
	 * @see org.modelevolution.multiview.Guard#getOclExpression()
	 * @see #getGuard()
	 * @generated
	 */
	EAttribute getGuard_OclExpression();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.Lifeline <em>Lifeline</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Lifeline</em>'.
	 * @see org.modelevolution.multiview.Lifeline
	 * @generated
	 */
	EClass getLifeline();

	/**
	 * Returns the meta object for the containment reference list '{@link org.modelevolution.multiview.Lifeline#getElements <em>Elements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Elements</em>'.
	 * @see org.modelevolution.multiview.Lifeline#getElements()
	 * @see #getLifeline()
	 * @generated
	 */
	EReference getLifeline_Elements();

	/**
	 * Returns the meta object for the reference '{@link org.modelevolution.multiview.Lifeline#getClass_ <em>Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Class</em>'.
	 * @see org.modelevolution.multiview.Lifeline#getClass_()
	 * @see #getLifeline()
	 * @generated
	 */
	EReference getLifeline_Class();

	/**
	 * Returns the meta object for the container reference '{@link org.modelevolution.multiview.Lifeline#getSequenceView <em>Sequence View</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Sequence View</em>'.
	 * @see org.modelevolution.multiview.Lifeline#getSequenceView()
	 * @see #getLifeline()
	 * @generated
	 */
	EReference getLifeline_SequenceView();

	/**
	 * Returns the meta object for the attribute '{@link org.modelevolution.multiview.Lifeline#getDefault_statemachine_name <em>Default statemachine name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Default statemachine name</em>'.
	 * @see org.modelevolution.multiview.Lifeline#getDefault_statemachine_name()
	 * @see #getLifeline()
	 * @generated
	 */
	EAttribute getLifeline_Default_statemachine_name();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.LifelineElement <em>Lifeline Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Lifeline Element</em>'.
	 * @see org.modelevolution.multiview.LifelineElement
	 * @generated
	 */
	EClass getLifelineElement();

	/**
	 * Returns the meta object for the container reference '{@link org.modelevolution.multiview.LifelineElement#getLifeline <em>Lifeline</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Lifeline</em>'.
	 * @see org.modelevolution.multiview.LifelineElement#getLifeline()
	 * @see #getLifelineElement()
	 * @generated
	 */
	EReference getLifelineElement_Lifeline();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.Event <em>Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Event</em>'.
	 * @see org.modelevolution.multiview.Event
	 * @generated
	 */
	EClass getEvent();

	/**
	 * Returns the meta object for the attribute '{@link org.modelevolution.multiview.Event#getTime <em>Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Time</em>'.
	 * @see org.modelevolution.multiview.Event#getTime()
	 * @see #getEvent()
	 * @generated
	 */
	EAttribute getEvent_Time();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.Condition <em>Condition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Condition</em>'.
	 * @see org.modelevolution.multiview.Condition
	 * @generated
	 */
	EClass getCondition();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.SendEvent <em>Send Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Send Event</em>'.
	 * @see org.modelevolution.multiview.SendEvent
	 * @generated
	 */
	EClass getSendEvent();

	/**
	 * Returns the meta object for the reference '{@link org.modelevolution.multiview.SendEvent#getMessage <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Message</em>'.
	 * @see org.modelevolution.multiview.SendEvent#getMessage()
	 * @see #getSendEvent()
	 * @generated
	 */
	EReference getSendEvent_Message();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.ReceiveEvent <em>Receive Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Receive Event</em>'.
	 * @see org.modelevolution.multiview.ReceiveEvent
	 * @generated
	 */
	EClass getReceiveEvent();

	/**
	 * Returns the meta object for the reference '{@link org.modelevolution.multiview.ReceiveEvent#getMessage <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Message</em>'.
	 * @see org.modelevolution.multiview.ReceiveEvent#getMessage()
	 * @see #getReceiveEvent()
	 * @generated
	 */
	EReference getReceiveEvent_Message();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.Message <em>Message</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Message</em>'.
	 * @see org.modelevolution.multiview.Message
	 * @generated
	 */
	EClass getMessage();

	/**
	 * Returns the meta object for the reference '{@link org.modelevolution.multiview.Message#getSender <em>Sender</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Sender</em>'.
	 * @see org.modelevolution.multiview.Message#getSender()
	 * @see #getMessage()
	 * @generated
	 */
	EReference getMessage_Sender();

	/**
	 * Returns the meta object for the reference '{@link org.modelevolution.multiview.Message#getReceiver <em>Receiver</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Receiver</em>'.
	 * @see org.modelevolution.multiview.Message#getReceiver()
	 * @see #getMessage()
	 * @generated
	 */
	EReference getMessage_Receiver();

	/**
	 * Returns the meta object for the reference '{@link org.modelevolution.multiview.Message#getBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Body</em>'.
	 * @see org.modelevolution.multiview.Message#getBody()
	 * @see #getMessage()
	 * @generated
	 */
	EReference getMessage_Body();

	/**
	 * Returns the meta object for the container reference '{@link org.modelevolution.multiview.Message#getSequenceView <em>Sequence View</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Sequence View</em>'.
	 * @see org.modelevolution.multiview.Message#getSequenceView()
	 * @see #getMessage()
	 * @generated
	 */
	EReference getMessage_SequenceView();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.CombinedFragment <em>Combined Fragment</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Combined Fragment</em>'.
	 * @see org.modelevolution.multiview.CombinedFragment
	 * @generated
	 */
	EClass getCombinedFragment();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.OneOperandCF <em>One Operand CF</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>One Operand CF</em>'.
	 * @see org.modelevolution.multiview.OneOperandCF
	 * @generated
	 */
	EClass getOneOperandCF();

	/**
	 * Returns the meta object for the containment reference '{@link org.modelevolution.multiview.OneOperandCF#getOperand <em>Operand</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Operand</em>'.
	 * @see org.modelevolution.multiview.OneOperandCF#getOperand()
	 * @see #getOneOperandCF()
	 * @generated
	 */
	EReference getOneOperandCF_Operand();

	/**
	 * Returns the meta object for the attribute '{@link org.modelevolution.multiview.OneOperandCF#getOperandType <em>Operand Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operand Type</em>'.
	 * @see org.modelevolution.multiview.OneOperandCF#getOperandType()
	 * @see #getOneOperandCF()
	 * @generated
	 */
	EAttribute getOneOperandCF_OperandType();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.MultipleOperandCF <em>Multiple Operand CF</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Multiple Operand CF</em>'.
	 * @see org.modelevolution.multiview.MultipleOperandCF
	 * @generated
	 */
	EClass getMultipleOperandCF();

	/**
	 * Returns the meta object for the containment reference list '{@link org.modelevolution.multiview.MultipleOperandCF#getOperands <em>Operands</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Operands</em>'.
	 * @see org.modelevolution.multiview.MultipleOperandCF#getOperands()
	 * @see #getMultipleOperandCF()
	 * @generated
	 */
	EReference getMultipleOperandCF_Operands();

	/**
	 * Returns the meta object for the attribute '{@link org.modelevolution.multiview.MultipleOperandCF#getOperandType <em>Operand Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operand Type</em>'.
	 * @see org.modelevolution.multiview.MultipleOperandCF#getOperandType()
	 * @see #getMultipleOperandCF()
	 * @generated
	 */
	EAttribute getMultipleOperandCF_OperandType();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.Operand <em>Operand</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Operand</em>'.
	 * @see org.modelevolution.multiview.Operand
	 * @generated
	 */
	EClass getOperand();

	/**
	 * Returns the meta object for the reference list '{@link org.modelevolution.multiview.Operand#getCovers <em>Covers</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Covers</em>'.
	 * @see org.modelevolution.multiview.Operand#getCovers()
	 * @see #getOperand()
	 * @generated
	 */
	EReference getOperand_Covers();

	/**
	 * Returns the meta object for class '{@link org.modelevolution.multiview.StateCondition <em>State Condition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>State Condition</em>'.
	 * @see org.modelevolution.multiview.StateCondition
	 * @generated
	 */
	EClass getStateCondition();

	/**
	 * Returns the meta object for the reference '{@link org.modelevolution.multiview.StateCondition#getState <em>State</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>State</em>'.
	 * @see org.modelevolution.multiview.StateCondition#getState()
	 * @see #getStateCondition()
	 * @generated
	 */
	EReference getStateCondition_State();

	/**
	 * Returns the meta object for enum '{@link org.modelevolution.multiview.OneOperandType <em>One Operand Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>One Operand Type</em>'.
	 * @see org.modelevolution.multiview.OneOperandType
	 * @generated
	 */
	EEnum getOneOperandType();

	/**
	 * Returns the meta object for enum '{@link org.modelevolution.multiview.MultipleOperandType <em>Multiple Operand Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Multiple Operand Type</em>'.
	 * @see org.modelevolution.multiview.MultipleOperandType
	 * @generated
	 */
	EEnum getMultipleOperandType();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	MultiviewFactory getMultiviewFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.NamedElementImpl <em>Named Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.NamedElementImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getNamedElement()
		 * @generated
		 */
		EClass NAMED_ELEMENT = eINSTANCE.getNamedElement();

		/**
		 * The meta object literal for the '<em><b>Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NAMED_ELEMENT__NAME = eINSTANCE.getNamedElement_Name();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.RegionImpl <em>Region</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.RegionImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getRegion()
		 * @generated
		 */
		EClass REGION = eINSTANCE.getRegion();

		/**
		 * The meta object literal for the '<em><b>States</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REGION__STATES = eINSTANCE.getRegion_States();

		/**
		 * The meta object literal for the '<em><b>Initial Transition</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REGION__INITIAL_TRANSITION = eINSTANCE.getRegion_InitialTransition();

		/**
		 * The meta object literal for the '<em><b>Class</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REGION__CLASS = eINSTANCE.getRegion_Class();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.StateImpl <em>State</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.StateImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getState()
		 * @generated
		 */
		EClass STATE = eINSTANCE.getState();

		/**
		 * The meta object literal for the '<em><b>Outgoing</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STATE__OUTGOING = eINSTANCE.getState_Outgoing();

		/**
		 * The meta object literal for the '<em><b>Subregion</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STATE__SUBREGION = eINSTANCE.getState_Subregion();

		/**
		 * The meta object literal for the '<em><b>Incoming</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STATE__INCOMING = eINSTANCE.getState_Incoming();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.SymbolImpl <em>Symbol</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.SymbolImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getSymbol()
		 * @generated
		 */
		EClass SYMBOL = eINSTANCE.getSymbol();

		/**
		 * The meta object literal for the '<em><b>Triggers</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SYMBOL__TRIGGERS = eINSTANCE.getSymbol_Triggers();

		/**
		 * The meta object literal for the '<em><b>Is Triggered By</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SYMBOL__IS_TRIGGERED_BY = eINSTANCE.getSymbol_IsTriggeredBy();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.TransitionImpl <em>Transition</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.TransitionImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getTransition()
		 * @generated
		 */
		EClass TRANSITION = eINSTANCE.getTransition();

		/**
		 * The meta object literal for the '<em><b>Executes</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRANSITION__EXECUTES = eINSTANCE.getTransition_Executes();

		/**
		 * The meta object literal for the '<em><b>Guard</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRANSITION__GUARD = eINSTANCE.getTransition_Guard();

		/**
		 * The meta object literal for the '<em><b>Effects</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRANSITION__EFFECTS = eINSTANCE.getTransition_Effects();

		/**
		 * The meta object literal for the '<em><b>Trigger</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRANSITION__TRIGGER = eINSTANCE.getTransition_Trigger();

		/**
		 * The meta object literal for the '<em><b>Source</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRANSITION__SOURCE = eINSTANCE.getTransition_Source();

		/**
		 * The meta object literal for the '<em><b>Target</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TRANSITION__TARGET = eINSTANCE.getTransition_Target();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.MultiviewModelImpl <em>Model</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.MultiviewModelImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getMultiviewModel()
		 * @generated
		 */
		EClass MULTIVIEW_MODEL = eINSTANCE.getMultiviewModel();

		/**
		 * The meta object literal for the '<em><b>Classview</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MULTIVIEW_MODEL__CLASSVIEW = eINSTANCE.getMultiviewModel_Classview();

		/**
		 * The meta object literal for the '<em><b>Stateview</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MULTIVIEW_MODEL__STATEVIEW = eINSTANCE.getMultiviewModel_Stateview();

		/**
		 * The meta object literal for the '<em><b>Sequenceview</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MULTIVIEW_MODEL__SEQUENCEVIEW = eINSTANCE.getMultiviewModel_Sequenceview();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.ClassImpl <em>Class</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.ClassImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getClass_()
		 * @generated
		 */
		EClass CLASS = eINSTANCE.getClass_();

		/**
		 * The meta object literal for the '<em><b>Operations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLASS__OPERATIONS = eINSTANCE.getClass_Operations();

		/**
		 * The meta object literal for the '<em><b>Statemachine</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLASS__STATEMACHINE = eINSTANCE.getClass_Statemachine();

		/**
		 * The meta object literal for the '<em><b>Lifelines</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLASS__LIFELINES = eINSTANCE.getClass_Lifelines();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.OperationImpl <em>Operation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.OperationImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getOperation()
		 * @generated
		 */
		EClass OPERATION = eINSTANCE.getOperation();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.ClassViewImpl <em>Class View</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.ClassViewImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getClassView()
		 * @generated
		 */
		EClass CLASS_VIEW = eINSTANCE.getClassView();

		/**
		 * The meta object literal for the '<em><b>Classes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CLASS_VIEW__CLASSES = eINSTANCE.getClassView_Classes();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.StateViewImpl <em>State View</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.StateViewImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getStateView()
		 * @generated
		 */
		EClass STATE_VIEW = eINSTANCE.getStateView();

		/**
		 * The meta object literal for the '<em><b>Statemachines</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STATE_VIEW__STATEMACHINES = eINSTANCE.getStateView_Statemachines();

		/**
		 * The meta object literal for the '<em><b>Alphabet</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STATE_VIEW__ALPHABET = eINSTANCE.getStateView_Alphabet();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.SequenceViewImpl <em>Sequence View</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.SequenceViewImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getSequenceView()
		 * @generated
		 */
		EClass SEQUENCE_VIEW = eINSTANCE.getSequenceView();

		/**
		 * The meta object literal for the '<em><b>Lifelines</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SEQUENCE_VIEW__LIFELINES = eINSTANCE.getSequenceView_Lifelines();

		/**
		 * The meta object literal for the '<em><b>Fragments</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SEQUENCE_VIEW__FRAGMENTS = eINSTANCE.getSequenceView_Fragments();

		/**
		 * The meta object literal for the '<em><b>Messages</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SEQUENCE_VIEW__MESSAGES = eINSTANCE.getSequenceView_Messages();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.GuardImpl <em>Guard</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.GuardImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getGuard()
		 * @generated
		 */
		EClass GUARD = eINSTANCE.getGuard();

		/**
		 * The meta object literal for the '<em><b>Ocl Expression</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GUARD__OCL_EXPRESSION = eINSTANCE.getGuard_OclExpression();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.LifelineImpl <em>Lifeline</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.LifelineImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getLifeline()
		 * @generated
		 */
		EClass LIFELINE = eINSTANCE.getLifeline();

		/**
		 * The meta object literal for the '<em><b>Elements</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LIFELINE__ELEMENTS = eINSTANCE.getLifeline_Elements();

		/**
		 * The meta object literal for the '<em><b>Class</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LIFELINE__CLASS = eINSTANCE.getLifeline_Class();

		/**
		 * The meta object literal for the '<em><b>Sequence View</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LIFELINE__SEQUENCE_VIEW = eINSTANCE.getLifeline_SequenceView();

		/**
		 * The meta object literal for the '<em><b>Default statemachine name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LIFELINE__DEFAULT_STATEMACHINE_NAME = eINSTANCE.getLifeline_Default_statemachine_name();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.LifelineElementImpl <em>Lifeline Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.LifelineElementImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getLifelineElement()
		 * @generated
		 */
		EClass LIFELINE_ELEMENT = eINSTANCE.getLifelineElement();

		/**
		 * The meta object literal for the '<em><b>Lifeline</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LIFELINE_ELEMENT__LIFELINE = eINSTANCE.getLifelineElement_Lifeline();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.EventImpl <em>Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.EventImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getEvent()
		 * @generated
		 */
		EClass EVENT = eINSTANCE.getEvent();

		/**
		 * The meta object literal for the '<em><b>Time</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute EVENT__TIME = eINSTANCE.getEvent_Time();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.ConditionImpl <em>Condition</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.ConditionImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getCondition()
		 * @generated
		 */
		EClass CONDITION = eINSTANCE.getCondition();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.SendEventImpl <em>Send Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.SendEventImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getSendEvent()
		 * @generated
		 */
		EClass SEND_EVENT = eINSTANCE.getSendEvent();

		/**
		 * The meta object literal for the '<em><b>Message</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SEND_EVENT__MESSAGE = eINSTANCE.getSendEvent_Message();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.ReceiveEventImpl <em>Receive Event</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.ReceiveEventImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getReceiveEvent()
		 * @generated
		 */
		EClass RECEIVE_EVENT = eINSTANCE.getReceiveEvent();

		/**
		 * The meta object literal for the '<em><b>Message</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RECEIVE_EVENT__MESSAGE = eINSTANCE.getReceiveEvent_Message();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.MessageImpl <em>Message</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.MessageImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getMessage()
		 * @generated
		 */
		EClass MESSAGE = eINSTANCE.getMessage();

		/**
		 * The meta object literal for the '<em><b>Sender</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MESSAGE__SENDER = eINSTANCE.getMessage_Sender();

		/**
		 * The meta object literal for the '<em><b>Receiver</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MESSAGE__RECEIVER = eINSTANCE.getMessage_Receiver();

		/**
		 * The meta object literal for the '<em><b>Body</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MESSAGE__BODY = eINSTANCE.getMessage_Body();

		/**
		 * The meta object literal for the '<em><b>Sequence View</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MESSAGE__SEQUENCE_VIEW = eINSTANCE.getMessage_SequenceView();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.CombinedFragmentImpl <em>Combined Fragment</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.CombinedFragmentImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getCombinedFragment()
		 * @generated
		 */
		EClass COMBINED_FRAGMENT = eINSTANCE.getCombinedFragment();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.OneOperandCFImpl <em>One Operand CF</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.OneOperandCFImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getOneOperandCF()
		 * @generated
		 */
		EClass ONE_OPERAND_CF = eINSTANCE.getOneOperandCF();

		/**
		 * The meta object literal for the '<em><b>Operand</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ONE_OPERAND_CF__OPERAND = eINSTANCE.getOneOperandCF_Operand();

		/**
		 * The meta object literal for the '<em><b>Operand Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ONE_OPERAND_CF__OPERAND_TYPE = eINSTANCE.getOneOperandCF_OperandType();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.MultipleOperandCFImpl <em>Multiple Operand CF</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.MultipleOperandCFImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getMultipleOperandCF()
		 * @generated
		 */
		EClass MULTIPLE_OPERAND_CF = eINSTANCE.getMultipleOperandCF();

		/**
		 * The meta object literal for the '<em><b>Operands</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MULTIPLE_OPERAND_CF__OPERANDS = eINSTANCE.getMultipleOperandCF_Operands();

		/**
		 * The meta object literal for the '<em><b>Operand Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MULTIPLE_OPERAND_CF__OPERAND_TYPE = eINSTANCE.getMultipleOperandCF_OperandType();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.OperandImpl <em>Operand</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.OperandImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getOperand()
		 * @generated
		 */
		EClass OPERAND = eINSTANCE.getOperand();

		/**
		 * The meta object literal for the '<em><b>Covers</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference OPERAND__COVERS = eINSTANCE.getOperand_Covers();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.impl.StateConditionImpl <em>State Condition</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.impl.StateConditionImpl
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getStateCondition()
		 * @generated
		 */
		EClass STATE_CONDITION = eINSTANCE.getStateCondition();

		/**
		 * The meta object literal for the '<em><b>State</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STATE_CONDITION__STATE = eINSTANCE.getStateCondition_State();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.OneOperandType <em>One Operand Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.OneOperandType
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getOneOperandType()
		 * @generated
		 */
		EEnum ONE_OPERAND_TYPE = eINSTANCE.getOneOperandType();

		/**
		 * The meta object literal for the '{@link org.modelevolution.multiview.MultipleOperandType <em>Multiple Operand Type</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.modelevolution.multiview.MultipleOperandType
		 * @see org.modelevolution.multiview.impl.MultiviewPackageImpl#getMultipleOperandType()
		 * @generated
		 */
		EEnum MULTIPLE_OPERAND_TYPE = eINSTANCE.getMultipleOperandType();

	}

} //MultiviewPackage
