/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Region</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.modelevolution.multiview.Region#getStates <em>States</em>}</li>
 *   <li>{@link org.modelevolution.multiview.Region#getInitialTransition <em>Initial Transition</em>}</li>
 *   <li>{@link org.modelevolution.multiview.Region#getClass_ <em>Class</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.modelevolution.multiview.MultiviewPackage#getRegion()
 * @model
 * @generated
 */
public interface Region extends NamedElement {
	/**
	 * Returns the value of the '<em><b>States</b></em>' containment reference list.
	 * The list contents are of type {@link org.modelevolution.multiview.State}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>States</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>States</em>' containment reference list.
	 * @see org.modelevolution.multiview.MultiviewPackage#getRegion_States()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<State> getStates();

	/**
	 * Returns the value of the '<em><b>Initial Transition</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Initial Transition</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Initial Transition</em>' containment reference.
	 * @see #setInitialTransition(Transition)
	 * @see org.modelevolution.multiview.MultiviewPackage#getRegion_InitialTransition()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	Transition getInitialTransition();

	/**
	 * Sets the value of the '{@link org.modelevolution.multiview.Region#getInitialTransition <em>Initial Transition</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Initial Transition</em>' containment reference.
	 * @see #getInitialTransition()
	 * @generated
	 */
	void setInitialTransition(Transition value);

	/**
	 * Returns the value of the '<em><b>Class</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.Class#getStatemachine <em>Statemachine</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Class</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Class</em>' reference.
	 * @see #setClass(org.modelevolution.multiview.Class)
	 * @see org.modelevolution.multiview.MultiviewPackage#getRegion_Class()
	 * @see org.modelevolution.multiview.Class#getStatemachine
	 * @model opposite="statemachine"
	 * @generated
	 */
	org.modelevolution.multiview.Class getClass_();

	/**
	 * Sets the value of the '{@link org.modelevolution.multiview.Region#getClass_ <em>Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Class</em>' reference.
	 * @see #getClass_()
	 * @generated
	 */
	void setClass(org.modelevolution.multiview.Class value);

} // Region
