/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Sequence View</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.modelevolution.multiview.SequenceView#getLifelines <em>Lifelines</em>}</li>
 *   <li>{@link org.modelevolution.multiview.SequenceView#getFragments <em>Fragments</em>}</li>
 *   <li>{@link org.modelevolution.multiview.SequenceView#getMessages <em>Messages</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.modelevolution.multiview.MultiviewPackage#getSequenceView()
 * @model
 * @generated
 */
public interface SequenceView extends NamedElement {
	/**
	 * Returns the value of the '<em><b>Lifelines</b></em>' containment reference list.
	 * The list contents are of type {@link org.modelevolution.multiview.Lifeline}.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.Lifeline#getSequenceView <em>Sequence View</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Lifelines</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Lifelines</em>' containment reference list.
	 * @see org.modelevolution.multiview.MultiviewPackage#getSequenceView_Lifelines()
	 * @see org.modelevolution.multiview.Lifeline#getSequenceView
	 * @model opposite="sequenceView" containment="true" ordered="false"
	 * @generated
	 */
	EList<Lifeline> getLifelines();

	/**
	 * Returns the value of the '<em><b>Fragments</b></em>' containment reference list.
	 * The list contents are of type {@link org.modelevolution.multiview.CombinedFragment}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Fragments</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Fragments</em>' containment reference list.
	 * @see org.modelevolution.multiview.MultiviewPackage#getSequenceView_Fragments()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<CombinedFragment> getFragments();

	/**
	 * Returns the value of the '<em><b>Messages</b></em>' containment reference list.
	 * The list contents are of type {@link org.modelevolution.multiview.Message}.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.Message#getSequenceView <em>Sequence View</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Messages</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Messages</em>' containment reference list.
	 * @see org.modelevolution.multiview.MultiviewPackage#getSequenceView_Messages()
	 * @see org.modelevolution.multiview.Message#getSequenceView
	 * @model opposite="sequenceView" containment="true" ordered="false"
	 * @generated
	 */
	EList<Message> getMessages();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model
	 * @generated
	 */
	boolean isSentBefore(Message msg1, Message msg2);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @model kind="operation"
	 * @generated
	 */
	EList<Message> getOrderedMessages();

} // SequenceView
