/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>State</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.modelevolution.multiview.State#getOutgoing <em>Outgoing</em>}</li>
 *   <li>{@link org.modelevolution.multiview.State#getSubregion <em>Subregion</em>}</li>
 *   <li>{@link org.modelevolution.multiview.State#getIncoming <em>Incoming</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.modelevolution.multiview.MultiviewPackage#getState()
 * @model
 * @generated
 */
public interface State extends NamedElement {
	/**
	 * Returns the value of the '<em><b>Outgoing</b></em>' containment reference list.
	 * The list contents are of type {@link org.modelevolution.multiview.Transition}.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.Transition#getSource <em>Source</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Outgoing</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Outgoing</em>' containment reference list.
	 * @see org.modelevolution.multiview.MultiviewPackage#getState_Outgoing()
	 * @see org.modelevolution.multiview.Transition#getSource
	 * @model opposite="source" containment="true" ordered="false"
	 * @generated
	 */
	EList<Transition> getOutgoing();

	/**
	 * Returns the value of the '<em><b>Subregion</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Subregion</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Subregion</em>' containment reference.
	 * @see #setSubregion(Region)
	 * @see org.modelevolution.multiview.MultiviewPackage#getState_Subregion()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	Region getSubregion();

	/**
	 * Sets the value of the '{@link org.modelevolution.multiview.State#getSubregion <em>Subregion</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Subregion</em>' containment reference.
	 * @see #getSubregion()
	 * @generated
	 */
	void setSubregion(Region value);

	/**
	 * Returns the value of the '<em><b>Incoming</b></em>' reference list.
	 * The list contents are of type {@link org.modelevolution.multiview.Transition}.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.Transition#getTarget <em>Target</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Incoming</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Incoming</em>' reference list.
	 * @see org.modelevolution.multiview.MultiviewPackage#getState_Incoming()
	 * @see org.modelevolution.multiview.Transition#getTarget
	 * @model opposite="target" required="true" ordered="false"
	 * @generated
	 */
	EList<Transition> getIncoming();

} // State
