/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Symbol</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.modelevolution.multiview.Symbol#getTriggers <em>Triggers</em>}</li>
 *   <li>{@link org.modelevolution.multiview.Symbol#getIsTriggeredBy <em>Is Triggered By</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.modelevolution.multiview.MultiviewPackage#getSymbol()
 * @model
 * @generated
 */
public interface Symbol extends NamedElement {
	/**
	 * Returns the value of the '<em><b>Triggers</b></em>' reference list.
	 * The list contents are of type {@link org.modelevolution.multiview.Transition}.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.Transition#getTrigger <em>Trigger</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Triggers</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Triggers</em>' reference list.
	 * @see org.modelevolution.multiview.MultiviewPackage#getSymbol_Triggers()
	 * @see org.modelevolution.multiview.Transition#getTrigger
	 * @model opposite="trigger" ordered="false"
	 * @generated
	 */
	EList<Transition> getTriggers();

	/**
	 * Returns the value of the '<em><b>Is Triggered By</b></em>' reference list.
	 * The list contents are of type {@link org.modelevolution.multiview.Transition}.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.Transition#getEffects <em>Effects</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Is Triggered By</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Is Triggered By</em>' reference list.
	 * @see org.modelevolution.multiview.MultiviewPackage#getSymbol_IsTriggeredBy()
	 * @see org.modelevolution.multiview.Transition#getEffects
	 * @model opposite="effects"
	 * @generated
	 */
	EList<Transition> getIsTriggeredBy();

} // Symbol
