/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Transition</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.modelevolution.multiview.Transition#getExecutes <em>Executes</em>}</li>
 *   <li>{@link org.modelevolution.multiview.Transition#getGuard <em>Guard</em>}</li>
 *   <li>{@link org.modelevolution.multiview.Transition#getEffects <em>Effects</em>}</li>
 *   <li>{@link org.modelevolution.multiview.Transition#getTrigger <em>Trigger</em>}</li>
 *   <li>{@link org.modelevolution.multiview.Transition#getSource <em>Source</em>}</li>
 *   <li>{@link org.modelevolution.multiview.Transition#getTarget <em>Target</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.modelevolution.multiview.MultiviewPackage#getTransition()
 * @model
 * @generated
 */
public interface Transition extends EObject {
	/**
	 * Returns the value of the '<em><b>Executes</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Executes</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Executes</em>' reference.
	 * @see #setExecutes(Operation)
	 * @see org.modelevolution.multiview.MultiviewPackage#getTransition_Executes()
	 * @model ordered="false"
	 * @generated
	 */
	Operation getExecutes();

	/**
	 * Sets the value of the '{@link org.modelevolution.multiview.Transition#getExecutes <em>Executes</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Executes</em>' reference.
	 * @see #getExecutes()
	 * @generated
	 */
	void setExecutes(Operation value);

	/**
	 * Returns the value of the '<em><b>Guard</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Guard</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Guard</em>' containment reference.
	 * @see #setGuard(Guard)
	 * @see org.modelevolution.multiview.MultiviewPackage#getTransition_Guard()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	Guard getGuard();

	/**
	 * Sets the value of the '{@link org.modelevolution.multiview.Transition#getGuard <em>Guard</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Guard</em>' containment reference.
	 * @see #getGuard()
	 * @generated
	 */
	void setGuard(Guard value);

	/**
	 * Returns the value of the '<em><b>Effects</b></em>' reference list.
	 * The list contents are of type {@link org.modelevolution.multiview.Symbol}.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.Symbol#getIsTriggeredBy <em>Is Triggered By</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Effects</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Effects</em>' reference list.
	 * @see org.modelevolution.multiview.MultiviewPackage#getTransition_Effects()
	 * @see org.modelevolution.multiview.Symbol#getIsTriggeredBy
	 * @model opposite="isTriggeredBy" ordered="false"
	 * @generated
	 */
	EList<Symbol> getEffects();

	/**
	 * Returns the value of the '<em><b>Trigger</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.Symbol#getTriggers <em>Triggers</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Trigger</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Trigger</em>' reference.
	 * @see #setTrigger(Symbol)
	 * @see org.modelevolution.multiview.MultiviewPackage#getTransition_Trigger()
	 * @see org.modelevolution.multiview.Symbol#getTriggers
	 * @model opposite="triggers"
	 * @generated
	 */
	Symbol getTrigger();

	/**
	 * Sets the value of the '{@link org.modelevolution.multiview.Transition#getTrigger <em>Trigger</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Trigger</em>' reference.
	 * @see #getTrigger()
	 * @generated
	 */
	void setTrigger(Symbol value);

	/**
	 * Returns the value of the '<em><b>Source</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.State#getOutgoing <em>Outgoing</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Source</em>' container reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Source</em>' container reference.
	 * @see #setSource(State)
	 * @see org.modelevolution.multiview.MultiviewPackage#getTransition_Source()
	 * @see org.modelevolution.multiview.State#getOutgoing
	 * @model opposite="outgoing" transient="false" ordered="false"
	 * @generated
	 */
	State getSource();

	/**
	 * Sets the value of the '{@link org.modelevolution.multiview.Transition#getSource <em>Source</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Source</em>' container reference.
	 * @see #getSource()
	 * @generated
	 */
	void setSource(State value);

	/**
	 * Returns the value of the '<em><b>Target</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.modelevolution.multiview.State#getIncoming <em>Incoming</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Target</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Target</em>' reference.
	 * @see #setTarget(State)
	 * @see org.modelevolution.multiview.MultiviewPackage#getTransition_Target()
	 * @see org.modelevolution.multiview.State#getIncoming
	 * @model opposite="incoming" required="true" ordered="false"
	 * @generated
	 */
	State getTarget();

	/**
	 * Sets the value of the '{@link org.modelevolution.multiview.Transition#getTarget <em>Target</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Target</em>' reference.
	 * @see #getTarget()
	 * @generated
	 */
	void setTarget(State value);

} // Transition
