/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.modelevolution.multiview.ClassView;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.LifelineElement;
import org.modelevolution.multiview.MultiviewFactory;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.SequenceView;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.StateView;
import org.modelevolution.multiview.Symbol;
import org.modelevolution.multiview.Transition;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Lifeline</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.modelevolution.multiview.impl.LifelineImpl#getElements <em>
 * Elements</em>}</li>
 * <li>{@link org.modelevolution.multiview.impl.LifelineImpl#getClass_ <em>Class
 * </em>}</li>
 * <li>{@link org.modelevolution.multiview.impl.LifelineImpl#getSequenceView
 * <em>Sequence View</em>}</li>
 * <li>
 * {@link org.modelevolution.multiview.impl.LifelineImpl#getDefault_statemachine_name
 * <em>Default statemachine name</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class LifelineImpl extends NamedElementImpl implements Lifeline {
	/**
	 * The cached value of the '{@link #getElements() <em>Elements</em>}'
	 * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getElements()
	 * @generated
	 * @ordered
	 */
	protected EList<LifelineElement> elements;

	/**
	 * The cached value of the '{@link #getClass_() <em>Class</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getClass_()
	 * @generated
	 * @ordered
	 */
	protected org.modelevolution.multiview.Class class_;

	/**
	 * The default value of the '{@link #getDefault_statemachine_name()
	 * <em>Default statemachine name</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getDefault_statemachine_name()
	 * @generated
	 * @ordered
	 */
	protected static final String DEFAULT_STATEMACHINE_NAME_EDEFAULT = "DEFAULT";

	/**
	 * The cached value of the '{@link #getDefault_statemachine_name()
	 * <em>Default statemachine name</em>}' attribute. <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @see #getDefault_statemachine_name()
	 * @generated
	 * @ordered
	 */
	protected String default_statemachine_name = DEFAULT_STATEMACHINE_NAME_EDEFAULT;
	
	/**
	 * The cached value of the {@link Region} dummy statemachine.
	 * 
	 * @generated NOT
	 */
	protected Region dummyStatemachine;
	
	/**
	 * The cached value of the {@link org.modelevolution.multiview.Class} dummy class.
	 * 
	 * @generated NOT
	 */
	protected org.modelevolution.multiview.Class dummyClass;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected LifelineImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return MultiviewPackage.Literals.LIFELINE;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<LifelineElement> getElements() {
		if (elements == null) {
			elements = new EObjectContainmentWithInverseEList<LifelineElement>(
					LifelineElement.class, this,
					MultiviewPackage.LIFELINE__ELEMENTS,
					MultiviewPackage.LIFELINE_ELEMENT__LIFELINE);
		}
		return elements;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public org.modelevolution.multiview.Class getClass_() {
		if (class_ != null && class_.eIsProxy()) {
			InternalEObject oldClass = (InternalEObject) class_;
			class_ = (org.modelevolution.multiview.Class) eResolveProxy(oldClass);
			if (class_ != oldClass) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE,
							MultiviewPackage.LIFELINE__CLASS, oldClass, class_));
			}
		}
		return class_;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public org.modelevolution.multiview.Class basicGetClass() {
		return class_;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetClass(
			org.modelevolution.multiview.Class newClass, NotificationChain msgs) {
		org.modelevolution.multiview.Class oldClass = class_;
		class_ = newClass;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this,
					Notification.SET, MultiviewPackage.LIFELINE__CLASS,
					oldClass, newClass);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setClass(org.modelevolution.multiview.Class newClass) {
		if (newClass != class_) {
			NotificationChain msgs = null;
			if (class_ != null)
				msgs = ((InternalEObject) class_).eInverseRemove(this,
						MultiviewPackage.CLASS__LIFELINES,
						org.modelevolution.multiview.Class.class, msgs);
			if (newClass != null)
				msgs = ((InternalEObject) newClass).eInverseAdd(this,
						MultiviewPackage.CLASS__LIFELINES,
						org.modelevolution.multiview.Class.class, msgs);
			msgs = basicSetClass(newClass, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					MultiviewPackage.LIFELINE__CLASS, newClass, newClass));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public SequenceView getSequenceView() {
		if (eContainerFeatureID() != MultiviewPackage.LIFELINE__SEQUENCE_VIEW)
			return null;
		return (SequenceView) eContainer();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetSequenceView(SequenceView newSequenceView,
			NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject) newSequenceView,
				MultiviewPackage.LIFELINE__SEQUENCE_VIEW, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setSequenceView(SequenceView newSequenceView) {
		if (newSequenceView != eInternalContainer()
				|| (eContainerFeatureID() != MultiviewPackage.LIFELINE__SEQUENCE_VIEW && newSequenceView != null)) {
			if (EcoreUtil.isAncestor(this, newSequenceView))
				throw new IllegalArgumentException(
						"Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSequenceView != null)
				msgs = ((InternalEObject) newSequenceView).eInverseAdd(this,
						MultiviewPackage.SEQUENCE_VIEW__LIFELINES,
						SequenceView.class, msgs);
			msgs = basicSetSequenceView(newSequenceView, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					MultiviewPackage.LIFELINE__SEQUENCE_VIEW, newSequenceView,
					newSequenceView));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public String getDefault_statemachine_name() {
		return default_statemachine_name;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setDefault_statemachine_name(String newDefault_statemachine_name) {
		String oldDefault_statemachine_name = default_statemachine_name;
		default_statemachine_name = newDefault_statemachine_name;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					MultiviewPackage.LIFELINE__DEFAULT_STATEMACHINE_NAME,
					oldDefault_statemachine_name, default_statemachine_name));
	}

	/**
	 * <!-- begin-user-doc --> Creates a dummy {@link Region} for this
	 * {@link Lifeline} unless there exists a linked statemachine. <!--
	 * end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public void initDummyStatemachine() {
		MultiviewModel model = (MultiviewModel) getSequenceView().eContainer();
		ClassView cv = model.getClassview();
		StateView sv = model.getStateview();

		if (cv == null) {
			cv = MultiviewFactory.eINSTANCE.createClassView();
			model.setClassview(cv);
		}
		if (sv == null) {
			sv = MultiviewFactory.eINSTANCE.createStateView();
			model.setStateview(sv);
		}

		if (getClass_() == null) {
			dummyClass = MultiviewFactory.eINSTANCE
					.createClass();
			dummyClass.setName(default_statemachine_name);
			cv.getClasses().add(dummyClass);
			setClass(dummyClass);
		}

		if (getClass_().getStatemachine() == null) {
			dummyStatemachine = MultiviewFactory.eINSTANCE
					.createRegion();
			dummyStatemachine.setName(default_statemachine_name);
			sv.getStatemachines().add(dummyStatemachine);

			State dummyState = MultiviewFactory.eINSTANCE.createState();
			dummyState.setName(default_statemachine_name);

			// the dummy state machine accepts all symbols
			for (Symbol s : sv.getAlphabet()) {
				Transition out = MultiviewFactory.eINSTANCE.createTransition();
				out.setSource(dummyState);
				out.setTarget(dummyState);
				out.setTrigger(s);
				dummyState.getOutgoing().add(out);
			}

			dummyStatemachine.getStates().add(dummyState);
			getClass_().setStatemachine(dummyStatemachine);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * Sets the generated {@link Region} dummy statemachine to null.  
	 * <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public void unsetDummyStatemachine() {
		dummyStatemachine = null;
		dummyClass = null;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case MultiviewPackage.LIFELINE__ELEMENTS:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getElements())
					.basicAdd(otherEnd, msgs);
		case MultiviewPackage.LIFELINE__CLASS:
			if (class_ != null)
				msgs = ((InternalEObject) class_).eInverseRemove(this,
						MultiviewPackage.CLASS__LIFELINES,
						org.modelevolution.multiview.Class.class, msgs);
			return basicSetClass((org.modelevolution.multiview.Class) otherEnd,
					msgs);
		case MultiviewPackage.LIFELINE__SEQUENCE_VIEW:
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			return basicSetSequenceView((SequenceView) otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case MultiviewPackage.LIFELINE__ELEMENTS:
			return ((InternalEList<?>) getElements()).basicRemove(otherEnd,
					msgs);
		case MultiviewPackage.LIFELINE__CLASS:
			return basicSetClass(null, msgs);
		case MultiviewPackage.LIFELINE__SEQUENCE_VIEW:
			return basicSetSequenceView(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(
			NotificationChain msgs) {
		switch (eContainerFeatureID()) {
		case MultiviewPackage.LIFELINE__SEQUENCE_VIEW:
			return eInternalContainer().eInverseRemove(this,
					MultiviewPackage.SEQUENCE_VIEW__LIFELINES,
					SequenceView.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case MultiviewPackage.LIFELINE__ELEMENTS:
			return getElements();
		case MultiviewPackage.LIFELINE__CLASS:
			if (resolve)
				return getClass_();
			return basicGetClass();
		case MultiviewPackage.LIFELINE__SEQUENCE_VIEW:
			return getSequenceView();
		case MultiviewPackage.LIFELINE__DEFAULT_STATEMACHINE_NAME:
			return getDefault_statemachine_name();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case MultiviewPackage.LIFELINE__ELEMENTS:
			getElements().clear();
			getElements().addAll(
					(Collection<? extends LifelineElement>) newValue);
			return;
		case MultiviewPackage.LIFELINE__CLASS:
			setClass((org.modelevolution.multiview.Class) newValue);
			return;
		case MultiviewPackage.LIFELINE__SEQUENCE_VIEW:
			setSequenceView((SequenceView) newValue);
			return;
		case MultiviewPackage.LIFELINE__DEFAULT_STATEMACHINE_NAME:
			setDefault_statemachine_name((String) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case MultiviewPackage.LIFELINE__ELEMENTS:
			getElements().clear();
			return;
		case MultiviewPackage.LIFELINE__CLASS:
			setClass((org.modelevolution.multiview.Class) null);
			return;
		case MultiviewPackage.LIFELINE__SEQUENCE_VIEW:
			setSequenceView((SequenceView) null);
			return;
		case MultiviewPackage.LIFELINE__DEFAULT_STATEMACHINE_NAME:
			setDefault_statemachine_name(DEFAULT_STATEMACHINE_NAME_EDEFAULT);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case MultiviewPackage.LIFELINE__ELEMENTS:
			return elements != null && !elements.isEmpty();
		case MultiviewPackage.LIFELINE__CLASS:
			return class_ != null;
		case MultiviewPackage.LIFELINE__SEQUENCE_VIEW:
			return getSequenceView() != null;
		case MultiviewPackage.LIFELINE__DEFAULT_STATEMACHINE_NAME:
			return DEFAULT_STATEMACHINE_NAME_EDEFAULT == null ? default_statemachine_name != null
					: !DEFAULT_STATEMACHINE_NAME_EDEFAULT
							.equals(default_statemachine_name);
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy())
			return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (default_statemachine_name: ");
		result.append(default_statemachine_name);
		result.append(')');
		return result.toString();
	}

} // LifelineImpl
