/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EcoreUtil;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.ReceiveEvent;
import org.modelevolution.multiview.SendEvent;
import org.modelevolution.multiview.SequenceView;
import org.modelevolution.multiview.Symbol;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Message</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.modelevolution.multiview.impl.MessageImpl#getSender <em>Sender
 * </em>}</li>
 * <li>{@link org.modelevolution.multiview.impl.MessageImpl#getReceiver <em>
 * Receiver</em>}</li>
 * <li>{@link org.modelevolution.multiview.impl.MessageImpl#getBody <em>Body
 * </em>}</li>
 * <li>{@link org.modelevolution.multiview.impl.MessageImpl#getSequenceView <em>
 * Sequence View</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class MessageImpl extends EObjectImpl implements Message {
	/**
	 * The cached value of the '{@link #getSender() <em>Sender</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getSender()
	 * @generated
	 * @ordered
	 */
	protected SendEvent sender;

	/**
	 * The cached value of the '{@link #getReceiver() <em>Receiver</em>}'
	 * reference. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getReceiver()
	 * @generated
	 * @ordered
	 */
	protected ReceiveEvent receiver;

	/**
	 * The cached value of the '{@link #getBody() <em>Body</em>}' reference.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getBody()
	 * @generated
	 * @ordered
	 */
	protected Symbol body;

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected MessageImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return MultiviewPackage.Literals.MESSAGE;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public SendEvent getSender() {
		if (sender != null && sender.eIsProxy()) {
			InternalEObject oldSender = (InternalEObject) sender;
			sender = (SendEvent) eResolveProxy(oldSender);
			if (sender != oldSender) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE,
							MultiviewPackage.MESSAGE__SENDER, oldSender, sender));
			}
		}
		return sender;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public SendEvent basicGetSender() {
		return sender;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetSender(SendEvent newSender,
			NotificationChain msgs) {
		SendEvent oldSender = sender;
		sender = newSender;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this,
					Notification.SET, MultiviewPackage.MESSAGE__SENDER,
					oldSender, newSender);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setSender(SendEvent newSender) {
		if (newSender != sender) {
			NotificationChain msgs = null;
			if (sender != null)
				msgs = ((InternalEObject) sender).eInverseRemove(this,
						MultiviewPackage.SEND_EVENT__MESSAGE, SendEvent.class,
						msgs);
			if (newSender != null)
				msgs = ((InternalEObject) newSender).eInverseAdd(this,
						MultiviewPackage.SEND_EVENT__MESSAGE, SendEvent.class,
						msgs);
			msgs = basicSetSender(newSender, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					MultiviewPackage.MESSAGE__SENDER, newSender, newSender));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ReceiveEvent getReceiver() {
		if (receiver != null && receiver.eIsProxy()) {
			InternalEObject oldReceiver = (InternalEObject) receiver;
			receiver = (ReceiveEvent) eResolveProxy(oldReceiver);
			if (receiver != oldReceiver) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE,
							MultiviewPackage.MESSAGE__RECEIVER, oldReceiver,
							receiver));
			}
		}
		return receiver;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ReceiveEvent basicGetReceiver() {
		return receiver;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetReceiver(ReceiveEvent newReceiver,
			NotificationChain msgs) {
		ReceiveEvent oldReceiver = receiver;
		receiver = newReceiver;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this,
					Notification.SET, MultiviewPackage.MESSAGE__RECEIVER,
					oldReceiver, newReceiver);
			if (msgs == null)
				msgs = notification;
			else
				msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setReceiver(ReceiveEvent newReceiver) {
		if (newReceiver != receiver) {
			NotificationChain msgs = null;
			if (receiver != null)
				msgs = ((InternalEObject) receiver).eInverseRemove(this,
						MultiviewPackage.RECEIVE_EVENT__MESSAGE,
						ReceiveEvent.class, msgs);
			if (newReceiver != null)
				msgs = ((InternalEObject) newReceiver).eInverseAdd(this,
						MultiviewPackage.RECEIVE_EVENT__MESSAGE,
						ReceiveEvent.class, msgs);
			msgs = basicSetReceiver(newReceiver, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					MultiviewPackage.MESSAGE__RECEIVER, newReceiver,
					newReceiver));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Symbol getBody() {
		if (body != null && body.eIsProxy()) {
			InternalEObject oldBody = (InternalEObject) body;
			body = (Symbol) eResolveProxy(oldBody);
			if (body != oldBody) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE,
							MultiviewPackage.MESSAGE__BODY, oldBody, body));
			}
		}
		return body;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public Symbol basicGetBody() {
		return body;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setBody(Symbol newBody) {
		Symbol oldBody = body;
		body = newBody;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					MultiviewPackage.MESSAGE__BODY, oldBody, body));
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public SequenceView getSequenceView() {
		if (eContainerFeatureID() != MultiviewPackage.MESSAGE__SEQUENCE_VIEW)
			return null;
		return (SequenceView) eContainer();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public NotificationChain basicSetSequenceView(SequenceView newSequenceView,
			NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject) newSequenceView,
				MultiviewPackage.MESSAGE__SEQUENCE_VIEW, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setSequenceView(SequenceView newSequenceView) {
		if (newSequenceView != eInternalContainer()
				|| (eContainerFeatureID() != MultiviewPackage.MESSAGE__SEQUENCE_VIEW && newSequenceView != null)) {
			if (EcoreUtil.isAncestor(this, newSequenceView))
				throw new IllegalArgumentException(
						"Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSequenceView != null)
				msgs = ((InternalEObject) newSequenceView).eInverseAdd(this,
						MultiviewPackage.SEQUENCE_VIEW__MESSAGES,
						SequenceView.class, msgs);
			msgs = basicSetSequenceView(newSequenceView, msgs);
			if (msgs != null)
				msgs.dispatch();
		} else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET,
					MultiviewPackage.MESSAGE__SEQUENCE_VIEW, newSequenceView,
					newSequenceView));
	}

	/**
	 * <!-- begin-user-doc --> Returns the {@link Message}, which is sent
	 * previously} <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public Message getPrevious() {
		Message previous = null;
		EList<Message> orderedMessages = getSequenceView().getOrderedMessages();

		int pos = orderedMessages.indexOf(this);
		if (pos > 0) {
			previous = orderedMessages.get(pos - 1);
		}

		return previous;
	}

	/**
	 * <!-- begin-user-doc --> Returns the {@link Message}, which is sent
	 * previously} <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public Message getNext() {
		Message next = null;
		EList<Message> orderedMessages = getSequenceView().getOrderedMessages();

		int pos = orderedMessages.indexOf(this);
		if (pos < orderedMessages.size() - 1) {
			next = orderedMessages.get(pos + 1);
		}

		return next;
	}

	/**
	 * <!-- begin-user-doc --> Returns the position of the {@link Message}
	 * within the {@link SequenceView} <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public int getPosition() {
		EList<Message> orderedMessages = getSequenceView().getOrderedMessages();

		return orderedMessages.indexOf(this) + 1;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public String toString() {

		if (this != null && this.getBody() != null && this.getSender() != null
				&& this.getReceiver() != null
				&& this.getSender().getLifeline() != null
				&& this.getReceiver().getLifeline() != null
				&& this.getSender().getLifeline().getName() != null
				&& this.getReceiver().getLifeline().getName() != null) {
			return 
					this.getSender().getLifeline().getName() + " " + 					
					this.getBody().getName() + " "
					+ this.getReceiver().getLifeline().getName();
		}

		else {
			return super.toString();
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case MultiviewPackage.MESSAGE__SENDER:
			if (sender != null)
				msgs = ((InternalEObject) sender).eInverseRemove(this,
						MultiviewPackage.SEND_EVENT__MESSAGE, SendEvent.class,
						msgs);
			return basicSetSender((SendEvent) otherEnd, msgs);
		case MultiviewPackage.MESSAGE__RECEIVER:
			if (receiver != null)
				msgs = ((InternalEObject) receiver).eInverseRemove(this,
						MultiviewPackage.RECEIVE_EVENT__MESSAGE,
						ReceiveEvent.class, msgs);
			return basicSetReceiver((ReceiveEvent) otherEnd, msgs);
		case MultiviewPackage.MESSAGE__SEQUENCE_VIEW:
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			return basicSetSequenceView((SequenceView) otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case MultiviewPackage.MESSAGE__SENDER:
			return basicSetSender(null, msgs);
		case MultiviewPackage.MESSAGE__RECEIVER:
			return basicSetReceiver(null, msgs);
		case MultiviewPackage.MESSAGE__SEQUENCE_VIEW:
			return basicSetSequenceView(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(
			NotificationChain msgs) {
		switch (eContainerFeatureID()) {
		case MultiviewPackage.MESSAGE__SEQUENCE_VIEW:
			return eInternalContainer().eInverseRemove(this,
					MultiviewPackage.SEQUENCE_VIEW__MESSAGES,
					SequenceView.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case MultiviewPackage.MESSAGE__SENDER:
			if (resolve)
				return getSender();
			return basicGetSender();
		case MultiviewPackage.MESSAGE__RECEIVER:
			if (resolve)
				return getReceiver();
			return basicGetReceiver();
		case MultiviewPackage.MESSAGE__BODY:
			if (resolve)
				return getBody();
			return basicGetBody();
		case MultiviewPackage.MESSAGE__SEQUENCE_VIEW:
			return getSequenceView();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case MultiviewPackage.MESSAGE__SENDER:
			setSender((SendEvent) newValue);
			return;
		case MultiviewPackage.MESSAGE__RECEIVER:
			setReceiver((ReceiveEvent) newValue);
			return;
		case MultiviewPackage.MESSAGE__BODY:
			setBody((Symbol) newValue);
			return;
		case MultiviewPackage.MESSAGE__SEQUENCE_VIEW:
			setSequenceView((SequenceView) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case MultiviewPackage.MESSAGE__SENDER:
			setSender((SendEvent) null);
			return;
		case MultiviewPackage.MESSAGE__RECEIVER:
			setReceiver((ReceiveEvent) null);
			return;
		case MultiviewPackage.MESSAGE__BODY:
			setBody((Symbol) null);
			return;
		case MultiviewPackage.MESSAGE__SEQUENCE_VIEW:
			setSequenceView((SequenceView) null);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case MultiviewPackage.MESSAGE__SENDER:
			return sender != null;
		case MultiviewPackage.MESSAGE__RECEIVER:
			return receiver != null;
		case MultiviewPackage.MESSAGE__BODY:
			return body != null;
		case MultiviewPackage.MESSAGE__SEQUENCE_VIEW:
			return getSequenceView() != null;
		}
		return super.eIsSet(featureID);
	}

} // MessageImpl
