/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.modelevolution.multiview.MultipleOperandCF;
import org.modelevolution.multiview.MultipleOperandType;
import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.Operand;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Multiple Operand CF</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.modelevolution.multiview.impl.MultipleOperandCFImpl#getOperands <em>Operands</em>}</li>
 *   <li>{@link org.modelevolution.multiview.impl.MultipleOperandCFImpl#getOperandType <em>Operand Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class MultipleOperandCFImpl extends CombinedFragmentImpl implements MultipleOperandCF {
	/**
	 * The cached value of the '{@link #getOperands() <em>Operands</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperands()
	 * @generated
	 * @ordered
	 */
	protected EList<Operand> operands;

	/**
	 * The default value of the '{@link #getOperandType() <em>Operand Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperandType()
	 * @generated
	 * @ordered
	 */
	protected static final MultipleOperandType OPERAND_TYPE_EDEFAULT = MultipleOperandType.STRICT;

	/**
	 * The cached value of the '{@link #getOperandType() <em>Operand Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperandType()
	 * @generated
	 * @ordered
	 */
	protected MultipleOperandType operandType = OPERAND_TYPE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultipleOperandCFImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return MultiviewPackage.Literals.MULTIPLE_OPERAND_CF;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Operand> getOperands() {
		if (operands == null) {
			operands = new EObjectContainmentEList<Operand>(Operand.class, this, MultiviewPackage.MULTIPLE_OPERAND_CF__OPERANDS);
		}
		return operands;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MultipleOperandType getOperandType() {
		return operandType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperandType(MultipleOperandType newOperandType) {
		MultipleOperandType oldOperandType = operandType;
		operandType = newOperandType == null ? OPERAND_TYPE_EDEFAULT : newOperandType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MultiviewPackage.MULTIPLE_OPERAND_CF__OPERAND_TYPE, oldOperandType, operandType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case MultiviewPackage.MULTIPLE_OPERAND_CF__OPERANDS:
				return ((InternalEList<?>)getOperands()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case MultiviewPackage.MULTIPLE_OPERAND_CF__OPERANDS:
				return getOperands();
			case MultiviewPackage.MULTIPLE_OPERAND_CF__OPERAND_TYPE:
				return getOperandType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case MultiviewPackage.MULTIPLE_OPERAND_CF__OPERANDS:
				getOperands().clear();
				getOperands().addAll((Collection<? extends Operand>)newValue);
				return;
			case MultiviewPackage.MULTIPLE_OPERAND_CF__OPERAND_TYPE:
				setOperandType((MultipleOperandType)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case MultiviewPackage.MULTIPLE_OPERAND_CF__OPERANDS:
				getOperands().clear();
				return;
			case MultiviewPackage.MULTIPLE_OPERAND_CF__OPERAND_TYPE:
				setOperandType(OPERAND_TYPE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case MultiviewPackage.MULTIPLE_OPERAND_CF__OPERANDS:
				return operands != null && !operands.isEmpty();
			case MultiviewPackage.MULTIPLE_OPERAND_CF__OPERAND_TYPE:
				return operandType != OPERAND_TYPE_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (operandType: ");
		result.append(operandType);
		result.append(')');
		return result.toString();
	}

} //MultipleOperandCFImpl
