/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.modelevolution.multiview.ClassView;
import org.modelevolution.multiview.Guard;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultipleOperandCF;
import org.modelevolution.multiview.MultipleOperandType;
import org.modelevolution.multiview.MultiviewFactory;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.NamedElement;
import org.modelevolution.multiview.OneOperandCF;
import org.modelevolution.multiview.OneOperandType;
import org.modelevolution.multiview.Operand;
import org.modelevolution.multiview.Operation;
import org.modelevolution.multiview.ReceiveEvent;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.SendEvent;
import org.modelevolution.multiview.SequenceView;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.StateCondition;
import org.modelevolution.multiview.StateView;
import org.modelevolution.multiview.Symbol;
import org.modelevolution.multiview.Transition;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class MultiviewFactoryImpl extends EFactoryImpl implements MultiviewFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static MultiviewFactory init() {
		try {
			MultiviewFactory theMultiviewFactory = (MultiviewFactory)EPackage.Registry.INSTANCE.getEFactory("http://modelevolution.org/multiview/1.0"); 
			if (theMultiviewFactory != null) {
				return theMultiviewFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new MultiviewFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MultiviewFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case MultiviewPackage.NAMED_ELEMENT: return createNamedElement();
			case MultiviewPackage.REGION: return createRegion();
			case MultiviewPackage.STATE: return createState();
			case MultiviewPackage.SYMBOL: return createSymbol();
			case MultiviewPackage.TRANSITION: return createTransition();
			case MultiviewPackage.MULTIVIEW_MODEL: return createMultiviewModel();
			case MultiviewPackage.CLASS: return createClass();
			case MultiviewPackage.OPERATION: return createOperation();
			case MultiviewPackage.CLASS_VIEW: return createClassView();
			case MultiviewPackage.STATE_VIEW: return createStateView();
			case MultiviewPackage.SEQUENCE_VIEW: return createSequenceView();
			case MultiviewPackage.GUARD: return createGuard();
			case MultiviewPackage.LIFELINE: return createLifeline();
			case MultiviewPackage.SEND_EVENT: return createSendEvent();
			case MultiviewPackage.RECEIVE_EVENT: return createReceiveEvent();
			case MultiviewPackage.MESSAGE: return createMessage();
			case MultiviewPackage.ONE_OPERAND_CF: return createOneOperandCF();
			case MultiviewPackage.MULTIPLE_OPERAND_CF: return createMultipleOperandCF();
			case MultiviewPackage.OPERAND: return createOperand();
			case MultiviewPackage.STATE_CONDITION: return createStateCondition();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case MultiviewPackage.ONE_OPERAND_TYPE:
				return createOneOperandTypeFromString(eDataType, initialValue);
			case MultiviewPackage.MULTIPLE_OPERAND_TYPE:
				return createMultipleOperandTypeFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case MultiviewPackage.ONE_OPERAND_TYPE:
				return convertOneOperandTypeToString(eDataType, instanceValue);
			case MultiviewPackage.MULTIPLE_OPERAND_TYPE:
				return convertMultipleOperandTypeToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NamedElement createNamedElement() {
		NamedElementImpl namedElement = new NamedElementImpl();
		return namedElement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Region createRegion() {
		RegionImpl region = new RegionImpl();
		return region;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public State createState() {
		StateImpl state = new StateImpl();
		return state;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Symbol createSymbol() {
		SymbolImpl symbol = new SymbolImpl();
		return symbol;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Transition createTransition() {
		TransitionImpl transition = new TransitionImpl();
		return transition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MultiviewModel createMultiviewModel() {
		MultiviewModelImpl multiviewModel = new MultiviewModelImpl();
		return multiviewModel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public org.modelevolution.multiview.Class createClass() {
		ClassImpl class_ = new ClassImpl();
		return class_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Operation createOperation() {
		OperationImpl operation = new OperationImpl();
		return operation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ClassView createClassView() {
		ClassViewImpl classView = new ClassViewImpl();
		return classView;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StateView createStateView() {
		StateViewImpl stateView = new StateViewImpl();
		return stateView;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SequenceView createSequenceView() {
		SequenceViewImpl sequenceView = new SequenceViewImpl();
		return sequenceView;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Guard createGuard() {
		GuardImpl guard = new GuardImpl();
		return guard;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Lifeline createLifeline() {
		LifelineImpl lifeline = new LifelineImpl();
		return lifeline;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SendEvent createSendEvent() {
		SendEventImpl sendEvent = new SendEventImpl();
		return sendEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ReceiveEvent createReceiveEvent() {
		ReceiveEventImpl receiveEvent = new ReceiveEventImpl();
		return receiveEvent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Message createMessage() {
		MessageImpl message = new MessageImpl();
		return message;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OneOperandCF createOneOperandCF() {
		OneOperandCFImpl oneOperandCF = new OneOperandCFImpl();
		return oneOperandCF;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MultipleOperandCF createMultipleOperandCF() {
		MultipleOperandCFImpl multipleOperandCF = new MultipleOperandCFImpl();
		return multipleOperandCF;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Operand createOperand() {
		OperandImpl operand = new OperandImpl();
		return operand;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StateCondition createStateCondition() {
		StateConditionImpl stateCondition = new StateConditionImpl();
		return stateCondition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OneOperandType createOneOperandTypeFromString(EDataType eDataType, String initialValue) {
		OneOperandType result = OneOperandType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertOneOperandTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MultipleOperandType createMultipleOperandTypeFromString(EDataType eDataType, String initialValue) {
		MultipleOperandType result = MultipleOperandType.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertMultipleOperandTypeToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MultiviewPackage getMultiviewPackage() {
		return (MultiviewPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static MultiviewPackage getPackage() {
		return MultiviewPackage.eINSTANCE;
	}

} //MultiviewFactoryImpl
