/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.modelevolution.multiview.ClassView;
import org.modelevolution.multiview.MultiviewModel;
import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.SequenceView;
import org.modelevolution.multiview.StateView;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Model</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.modelevolution.multiview.impl.MultiviewModelImpl#getClassview <em>Classview</em>}</li>
 *   <li>{@link org.modelevolution.multiview.impl.MultiviewModelImpl#getStateview <em>Stateview</em>}</li>
 *   <li>{@link org.modelevolution.multiview.impl.MultiviewModelImpl#getSequenceview <em>Sequenceview</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class MultiviewModelImpl extends NamedElementImpl implements MultiviewModel {
	/**
	 * The cached value of the '{@link #getClassview() <em>Classview</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClassview()
	 * @generated
	 * @ordered
	 */
	protected ClassView classview;

	/**
	 * The cached value of the '{@link #getStateview() <em>Stateview</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStateview()
	 * @generated
	 * @ordered
	 */
	protected StateView stateview;

	/**
	 * The cached value of the '{@link #getSequenceview() <em>Sequenceview</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSequenceview()
	 * @generated
	 * @ordered
	 */
	protected SequenceView sequenceview;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MultiviewModelImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return MultiviewPackage.Literals.MULTIVIEW_MODEL;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ClassView getClassview() {
		return classview;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetClassview(ClassView newClassview, NotificationChain msgs) {
		ClassView oldClassview = classview;
		classview = newClassview;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MultiviewPackage.MULTIVIEW_MODEL__CLASSVIEW, oldClassview, newClassview);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setClassview(ClassView newClassview) {
		if (newClassview != classview) {
			NotificationChain msgs = null;
			if (classview != null)
				msgs = ((InternalEObject)classview).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - MultiviewPackage.MULTIVIEW_MODEL__CLASSVIEW, null, msgs);
			if (newClassview != null)
				msgs = ((InternalEObject)newClassview).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - MultiviewPackage.MULTIVIEW_MODEL__CLASSVIEW, null, msgs);
			msgs = basicSetClassview(newClassview, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MultiviewPackage.MULTIVIEW_MODEL__CLASSVIEW, newClassview, newClassview));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StateView getStateview() {
		return stateview;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetStateview(StateView newStateview, NotificationChain msgs) {
		StateView oldStateview = stateview;
		stateview = newStateview;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MultiviewPackage.MULTIVIEW_MODEL__STATEVIEW, oldStateview, newStateview);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStateview(StateView newStateview) {
		if (newStateview != stateview) {
			NotificationChain msgs = null;
			if (stateview != null)
				msgs = ((InternalEObject)stateview).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - MultiviewPackage.MULTIVIEW_MODEL__STATEVIEW, null, msgs);
			if (newStateview != null)
				msgs = ((InternalEObject)newStateview).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - MultiviewPackage.MULTIVIEW_MODEL__STATEVIEW, null, msgs);
			msgs = basicSetStateview(newStateview, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MultiviewPackage.MULTIVIEW_MODEL__STATEVIEW, newStateview, newStateview));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SequenceView getSequenceview() {
		return sequenceview;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSequenceview(SequenceView newSequenceview, NotificationChain msgs) {
		SequenceView oldSequenceview = sequenceview;
		sequenceview = newSequenceview;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MultiviewPackage.MULTIVIEW_MODEL__SEQUENCEVIEW, oldSequenceview, newSequenceview);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSequenceview(SequenceView newSequenceview) {
		if (newSequenceview != sequenceview) {
			NotificationChain msgs = null;
			if (sequenceview != null)
				msgs = ((InternalEObject)sequenceview).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - MultiviewPackage.MULTIVIEW_MODEL__SEQUENCEVIEW, null, msgs);
			if (newSequenceview != null)
				msgs = ((InternalEObject)newSequenceview).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - MultiviewPackage.MULTIVIEW_MODEL__SEQUENCEVIEW, null, msgs);
			msgs = basicSetSequenceview(newSequenceview, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MultiviewPackage.MULTIVIEW_MODEL__SEQUENCEVIEW, newSequenceview, newSequenceview));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case MultiviewPackage.MULTIVIEW_MODEL__CLASSVIEW:
				return basicSetClassview(null, msgs);
			case MultiviewPackage.MULTIVIEW_MODEL__STATEVIEW:
				return basicSetStateview(null, msgs);
			case MultiviewPackage.MULTIVIEW_MODEL__SEQUENCEVIEW:
				return basicSetSequenceview(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case MultiviewPackage.MULTIVIEW_MODEL__CLASSVIEW:
				return getClassview();
			case MultiviewPackage.MULTIVIEW_MODEL__STATEVIEW:
				return getStateview();
			case MultiviewPackage.MULTIVIEW_MODEL__SEQUENCEVIEW:
				return getSequenceview();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case MultiviewPackage.MULTIVIEW_MODEL__CLASSVIEW:
				setClassview((ClassView)newValue);
				return;
			case MultiviewPackage.MULTIVIEW_MODEL__STATEVIEW:
				setStateview((StateView)newValue);
				return;
			case MultiviewPackage.MULTIVIEW_MODEL__SEQUENCEVIEW:
				setSequenceview((SequenceView)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case MultiviewPackage.MULTIVIEW_MODEL__CLASSVIEW:
				setClassview((ClassView)null);
				return;
			case MultiviewPackage.MULTIVIEW_MODEL__STATEVIEW:
				setStateview((StateView)null);
				return;
			case MultiviewPackage.MULTIVIEW_MODEL__SEQUENCEVIEW:
				setSequenceview((SequenceView)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case MultiviewPackage.MULTIVIEW_MODEL__CLASSVIEW:
				return classview != null;
			case MultiviewPackage.MULTIVIEW_MODEL__STATEVIEW:
				return stateview != null;
			case MultiviewPackage.MULTIVIEW_MODEL__SEQUENCEVIEW:
				return sequenceview != null;
		}
		return super.eIsSet(featureID);
	}

} //MultiviewModelImpl
