/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.OneOperandCF;
import org.modelevolution.multiview.OneOperandType;
import org.modelevolution.multiview.Operand;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>One Operand CF</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.modelevolution.multiview.impl.OneOperandCFImpl#getOperand <em>Operand</em>}</li>
 *   <li>{@link org.modelevolution.multiview.impl.OneOperandCFImpl#getOperandType <em>Operand Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class OneOperandCFImpl extends CombinedFragmentImpl implements OneOperandCF {
	/**
	 * The cached value of the '{@link #getOperand() <em>Operand</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperand()
	 * @generated
	 * @ordered
	 */
	protected Operand operand;

	/**
	 * The default value of the '{@link #getOperandType() <em>Operand Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperandType()
	 * @generated
	 * @ordered
	 */
	protected static final OneOperandType OPERAND_TYPE_EDEFAULT = OneOperandType.OPT;

	/**
	 * The cached value of the '{@link #getOperandType() <em>Operand Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOperandType()
	 * @generated
	 * @ordered
	 */
	protected OneOperandType operandType = OPERAND_TYPE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OneOperandCFImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return MultiviewPackage.Literals.ONE_OPERAND_CF;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Operand getOperand() {
		return operand;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetOperand(Operand newOperand, NotificationChain msgs) {
		Operand oldOperand = operand;
		operand = newOperand;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MultiviewPackage.ONE_OPERAND_CF__OPERAND, oldOperand, newOperand);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperand(Operand newOperand) {
		if (newOperand != operand) {
			NotificationChain msgs = null;
			if (operand != null)
				msgs = ((InternalEObject)operand).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - MultiviewPackage.ONE_OPERAND_CF__OPERAND, null, msgs);
			if (newOperand != null)
				msgs = ((InternalEObject)newOperand).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - MultiviewPackage.ONE_OPERAND_CF__OPERAND, null, msgs);
			msgs = basicSetOperand(newOperand, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MultiviewPackage.ONE_OPERAND_CF__OPERAND, newOperand, newOperand));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public OneOperandType getOperandType() {
		return operandType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOperandType(OneOperandType newOperandType) {
		OneOperandType oldOperandType = operandType;
		operandType = newOperandType == null ? OPERAND_TYPE_EDEFAULT : newOperandType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MultiviewPackage.ONE_OPERAND_CF__OPERAND_TYPE, oldOperandType, operandType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case MultiviewPackage.ONE_OPERAND_CF__OPERAND:
				return basicSetOperand(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case MultiviewPackage.ONE_OPERAND_CF__OPERAND:
				return getOperand();
			case MultiviewPackage.ONE_OPERAND_CF__OPERAND_TYPE:
				return getOperandType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case MultiviewPackage.ONE_OPERAND_CF__OPERAND:
				setOperand((Operand)newValue);
				return;
			case MultiviewPackage.ONE_OPERAND_CF__OPERAND_TYPE:
				setOperandType((OneOperandType)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case MultiviewPackage.ONE_OPERAND_CF__OPERAND:
				setOperand((Operand)null);
				return;
			case MultiviewPackage.ONE_OPERAND_CF__OPERAND_TYPE:
				setOperandType(OPERAND_TYPE_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case MultiviewPackage.ONE_OPERAND_CF__OPERAND:
				return operand != null;
			case MultiviewPackage.ONE_OPERAND_CF__OPERAND_TYPE:
				return operandType != OPERAND_TYPE_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (operandType: ");
		result.append(operandType);
		result.append(')');
		return result.toString();
	}

} //OneOperandCFImpl
