/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.Region;
import org.modelevolution.multiview.State;
import org.modelevolution.multiview.Transition;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Region</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.modelevolution.multiview.impl.RegionImpl#getStates <em>States</em>}</li>
 *   <li>{@link org.modelevolution.multiview.impl.RegionImpl#getInitialTransition <em>Initial Transition</em>}</li>
 *   <li>{@link org.modelevolution.multiview.impl.RegionImpl#getClass_ <em>Class</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class RegionImpl extends NamedElementImpl implements Region {
	/**
	 * The cached value of the '{@link #getStates() <em>States</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getStates()
	 * @generated
	 * @ordered
	 */
	protected EList<State> states;

	/**
	 * The cached value of the '{@link #getInitialTransition() <em>Initial Transition</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInitialTransition()
	 * @generated
	 * @ordered
	 */
	protected Transition initialTransition;

	/**
	 * The cached value of the '{@link #getClass_() <em>Class</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClass_()
	 * @generated
	 * @ordered
	 */
	protected org.modelevolution.multiview.Class class_;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RegionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return MultiviewPackage.Literals.REGION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<State> getStates() {
		if (states == null) {
			states = new EObjectContainmentEList<State>(State.class, this, MultiviewPackage.REGION__STATES);
		}
		return states;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Transition getInitialTransition() {
		return initialTransition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInitialTransition(Transition newInitialTransition, NotificationChain msgs) {
		Transition oldInitialTransition = initialTransition;
		initialTransition = newInitialTransition;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MultiviewPackage.REGION__INITIAL_TRANSITION, oldInitialTransition, newInitialTransition);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInitialTransition(Transition newInitialTransition) {
		if (newInitialTransition != initialTransition) {
			NotificationChain msgs = null;
			if (initialTransition != null)
				msgs = ((InternalEObject)initialTransition).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - MultiviewPackage.REGION__INITIAL_TRANSITION, null, msgs);
			if (newInitialTransition != null)
				msgs = ((InternalEObject)newInitialTransition).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - MultiviewPackage.REGION__INITIAL_TRANSITION, null, msgs);
			msgs = basicSetInitialTransition(newInitialTransition, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MultiviewPackage.REGION__INITIAL_TRANSITION, newInitialTransition, newInitialTransition));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public org.modelevolution.multiview.Class getClass_() {
		if (class_ != null && class_.eIsProxy()) {
			InternalEObject oldClass = (InternalEObject)class_;
			class_ = (org.modelevolution.multiview.Class)eResolveProxy(oldClass);
			if (class_ != oldClass) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, MultiviewPackage.REGION__CLASS, oldClass, class_));
			}
		}
		return class_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public org.modelevolution.multiview.Class basicGetClass() {
		return class_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetClass(org.modelevolution.multiview.Class newClass, NotificationChain msgs) {
		org.modelevolution.multiview.Class oldClass = class_;
		class_ = newClass;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, MultiviewPackage.REGION__CLASS, oldClass, newClass);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setClass(org.modelevolution.multiview.Class newClass) {
		if (newClass != class_) {
			NotificationChain msgs = null;
			if (class_ != null)
				msgs = ((InternalEObject)class_).eInverseRemove(this, MultiviewPackage.CLASS__STATEMACHINE, org.modelevolution.multiview.Class.class, msgs);
			if (newClass != null)
				msgs = ((InternalEObject)newClass).eInverseAdd(this, MultiviewPackage.CLASS__STATEMACHINE, org.modelevolution.multiview.Class.class, msgs);
			msgs = basicSetClass(newClass, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, MultiviewPackage.REGION__CLASS, newClass, newClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case MultiviewPackage.REGION__CLASS:
				if (class_ != null)
					msgs = ((InternalEObject)class_).eInverseRemove(this, MultiviewPackage.CLASS__STATEMACHINE, org.modelevolution.multiview.Class.class, msgs);
				return basicSetClass((org.modelevolution.multiview.Class)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case MultiviewPackage.REGION__STATES:
				return ((InternalEList<?>)getStates()).basicRemove(otherEnd, msgs);
			case MultiviewPackage.REGION__INITIAL_TRANSITION:
				return basicSetInitialTransition(null, msgs);
			case MultiviewPackage.REGION__CLASS:
				return basicSetClass(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case MultiviewPackage.REGION__STATES:
				return getStates();
			case MultiviewPackage.REGION__INITIAL_TRANSITION:
				return getInitialTransition();
			case MultiviewPackage.REGION__CLASS:
				if (resolve) return getClass_();
				return basicGetClass();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case MultiviewPackage.REGION__STATES:
				getStates().clear();
				getStates().addAll((Collection<? extends State>)newValue);
				return;
			case MultiviewPackage.REGION__INITIAL_TRANSITION:
				setInitialTransition((Transition)newValue);
				return;
			case MultiviewPackage.REGION__CLASS:
				setClass((org.modelevolution.multiview.Class)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case MultiviewPackage.REGION__STATES:
				getStates().clear();
				return;
			case MultiviewPackage.REGION__INITIAL_TRANSITION:
				setInitialTransition((Transition)null);
				return;
			case MultiviewPackage.REGION__CLASS:
				setClass((org.modelevolution.multiview.Class)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case MultiviewPackage.REGION__STATES:
				return states != null && !states.isEmpty();
			case MultiviewPackage.REGION__INITIAL_TRANSITION:
				return initialTransition != null;
			case MultiviewPackage.REGION__CLASS:
				return class_ != null;
		}
		return super.eIsSet(featureID);
	}

} //RegionImpl
