/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.modelevolution.multiview.CombinedFragment;
import org.modelevolution.multiview.Lifeline;
import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.SequenceView;
import org.modelevolution.multiview.util.BubbleSorter;
import org.modelevolution.multiview.util.MessageComparator;

/**
 * <!-- begin-user-doc --> An implementation of the model object '
 * <em><b>Sequence View</b></em>'. <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 * <li>{@link org.modelevolution.multiview.impl.SequenceViewImpl#getLifelines
 * <em>Lifelines</em>}</li>
 * <li>{@link org.modelevolution.multiview.impl.SequenceViewImpl#getFragments
 * <em>Fragments</em>}</li>
 * <li>{@link org.modelevolution.multiview.impl.SequenceViewImpl#getMessages
 * <em>Messages</em>}</li>
 * </ul>
 * </p>
 * 
 * @generated
 */
public class SequenceViewImpl extends NamedElementImpl implements SequenceView {
	/**
	 * The cached value of the '{@link #getLifelines() <em>Lifelines</em>}'
	 * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getLifelines()
	 * @generated
	 * @ordered
	 */
	protected EList<Lifeline> lifelines;

	/**
	 * The cached value of the '{@link #getFragments() <em>Fragments</em>}'
	 * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getFragments()
	 * @generated
	 * @ordered
	 */
	protected EList<CombinedFragment> fragments;

	/**
	 * The cached value of the '{@link #getMessages() <em>Messages</em>}'
	 * containment reference list. <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @see #getMessages()
	 * @generated
	 * @ordered
	 */
	protected EList<Message> messages;

	/**
	 * The cached value of the '{@link #getOrderedMessages()
	 * <em>OrderedMessages</em}' reference list.
	 * 
	 * @see #getOrderedMessages()
	 * @generated NOT
	 */
	protected EList<Message> orderedMessages = new BasicEList<Message>();

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected SequenceViewImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return MultiviewPackage.Literals.SEQUENCE_VIEW;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<Lifeline> getLifelines() {
		if (lifelines == null) {
			lifelines = new EObjectContainmentWithInverseEList<Lifeline>(
					Lifeline.class, this,
					MultiviewPackage.SEQUENCE_VIEW__LIFELINES,
					MultiviewPackage.LIFELINE__SEQUENCE_VIEW);
		}
		return lifelines;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<CombinedFragment> getFragments() {
		if (fragments == null) {
			fragments = new EObjectContainmentEList<CombinedFragment>(
					CombinedFragment.class, this,
					MultiviewPackage.SEQUENCE_VIEW__FRAGMENTS);
		}
		return fragments;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public EList<Message> getMessages() {
		if (messages == null) {
			messages = new EObjectContainmentWithInverseEList<Message>(
					Message.class, this,
					MultiviewPackage.SEQUENCE_VIEW__MESSAGES,
					MultiviewPackage.MESSAGE__SEQUENCE_VIEW);
		}
		return messages;
	}

	/**
	 * <!-- begin-user-doc --> Determines whether {@link Message}
	 * <code>msg1</code> is sent before <code>msg2</code>. <!-- end-user-doc -->
	 * 
	 * @param msg1
	 *            the {@link Message} which is checked to be sent first
	 * @param msg2
	 *            the {@link Message} which is checked to be sent afterwards
	 * @return true if <code>msg1</code> is sent before <code>msg2</code>
	 * @generated NOT
	 */
	public boolean isSentBefore(Message msg1, Message msg2) {

		boolean isSentBefore = false;

		Lifeline ll_msg1_send = msg1.getSender() != null ? (Lifeline) msg1
				.getSender().getLifeline() : null;

		Lifeline ll_msg1_rec = msg1.getReceiver() != null ? (Lifeline) msg1
				.getReceiver().getLifeline() : null;

		Lifeline ll_msg2_send = msg2.getSender() != null ? (Lifeline) msg2
				.getSender().getLifeline() : null;

		Lifeline ll_msg2_rec = msg2.getReceiver() != null ? (Lifeline) msg2
				.getReceiver().getLifeline() : null;

		if (ll_msg1_send != null && ll_msg2_send != null
				&& ll_msg1_send.equals(ll_msg2_send)) {

			isSentBefore = (ll_msg1_send.getElements()
					.indexOf(msg1.getSender()) < ll_msg1_send.getElements()
					.indexOf(msg2.getSender())) ? true : false;

		} else if (ll_msg1_send != null && ll_msg2_rec != null
				&& ll_msg1_send.equals(ll_msg2_rec)) {

			isSentBefore = (ll_msg1_send.getElements()
					.indexOf(msg1.getSender()) < ll_msg1_send.getElements()
					.indexOf(msg2.getReceiver())) ? true : false;

		} else if (ll_msg1_rec != null && ll_msg2_send != null
				&& ll_msg1_rec.equals(ll_msg2_send)) {

			isSentBefore = (ll_msg1_rec.getElements().indexOf(
					msg1.getReceiver()) < ll_msg1_rec.getElements().indexOf(
					msg2.getSender())) ? true : false;

		} else if (ll_msg1_rec != null && ll_msg2_rec != null
				&& ll_msg1_rec.equals(ll_msg2_rec)) {

			isSentBefore = (ll_msg1_rec.getElements().indexOf(
					msg1.getReceiver()) < ll_msg1_rec.getElements().indexOf(
					msg2.getReceiver())) ? true : false;
		} 
		else {
			isSentBefore = ((ll_msg1_send.getSequenceView().getLifelines()
					.indexOf(ll_msg1_send)) < (ll_msg1_send.getSequenceView()
					.getLifelines().indexOf(ll_msg2_send))) ? true : false;
		}
		return isSentBefore;
	}

	/**
	 * <!-- begin-user-doc --> Returns the {@link Message}s of this
	 * {@link SequenceView} in an absolute order. <!-- end-user-doc -->
	 * 
	 * @generated NOT
	 */
	public EList<Message> getOrderedMessages() {
		if (orderedMessages.isEmpty() || eResource().isModified()) {
			orderedMessages.addAll(getMessages());
			BubbleSorter.sort(orderedMessages, new MessageComparator());
		}
		return orderedMessages;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case MultiviewPackage.SEQUENCE_VIEW__LIFELINES:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getLifelines())
					.basicAdd(otherEnd, msgs);
		case MultiviewPackage.SEQUENCE_VIEW__MESSAGES:
			return ((InternalEList<InternalEObject>) (InternalEList<?>) getMessages())
					.basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd,
			int featureID, NotificationChain msgs) {
		switch (featureID) {
		case MultiviewPackage.SEQUENCE_VIEW__LIFELINES:
			return ((InternalEList<?>) getLifelines()).basicRemove(otherEnd,
					msgs);
		case MultiviewPackage.SEQUENCE_VIEW__FRAGMENTS:
			return ((InternalEList<?>) getFragments()).basicRemove(otherEnd,
					msgs);
		case MultiviewPackage.SEQUENCE_VIEW__MESSAGES:
			return ((InternalEList<?>) getMessages()).basicRemove(otherEnd,
					msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case MultiviewPackage.SEQUENCE_VIEW__LIFELINES:
			return getLifelines();
		case MultiviewPackage.SEQUENCE_VIEW__FRAGMENTS:
			return getFragments();
		case MultiviewPackage.SEQUENCE_VIEW__MESSAGES:
			return getMessages();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case MultiviewPackage.SEQUENCE_VIEW__LIFELINES:
			getLifelines().clear();
			getLifelines().addAll((Collection<? extends Lifeline>) newValue);
			return;
		case MultiviewPackage.SEQUENCE_VIEW__FRAGMENTS:
			getFragments().clear();
			getFragments().addAll(
					(Collection<? extends CombinedFragment>) newValue);
			return;
		case MultiviewPackage.SEQUENCE_VIEW__MESSAGES:
			getMessages().clear();
			getMessages().addAll((Collection<? extends Message>) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case MultiviewPackage.SEQUENCE_VIEW__LIFELINES:
			getLifelines().clear();
			return;
		case MultiviewPackage.SEQUENCE_VIEW__FRAGMENTS:
			getFragments().clear();
			return;
		case MultiviewPackage.SEQUENCE_VIEW__MESSAGES:
			getMessages().clear();
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case MultiviewPackage.SEQUENCE_VIEW__LIFELINES:
			return lifelines != null && !lifelines.isEmpty();
		case MultiviewPackage.SEQUENCE_VIEW__FRAGMENTS:
			return fragments != null && !fragments.isEmpty();
		case MultiviewPackage.SEQUENCE_VIEW__MESSAGES:
			return messages != null && !messages.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} // SequenceViewImpl
