/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.modelevolution.multiview.MultiviewPackage;
import org.modelevolution.multiview.Symbol;
import org.modelevolution.multiview.Transition;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Symbol</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.modelevolution.multiview.impl.SymbolImpl#getTriggers <em>Triggers</em>}</li>
 *   <li>{@link org.modelevolution.multiview.impl.SymbolImpl#getIsTriggeredBy <em>Is Triggered By</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SymbolImpl extends NamedElementImpl implements Symbol {
	/**
	 * The cached value of the '{@link #getTriggers() <em>Triggers</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTriggers()
	 * @generated
	 * @ordered
	 */
	protected EList<Transition> triggers;

	/**
	 * The cached value of the '{@link #getIsTriggeredBy() <em>Is Triggered By</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIsTriggeredBy()
	 * @generated
	 * @ordered
	 */
	protected EList<Transition> isTriggeredBy;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SymbolImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return MultiviewPackage.Literals.SYMBOL;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Transition> getTriggers() {
		if (triggers == null) {
			triggers = new EObjectWithInverseResolvingEList<Transition>(Transition.class, this, MultiviewPackage.SYMBOL__TRIGGERS, MultiviewPackage.TRANSITION__TRIGGER);
		}
		return triggers;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Transition> getIsTriggeredBy() {
		if (isTriggeredBy == null) {
			isTriggeredBy = new EObjectWithInverseResolvingEList.ManyInverse<Transition>(Transition.class, this, MultiviewPackage.SYMBOL__IS_TRIGGERED_BY, MultiviewPackage.TRANSITION__EFFECTS);
		}
		return isTriggeredBy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case MultiviewPackage.SYMBOL__TRIGGERS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getTriggers()).basicAdd(otherEnd, msgs);
			case MultiviewPackage.SYMBOL__IS_TRIGGERED_BY:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getIsTriggeredBy()).basicAdd(otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case MultiviewPackage.SYMBOL__TRIGGERS:
				return ((InternalEList<?>)getTriggers()).basicRemove(otherEnd, msgs);
			case MultiviewPackage.SYMBOL__IS_TRIGGERED_BY:
				return ((InternalEList<?>)getIsTriggeredBy()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case MultiviewPackage.SYMBOL__TRIGGERS:
				return getTriggers();
			case MultiviewPackage.SYMBOL__IS_TRIGGERED_BY:
				return getIsTriggeredBy();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case MultiviewPackage.SYMBOL__TRIGGERS:
				getTriggers().clear();
				getTriggers().addAll((Collection<? extends Transition>)newValue);
				return;
			case MultiviewPackage.SYMBOL__IS_TRIGGERED_BY:
				getIsTriggeredBy().clear();
				getIsTriggeredBy().addAll((Collection<? extends Transition>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case MultiviewPackage.SYMBOL__TRIGGERS:
				getTriggers().clear();
				return;
			case MultiviewPackage.SYMBOL__IS_TRIGGERED_BY:
				getIsTriggeredBy().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case MultiviewPackage.SYMBOL__TRIGGERS:
				return triggers != null && !triggers.isEmpty();
			case MultiviewPackage.SYMBOL__IS_TRIGGERED_BY:
				return isTriggeredBy != null && !isTriggeredBy.isEmpty();
		}
		return super.eIsSet(featureID);
	}

} //SymbolImpl
