/**
 * <copyright>
 *
 * Copyright (c) 2011 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/**
 * @author <a href="mailto:brosch@big.tuwien.ac.at">Petra Brosch</a>
 * 
 */
public class BubbleSorter {
	
	public BubbleSorter() {
		
	}

	/**
	 * Performs a Bubble Sort on the given {@link List} <code>list</code> using the given 
	 * {@link Comparator} <code>c</code>.
	 * @param list
	 * 		The {@link List} to sort.
	 * @param c
	 * 		The {@link Comparator} to use.
	 */
	public static <T> void sort(List<T> list, Comparator<T> c) {

		int n = list.size();
		boolean swapped = false;

		do {
			swapped = false;
			for (int i = 0; i < n - 1; i++) {
				T t1 = list.get(i);
				T t2 = list.get(i+1); 
				if (c.compare(t1, t2) > 0) {
					Collections.swap(list, i, i+1);
					swapped = true;
//					n--;
				}
			}
		} while (swapped == true);
	}

}
