/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.util;

import java.util.Comparator;

import org.modelevolution.multiview.Message;
import org.modelevolution.multiview.SequenceView;

/**
 * @author <a href="mailto:brosch@big.tuwien.ac.at">Petra Brosch</a>
 * 
 */
public class MessageComparator implements Comparator<Message> {

	@Override
	public int compare(Message msg1, Message msg2) {
		if (msg1 == null || msg2 == null) {
			return -1;
		} else if (msg1.equals(msg2)) {
			return 0;
		}
//		else if ((msg1.getSender() != null && msg1.getReceiver() != null
//				&& msg1.getSender().getLifeline() != null
//				&& msg1.getReceiver().getLifeline() != null
//				&& msg2.getSender() != null && msg2.getReceiver() != null
//				&& msg2.getSender().getLifeline() != null && msg2.getSender()
//				.getLifeline() != null)
//				&& ((!msg1.getSender().getLifeline()
//						.equals(msg2.getSender().getLifeline()))
//						&& (!msg1.getSender().getLifeline()
//								.equals(msg2.getReceiver().getLifeline()))
//						&& (!msg1.getReceiver().getLifeline()
//								.equals(msg2.getSender().getLifeline())) && (!msg1
//						.getReceiver().getLifeline()
//						.equals(msg2.getReceiver().getLifeline())))) {
//			return (msg1.getSender().getLifeline().getSequenceView()
//					.getLifelines().indexOf(msg1.getSender().getLifeline()) < msg2
//					.getSender().getLifeline().getSequenceView().getLifelines()
//					.indexOf(msg2.getSender().getLifeline())) ? -1 : 1;
//		}
		else if (((SequenceView) msg1.getSequenceView()).isSentBefore(msg1,
				msg2)) {
			return -1;
		} else {
			return 1;
		}
	}
}
