/**
 * <copyright>
 *
 * Copyright (c) 2012 modelevolution.org
 * All rights reserved. This program and the accompanying materials are
 * made available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * </copyright>
 */
package org.modelevolution.multiview.util;

import java.util.Comparator;

import org.modelevolution.multiview.State;

/**
 * @author <a href="mailto:brosch@big.tuwien.ac.at">Petra Brosch</a>
 * @param <T>
 *
 */
public class StateComparator implements Comparator<State> {

	@Override
	public int compare(State arg0, State arg1) {
		if (arg0 == null || arg0 == null)
			return -1;
		else if (arg0.equals(arg0))
			return 0;
		else if (arg0.getName().compareTo(arg1.getName()) == 0) return -1;
		return arg0.getName().compareTo(arg1.getName());
	}
}
